/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class WeakHashMap
extends AbstractMap
implements Map {
    private Map hash;
    private ReferenceQueue queue = new ReferenceQueue();
    private Set entrySet = null;

    private void processQueue() {
        WeakKey weakKey;
        while ((weakKey = (WeakKey)this.queue.poll()) != null) {
            this.hash.remove(weakKey);
        }
    }

    public WeakHashMap(int n, float f) {
        this.hash = new HashMap(n, f);
    }

    public WeakHashMap(int n) {
        this.hash = new HashMap(n);
    }

    public WeakHashMap() {
        this.hash = new HashMap();
    }

    public WeakHashMap(Map map) {
        this(Math.max(2 * map.size(), 11), 0.75f);
        this.putAll(map);
    }

    public int size() {
        return this.entrySet().size();
    }

    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    public boolean containsKey(Object object) {
        return this.hash.containsKey(WeakKey.create(object));
    }

    public Object get(Object object) {
        return this.hash.get(WeakKey.create(object));
    }

    public Object put(Object object, Object object2) {
        this.processQueue();
        return this.hash.put(WeakKey.create(object, this.queue), object2);
    }

    public Object remove(Object object) {
        this.processQueue();
        return this.hash.remove(WeakKey.create(object));
    }

    public void clear() {
        this.processQueue();
        this.hash.clear();
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    private class EntrySet
    extends AbstractSet {
        Set hashEntrySet;

        private EntrySet() {
            this.hashEntrySet = WeakHashMap.this.hash.entrySet();
        }

        public Iterator iterator() {
            return new Iterator(){
                Iterator hashIterator;
                Entry next;
                {
                    this.hashIterator = hashEntrySet.iterator();
                    this.next = null;
                }

                public boolean hasNext() {
                    while (this.hashIterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)this.hashIterator.next();
                        WeakKey weakKey = (WeakKey)entry.getKey();
                        Object object = null;
                        if (weakKey != null && (object = weakKey.get()) == null) continue;
                        this.next = new Entry(entry, object);
                        return true;
                    }
                    return false;
                }

                public Object next() {
                    if (this.next == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Entry entry = this.next;
                    this.next = null;
                    return entry;
                }

                public void remove() {
                    this.hashIterator.remove();
                }
            };
        }

        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        public int size() {
            int n = 0;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ++n;
                iterator.next();
            }
            return n;
        }

        public boolean remove(Object object) {
            WeakHashMap.this.processQueue();
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object object2 = entry.getValue();
            WeakKey weakKey = WeakKey.create(entry.getKey());
            Object object3 = WeakHashMap.this.hash.get(weakKey);
            boolean bl = object3 == null ? object2 == null && WeakHashMap.this.hash.containsKey(weakKey) : object3.equals(object2);
            if (bl) {
                WeakHashMap.this.hash.remove(weakKey);
                return true;
            }
            return false;
        }

        public int hashCode() {
            int n = 0;
            Iterator iterator = this.hashEntrySet.iterator();
            while (iterator.hasNext()) {
                Object object;
                Map.Entry entry = (Map.Entry)iterator.next();
                WeakKey weakKey = (WeakKey)entry.getKey();
                if (weakKey == null) continue;
                n += weakKey.hashCode() ^ ((object = entry.getValue()) == null ? 0 : object.hashCode());
            }
            return n;
        }
    }

    private static class Entry
    implements Map.Entry {
        private Map.Entry ent;
        private Object key;

        Entry(Map.Entry entry, Object object) {
            this.ent = entry;
            this.key = object;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.ent.getValue();
        }

        public Object setValue(Object object) {
            return this.ent.setValue(object);
        }

        private static boolean valEquals(Object object, Object object2) {
            return object == null ? object2 == null : object.equals(object2);
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return Entry.valEquals(this.key, entry.getKey()) && Entry.valEquals(this.getValue(), entry.getValue());
        }

        public int hashCode() {
            Object object = this.getValue();
            return (this.key == null ? 0 : this.key.hashCode()) ^ (object == null ? 0 : object.hashCode());
        }
    }

    private static class WeakKey
    extends WeakReference {
        private int hash;

        private WeakKey(Object object) {
            super(object);
            this.hash = object.hashCode();
        }

        private static WeakKey create(Object object) {
            if (object == null) {
                return null;
            }
            return new WeakKey(object);
        }

        private WeakKey(Object object, ReferenceQueue referenceQueue) {
            super(object, referenceQueue);
            this.hash = object.hashCode();
        }

        private static WeakKey create(Object object, ReferenceQueue referenceQueue) {
            if (object == null) {
                return null;
            }
            return new WeakKey(object, referenceQueue);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof WeakKey)) {
                return false;
            }
            Object object2 = this.get();
            Object object3 = ((WeakKey)object).get();
            if (object2 == null || object3 == null) {
                return false;
            }
            if (object2 == object3) {
                return true;
            }
            return object2.equals(object3);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

