/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.text.CharacterIterator;

public class Segment
implements Cloneable,
CharacterIterator {
    public char[] array;
    public int offset;
    public int count;
    private int pos;

    public Segment() {
        this.array = null;
        this.offset = 0;
        this.count = 0;
    }

    public Segment(char[] cArray, int n, int n2) {
        this.array = cArray;
        this.offset = n;
        this.count = n2;
    }

    public String toString() {
        if (this.array != null) {
            return new String(this.array, this.offset, this.count);
        }
        return new String();
    }

    public char first() {
        this.pos = this.offset;
        if (this.count != 0) {
            return this.array[this.pos];
        }
        return '\uffff';
    }

    public char last() {
        this.pos = this.offset + this.count;
        if (this.count != 0) {
            --this.pos;
            return this.array[this.pos];
        }
        return '\uffff';
    }

    public char current() {
        if (this.count != 0 && this.pos < this.offset + this.count) {
            return this.array[this.pos];
        }
        return '\uffff';
    }

    public char next() {
        ++this.pos;
        int n = this.offset + this.count;
        if (this.pos >= n) {
            this.pos = n;
            return '\uffff';
        }
        return this.current();
    }

    public char previous() {
        if (this.pos == this.offset) {
            return '\uffff';
        }
        --this.pos;
        return this.current();
    }

    public char setIndex(int n) {
        int n2 = this.offset + this.count;
        if (n < this.offset || n > n2) {
            throw new IllegalArgumentException("bad position: " + n);
        }
        this.pos = n;
        if (this.pos != n2 && this.count != 0) {
            return this.array[this.pos];
        }
        return '\uffff';
    }

    public int getBeginIndex() {
        return this.offset;
    }

    public int getEndIndex() {
        return this.offset + this.count;
    }

    public int getIndex() {
        return this.pos;
    }

    public Object clone() {
        Object object;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            object = null;
        }
        return object;
    }
}

