/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.awt.ScreenUpdaterEntry;
import sun.awt.UpdateClient;

public class ScreenUpdater
extends Thread {
    private ScreenUpdaterEntry first;
    public static final ScreenUpdater updater = ScreenUpdater.initScreenUpdater();

    private static ScreenUpdater initScreenUpdater() {
        return (ScreenUpdater)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new ScreenUpdater();
            }
        });
    }

    private static ThreadGroup getScreenUpdaterThreadGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null && threadGroup.getParent().getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }

    private ScreenUpdater() {
        super(ScreenUpdater.getScreenUpdaterThreadGroup(), "Screen Updater");
        this.setPriority(5);
        this.start();
    }

    private synchronized ScreenUpdaterEntry nextEntry() throws InterruptedException {
        while (true) {
            if (this.first == null) {
                this.wait();
                continue;
            }
            long l = this.first.when - System.currentTimeMillis();
            if (l <= 0L) {
                ScreenUpdaterEntry screenUpdaterEntry = this.first;
                this.first = this.first.next;
                return screenUpdaterEntry;
            }
            this.wait(l);
        }
    }

    public void run() {
        try {
            while (true) {
                ScreenUpdaterEntry screenUpdaterEntry = this.nextEntry();
                try {
                    screenUpdaterEntry.client.updateClient(screenUpdaterEntry.arg);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                screenUpdaterEntry = null;
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public void notify(UpdateClient updateClient) {
        this.notify(updateClient, 100L, null);
    }

    public synchronized void notify(UpdateClient updateClient, long l) {
        this.notify(updateClient, l, null);
    }

    public synchronized void notify(UpdateClient updateClient, long l, Object object) {
        ScreenUpdaterEntry screenUpdaterEntry;
        long l2;
        long l3 = System.currentTimeMillis() + l;
        long l4 = l2 = this.first != null ? this.first.when : -1L;
        if (this.first != null) {
            if (this.first.client == updateClient && this.first.arg == object) {
                if (l3 >= this.first.when) {
                    return;
                }
                this.first = this.first.next;
            } else {
                screenUpdaterEntry = this.first;
                while (screenUpdaterEntry.next != null) {
                    if (screenUpdaterEntry.next.client == updateClient && screenUpdaterEntry.next.arg == object) {
                        if (l3 >= screenUpdaterEntry.next.when) {
                            return;
                        }
                        screenUpdaterEntry.next = screenUpdaterEntry.next.next;
                        break;
                    }
                    screenUpdaterEntry = screenUpdaterEntry.next;
                }
            }
        }
        if (this.first == null || this.first.when > l3) {
            this.first = new ScreenUpdaterEntry(updateClient, l3, object, this.first);
        } else {
            screenUpdaterEntry = this.first;
            while (true) {
                if (screenUpdaterEntry.next == null || screenUpdaterEntry.next.when > l3) {
                    screenUpdaterEntry.next = new ScreenUpdaterEntry(updateClient, l3, object, screenUpdaterEntry.next);
                    break;
                }
                screenUpdaterEntry = screenUpdaterEntry.next;
            }
        }
        if (l2 != this.first.when) {
            super.notify();
        }
    }

    public synchronized void removeClient(UpdateClient updateClient) {
        ScreenUpdaterEntry screenUpdaterEntry = this.first;
        ScreenUpdaterEntry screenUpdaterEntry2 = null;
        while (screenUpdaterEntry != null) {
            if (screenUpdaterEntry.client.equals(updateClient)) {
                if (screenUpdaterEntry2 == null) {
                    this.first = screenUpdaterEntry.next;
                } else {
                    screenUpdaterEntry2.next = screenUpdaterEntry.next;
                }
            } else {
                screenUpdaterEntry2 = screenUpdaterEntry;
            }
            screenUpdaterEntry = screenUpdaterEntry.next;
        }
    }
}

