/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.FilePermission;
import java.util.ArrayList;
import sun.awt.image.ByteInterleavedRaster;
import sun.java2d.OpenBook;
import sun.java2d.PathGraphics;
import sun.java2d.PeekGraphics;
import sun.java2d.ProxyGraphics2D;

public abstract class RasterPrinterJob
extends PrinterJob {
    private static final int MAX_BAND_SIZE = 524288;
    private int mNumCopies = 1;
    private boolean mCollate = false;
    private int mFirstPage = -1;
    private int mLastPage = -1;
    private Pageable mDocument = new Book();
    private String mDocName = new String("Java Printing");
    private boolean performingPrinting = false;
    private boolean userCancelled = false;
    private FilePermission printToFilePermission;
    private ArrayList redrawList = new ArrayList();

    protected abstract double getXRes();

    protected abstract double getYRes();

    protected abstract double getPhysicalPrintableX(Paper var1);

    protected abstract double getPhysicalPrintableY(Paper var1);

    protected abstract double getPhysicalPrintableWidth(Paper var1);

    protected abstract double getPhysicalPrintableHeight(Paper var1);

    protected abstract double getPhysicalPageWidth(Paper var1);

    protected abstract double getPhysicalPageHeight(Paper var1);

    protected abstract void startPage(PageFormat var1, Printable var2, int var3) throws PrinterException;

    protected abstract void endPage(PageFormat var1, Printable var2, int var3) throws PrinterException;

    protected abstract void printBand(byte[] var1, int var2, int var3, int var4, int var5) throws PrinterException;

    public void saveState(AffineTransform affineTransform, Shape shape, Rectangle2D rectangle2D, double d, double d2, Rectangle2D rectangle2D2, AffineTransform affineTransform2) {
        GraphicsState graphicsState = new GraphicsState();
        graphicsState.theTransform = affineTransform;
        graphicsState.theClip = shape;
        graphicsState.region = rectangle2D;
        graphicsState.sx = d;
        graphicsState.sy = d2;
        graphicsState.imageTransform = affineTransform2;
        graphicsState.imageSrcRect = rectangle2D2;
        this.redrawList.add(graphicsState);
    }

    public void setPrintable(Printable printable) {
        this.setPageable(new OpenBook(this.defaultPage(new PageFormat()), printable));
    }

    public void setPrintable(Printable printable, PageFormat pageFormat) {
        this.setPageable(new OpenBook(pageFormat, printable));
    }

    public void setPageable(Pageable pageable) throws NullPointerException {
        if (pageable == null) {
            throw new NullPointerException();
        }
        this.mDocument = pageable;
    }

    protected void initPrinter() {
    }

    public void print() throws PrinterException {
        RasterPrinterJob rasterPrinterJob;
        int n;
        this.initPrinter();
        int n2 = this.getCollatedCopies();
        int n3 = this.getNoncollatedCopies();
        int n4 = this.mDocument.getNumberOfPages();
        int n5 = this.getFirstPage();
        int n6 = this.getLastPage();
        if (n6 == -1 && (n = this.mDocument.getNumberOfPages()) != -1) {
            n6 = this.mDocument.getNumberOfPages() - 1;
        }
        try {
            RasterPrinterJob rasterPrinterJob2 = this;
            synchronized (rasterPrinterJob2) {
                this.performingPrinting = true;
                this.userCancelled = false;
            }
            this.startDoc();
            if (this.isCancelled()) {
                this.cancelDoc();
            }
            int n7 = 0;
            while (n7 < n2) {
                int n8 = n5;
                int n9 = 0;
                while ((n8 <= n6 || n6 == -1) && n9 == 0) {
                    int n10 = 0;
                    while (n10 < n3 && n9 == 0) {
                        if (this.isCancelled()) {
                            this.cancelDoc();
                        }
                        n9 = this.printPage(this.mDocument, n8);
                        ++n10;
                    }
                    ++n8;
                }
                ++n7;
            }
            if (this.isCancelled()) {
                this.cancelDoc();
            }
            Object var12_13 = null;
            rasterPrinterJob = this;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            RasterPrinterJob rasterPrinterJob3 = this;
            synchronized (rasterPrinterJob3) {
                if (this.performingPrinting) {
                    this.endDoc();
                }
                this.performingPrinting = false;
                this.notify();
            }
            throw throwable;
        }
        synchronized (rasterPrinterJob) {
            if (this.performingPrinting) {
                this.endDoc();
            }
            this.performingPrinting = false;
            this.notify();
        }
    }

    protected void validatePaper(Paper paper, Paper paper2) {
        if (paper == null || paper2 == null) {
            return;
        }
        double d = paper.getWidth();
        double d2 = paper.getHeight();
        double d3 = paper.getImageableX();
        double d4 = paper.getImageableY();
        double d5 = paper.getImageableWidth();
        double d6 = paper.getImageableHeight();
        Paper paper3 = new Paper();
        d = d > 0.0 ? d : paper3.getWidth();
        d2 = d2 > 0.0 ? d2 : paper3.getHeight();
        d3 = d3 > 0.0 ? d3 : paper3.getImageableX();
        d4 = d4 > 0.0 ? d4 : paper3.getImageableY();
        d5 = d5 > 0.0 ? d5 : paper3.getImageableWidth();
        double d7 = d6 = d6 > 0.0 ? d6 : paper3.getImageableHeight();
        if (d5 > d) {
            d5 = d;
        }
        if (d6 > d2) {
            d6 = d2;
        }
        if (d3 + d5 > d) {
            d3 = d - d5;
        }
        if (d4 + d6 > d2) {
            d4 = d2 - d6;
        }
        paper2.setSize(d, d2);
        paper2.setImageableArea(d3, d4, d5, d6);
    }

    public PageFormat defaultPage(PageFormat pageFormat) {
        PageFormat pageFormat2 = (PageFormat)pageFormat.clone();
        pageFormat2.setOrientation(1);
        Paper paper = new Paper();
        pageFormat2.setPaper(paper);
        return pageFormat2;
    }

    public PageFormat validatePage(PageFormat pageFormat) {
        PageFormat pageFormat2 = (PageFormat)pageFormat.clone();
        Paper paper = new Paper();
        this.validatePaper(pageFormat2.getPaper(), paper);
        pageFormat2.setPaper(paper);
        return pageFormat2;
    }

    public void setCopies(int n) {
        this.mNumCopies = n;
    }

    public int getCopies() {
        return this.mNumCopies;
    }

    public String getUserName() {
        return System.getProperty("user.name");
    }

    public void setJobName(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.mDocName = string;
    }

    public String getJobName() {
        return this.mDocName;
    }

    protected void setPageRange(int n, int n2) {
        if (n >= 0 && n2 >= 0) {
            this.mFirstPage = n;
            this.mLastPage = n2;
            if (this.mLastPage < this.mFirstPage) {
                this.mLastPage = this.mFirstPage;
            }
        } else {
            this.mFirstPage = -1;
            this.mLastPage = -1;
        }
    }

    protected int getFirstPage() {
        return this.mFirstPage == -1 ? 0 : this.mFirstPage;
    }

    protected int getLastPage() {
        return this.mLastPage;
    }

    protected void setCollated(boolean bl) {
        this.mCollate = bl;
    }

    protected boolean isCollated() {
        return this.mCollate;
    }

    protected abstract void startDoc() throws PrinterException;

    protected abstract void endDoc() throws PrinterException;

    protected abstract void abortDoc();

    private void cancelDoc() throws PrinterAbortException {
        this.abortDoc();
        RasterPrinterJob rasterPrinterJob = this;
        synchronized (rasterPrinterJob) {
            this.userCancelled = false;
            this.performingPrinting = false;
            this.notify();
        }
        throw new PrinterAbortException();
    }

    protected int getCollatedCopies() {
        return this.isCollated() ? this.getCopies() : 1;
    }

    protected int getNoncollatedCopies() {
        return this.isCollated() ? 1 : this.getCopies();
    }

    protected int printPage(Pageable pageable, int n) throws PrinterException {
        PageFormat pageFormat = pageable.getPageFormat(n);
        Printable printable = pageable.getPrintable(n);
        Paper paper = pageFormat.getPaper();
        double d = this.getXRes() / 72.0;
        double d2 = this.getYRes() / 72.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double(paper.getImageableX() * d, paper.getImageableY() * d2, paper.getImageableWidth() * d, paper.getImageableHeight() * d2);
        AffineTransform affineTransform = new AffineTransform();
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.scale(d, d2);
        int n2 = (int)((RectangularShape)double_).getWidth();
        n2 += n2 % 4;
        int n3 = (int)((RectangularShape)double_).getHeight();
        int n4 = 524288 / n3 / 3;
        int n5 = (int)(paper.getImageableX() * d);
        int n6 = (int)(paper.getImageableY() * d2);
        AffineTransform affineTransform3 = new AffineTransform();
        affineTransform3.translate(-n5, n6);
        affineTransform3.translate(0.0, n4);
        affineTransform3.scale(1.0, -1.0);
        BufferedImage bufferedImage = new BufferedImage(n2, n4, 5);
        PeekGraphics peekGraphics = this.createPeekGraphics(bufferedImage.createGraphics(), this);
        Rectangle2D.Double double_2 = new Rectangle2D.Double(pageFormat.getImageableX(), pageFormat.getImageableY(), pageFormat.getImageableWidth(), pageFormat.getImageableHeight());
        this.initPrinterGraphics(peekGraphics, double_2);
        int n7 = printable.print(peekGraphics, pageFormat, n);
        if (n7 == 0) {
            this.startPage(pageFormat, printable, n);
            Graphics2D graphics2D = this.createPathGraphics(peekGraphics, this, printable, pageFormat, n);
            if (graphics2D != null) {
                graphics2D.transform(affineTransform2);
                graphics2D.translate(-this.getPhysicalPrintableX(paper) / d, -this.getPhysicalPrintableY(paper) / d2);
                graphics2D.transform(new AffineTransform(pageFormat.getMatrix()));
                this.initPrinterGraphics(graphics2D, double_2);
                this.redrawList.clear();
                printable.print(graphics2D, pageFormat, n);
                int n8 = 0;
                while (n8 < this.redrawList.size()) {
                    GraphicsState graphicsState = (GraphicsState)this.redrawList.get(n8);
                    graphics2D.setTransform(graphicsState.theTransform);
                    graphics2D.setClip(graphicsState.theClip);
                    ((PathGraphics)graphics2D).redrawRegion(graphicsState.region, graphicsState.sx, graphicsState.sy, graphicsState.imageSrcRect, graphicsState.imageTransform);
                    ++n8;
                }
            } else {
                Graphics2D graphics2D2 = bufferedImage.createGraphics();
                Rectangle2D.Double double_3 = new Rectangle2D.Double(0.0, 0.0, n2, n4);
                this.initPrinterGraphics(graphics2D2, double_3);
                ProxyGraphics2D proxyGraphics2D = new ProxyGraphics2D(graphics2D2, this);
                Graphics2D graphics2D3 = bufferedImage.createGraphics();
                graphics2D3.setColor(Color.white);
                ByteInterleavedRaster byteInterleavedRaster = (ByteInterleavedRaster)bufferedImage.getRaster();
                byte[] byArray = byteInterleavedRaster.getDataStorage();
                int n9 = n6 + n3;
                int n10 = 0;
                while (n10 <= n3) {
                    graphics2D3.fillRect(0, 0, n2, n4);
                    graphics2D2.setTransform(affineTransform);
                    graphics2D2.transform(affineTransform3);
                    affineTransform3.translate(0.0, -n4);
                    graphics2D2.transform(affineTransform2);
                    graphics2D2.transform(new AffineTransform(pageFormat.getMatrix()));
                    Rectangle rectangle = graphics2D2.getClipBounds();
                    if (peekGraphics.hitsDrawingArea(rectangle)) {
                        proxyGraphics2D.setDelegate((Graphics2D)graphics2D2.create());
                        printable.print(proxyGraphics2D, pageFormat, n);
                        proxyGraphics2D.dispose();
                        this.printBand(byArray, n5, n6 + n10, n2, n4);
                    }
                    n10 += n4;
                }
                graphics2D3.dispose();
                graphics2D2.dispose();
            }
            this.endPage(pageFormat, printable, n);
        }
        return n7;
    }

    public void cancel() {
        RasterPrinterJob rasterPrinterJob = this;
        synchronized (rasterPrinterJob) {
            if (this.performingPrinting) {
                this.userCancelled = true;
            }
            this.notify();
        }
    }

    public boolean isCancelled() {
        boolean bl = false;
        RasterPrinterJob rasterPrinterJob = this;
        synchronized (rasterPrinterJob) {
            bl = this.performingPrinting && this.userCancelled;
            this.notify();
        }
        return bl;
    }

    protected Pageable getPageable() {
        return this.mDocument;
    }

    protected Graphics2D createPathGraphics(PeekGraphics peekGraphics, PrinterJob printerJob, Printable printable, PageFormat pageFormat, int n) {
        return null;
    }

    protected PeekGraphics createPeekGraphics(Graphics2D graphics2D, PrinterJob printerJob) {
        return new PeekGraphics(graphics2D, printerJob);
    }

    void initPrinterGraphics(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        graphics2D.setClip(rectangle2D);
        graphics2D.setPaint(Color.black);
    }

    public boolean checkAllowedToPrintToFile() {
        try {
            this.throwPrintToFile();
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private void throwPrintToFile() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (this.printToFilePermission == null) {
                this.printToFilePermission = new FilePermission("<<ALL FILES>>", "read,write");
            }
            securityManager.checkPermission(this.printToFilePermission);
        }
    }

    private class GraphicsState {
        Rectangle2D region;
        Shape theClip;
        AffineTransform theTransform;
        double sx;
        double sy;
        Rectangle2D imageSrcRect;
        AffineTransform imageTransform;

        private GraphicsState() {
        }
    }
}

