/* ****** BEGIN LICENSE BLOCK *****
Version: MPL 1.1/GPL 2.0/LGPL 2.1

The contents of this file are subject to the Mozilla Public License Version 
1.1 (the "License"); you may not use this file except in compliance with 
the License. You may obtain a copy of the License at 
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is Checky Toolbar.

The Initial Developer of the Original Code is
Joachim Schreiber (yo@yos.biz).
Portions created by the Initial Developer are Copyright (C) 2002
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

The Checky plug-in is a simple Interface for Web Content and 
Web Page Developers to free and commercial Validator and Checker 
Services on the Web. We do not provide any support or guarantee. 
Any rights not expressly granted herein are reserved by their owners. 
Please visit the Web Sites of the Service owners for more informations 
about terms of usage before using Checky the first. Hyperlinks are 
located at http://checky.mozdev.org/services.html

***** END LICENSE BLOCK ***** */


const X_MSG = 	   "Install Checky 0.5";
const X_NAME =     "/checky";
const X_VER  =     "0.5";
const X_JAR_FILE = "checky.jar";

const X_CHROME =   "chrome";
const X_CONTENT =  "content/checky/";
const X_SKIN = 	   "skin/";
const X_LOCALE1 =  "locale/en-US/checky/";
const X_LOCALE2 =  "locale/de-AT/checky/";

var err = initInstall(X_MSG, X_NAME, X_VER);
logComment("initInstall: " + err);
logComment("Installation started...");

resetError();
addFile(X_NAME, X_JAR_FILE, getFolder(X_CHROME), "");
err = getLastError();
if (err == SUCCESS || err == REBOOT_NEEDED) {
  registerChrome(DELAYED_CHROME | CONTENT, getFolder(X_CHROME, X_JAR_FILE), X_CONTENT);
  registerChrome(DELAYED_CHROME | SKIN, getFolder(X_CHROME, X_JAR_FILE), X_SKIN);
  registerChrome(DELAYED_CHROME | LOCALE, getFolder(X_CHROME, X_JAR_FILE), X_LOCALE1);
  registerChrome(DELAYED_CHROME | LOCALE, getFolder(X_CHROME, X_JAR_FILE), X_LOCALE2);
}
err = getLastError();
if (err == SUCCESS || err == REBOOT_NEEDED) {
  performInstall();
  err = getLastError();
  if (err == SUCCESS || err == REBOOT_NEEDED) {
    alert("Please restart mozilla");
  } else {
    // Nothing to do, Mozilla will display an error message himself
  }
} else {
  cancelInstall();
  if (err == -202) {
    alert("You need to have write permissions to the chrome directory:\n" + 
          getFolder(X_CHROME));
  } else if (err == -210) {
    alert("Installation cancelled by user");
  }else {
    alert("An unknown error occured.  Error code: " + err + "\n" + 
          "Look at the following URL for a description of the error code:\n" +
          "http://devedge.netscape.com/library/manuals/2001/xpinstall/1.0/err.html");
  }
}

