/*$Id: Wrap.h,v 1.7 2006/10/06 21:18:20 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

#ifndef WRAP_H
#define WRAP_H

/****************************************************************/
/*Wrapping routines similar to these introduced by Richard Stevens
 *in his "UNIX Network Programming". They reduce lenght of fatal error
 *detection code.
 *Coding convention: Function which name starts with capital
 *letter calls suitable libc function and when it fails it 
 *reports fatal error and interrupts application.

 *TODO: handle errors more gently
 */


#include "Error.h"
#include "Common.h"



inline void *Malloc(int size)
{
	void *r = malloc(size);
	if (!r)
		err_sys("malloc %u", size);
	return r;
}


inline void Pcre_get_substring(const char *subject, int *ovector,
			int stringcount, int stringnumber,
			const char **stringptr)
{
	if (pcre_get_substring(subject, ovector, stringcount, 
			       stringnumber, stringptr) < 0)
		err_sys("not enough memory");
}

#endif
