/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM ./nsITransport.idl
 */

#ifndef __gen_nsITransport_h__
#define __gen_nsITransport_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIInputStream; /* forward declaration */

class nsIOutputStream; /* forward declaration */

class nsITransportEventSink; /* forward declaration */

class nsIEventQueue; /* forward declaration */


/* starting interface:    nsITransport */
#define NS_ITRANSPORT_IID_STR "cbb0baeb-5fcb-408b-a2be-9f8fc98d0af1"

#define NS_ITRANSPORT_IID \
  {0xcbb0baeb, 0x5fcb, 0x408b, \
    { 0xa2, 0xbe, 0x9f, 0x8f, 0xc9, 0x8d, 0x0a, 0xf1 }}

class NS_NO_VTABLE nsITransport : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_ITRANSPORT_IID)

  /**
     * Open flags.
     */
  enum { OPEN_BLOCKING = 1U };

  enum { OPEN_UNBUFFERED = 2U };

  /**
     * Open an input stream on this transport.
     *
     * @param aFlags
     *        optional transport specific flags.
     * @param aSegmentSize
     *        if OPEN_UNBUFFERED is not set, then this parameter specifies the
     *        size of each buffer segment (pass 0 to use default value).
     * @param aSegmentCount
     *        if OPEN_UNBUFFERED is not set, then this parameter specifies the
     *        maximum number of buffer segments (pass 0 to use default value).
     */
  /* nsIInputStream openInputStream (in unsigned long aFlags, in unsigned long aSegmentSize, in unsigned long aSegmentCount); */
  NS_IMETHOD OpenInputStream(PRUint32 aFlags, PRUint32 aSegmentSize, PRUint32 aSegmentCount, nsIInputStream **_retval) = 0;

  /**
     * Open an output stream on this transport.
     *
     * @param aFlags
     *        optional transport specific flags.
     * @param aSegmentSize
     *        if OPEN_UNBUFFERED is not set, then this parameter specifies the
     *        size of each buffer segment (pass 0 to use default value).
     * @param aSegmentCount
     *        if OPEN_UNBUFFERED is not set, then this parameter specifies the
     *        maximum number of buffer segments (pass 0 to use default value).
     */
  /* nsIOutputStream openOutputStream (in unsigned long aFlags, in unsigned long aSegmentSize, in unsigned long aSegmentCount); */
  NS_IMETHOD OpenOutputStream(PRUint32 aFlags, PRUint32 aSegmentSize, PRUint32 aSegmentCount, nsIOutputStream **_retval) = 0;

  /**
     * Close the transport and any open streams.
     *
     * @param aReason
     *        the reason for closing the stream.
     */
  /* void close (in nsresult aReason); */
  NS_IMETHOD Close(nsresult aReason) = 0;

  /**
     * Set the transport event sink.
     *
     * @param aSink
     *        receives transport layer notifications
     * @param aEventQ
     *        indicates the event queue to which the notifications should
     *        be delivered.  if NULL, then the notifications may occur on
     *        any thread.  (NOTE: the event queue must be resolved.)
     */
  /* void setEventSink (in nsITransportEventSink aSink, in nsIEventQueue aEventQ); */
  NS_IMETHOD SetEventSink(nsITransportEventSink *aSink, nsIEventQueue *aEventQ) = 0;

  /**
     * Generic nsITransportEventSink status codes.  nsITransport
     * implementations may override these status codes with their own more
     * specific status codes (e.g., see nsISocketTransport).
     */
  enum { STATUS_READING = 2152398856U };

  enum { STATUS_WRITING = 2152398857U };

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSITRANSPORT \
  NS_IMETHOD OpenInputStream(PRUint32 aFlags, PRUint32 aSegmentSize, PRUint32 aSegmentCount, nsIInputStream **_retval); \
  NS_IMETHOD OpenOutputStream(PRUint32 aFlags, PRUint32 aSegmentSize, PRUint32 aSegmentCount, nsIOutputStream **_retval); \
  NS_IMETHOD Close(nsresult aReason); \
  NS_IMETHOD SetEventSink(nsITransportEventSink *aSink, nsIEventQueue *aEventQ); \

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSITRANSPORT(_to) \
  NS_IMETHOD OpenInputStream(PRUint32 aFlags, PRUint32 aSegmentSize, PRUint32 aSegmentCount, nsIInputStream **_retval) { return _to OpenInputStream(aFlags, aSegmentSize, aSegmentCount, _retval); } \
  NS_IMETHOD OpenOutputStream(PRUint32 aFlags, PRUint32 aSegmentSize, PRUint32 aSegmentCount, nsIOutputStream **_retval) { return _to OpenOutputStream(aFlags, aSegmentSize, aSegmentCount, _retval); } \
  NS_IMETHOD Close(nsresult aReason) { return _to Close(aReason); } \
  NS_IMETHOD SetEventSink(nsITransportEventSink *aSink, nsIEventQueue *aEventQ) { return _to SetEventSink(aSink, aEventQ); } \

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSITRANSPORT(_to) \
  NS_IMETHOD OpenInputStream(PRUint32 aFlags, PRUint32 aSegmentSize, PRUint32 aSegmentCount, nsIInputStream **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->OpenInputStream(aFlags, aSegmentSize, aSegmentCount, _retval); } \
  NS_IMETHOD OpenOutputStream(PRUint32 aFlags, PRUint32 aSegmentSize, PRUint32 aSegmentCount, nsIOutputStream **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->OpenOutputStream(aFlags, aSegmentSize, aSegmentCount, _retval); } \
  NS_IMETHOD Close(nsresult aReason) { return !_to ? NS_ERROR_NULL_POINTER : _to->Close(aReason); } \
  NS_IMETHOD SetEventSink(nsITransportEventSink *aSink, nsIEventQueue *aEventQ) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetEventSink(aSink, aEventQ); } \

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsTransport : public nsITransport
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSITRANSPORT

  nsTransport();
  virtual ~nsTransport();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsTransport, nsITransport)

nsTransport::nsTransport()
{
  /* member initializers and constructor code */
}

nsTransport::~nsTransport()
{
  /* destructor code */
}

/* nsIInputStream openInputStream (in unsigned long aFlags, in unsigned long aSegmentSize, in unsigned long aSegmentCount); */
NS_IMETHODIMP nsTransport::OpenInputStream(PRUint32 aFlags, PRUint32 aSegmentSize, PRUint32 aSegmentCount, nsIInputStream **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIOutputStream openOutputStream (in unsigned long aFlags, in unsigned long aSegmentSize, in unsigned long aSegmentCount); */
NS_IMETHODIMP nsTransport::OpenOutputStream(PRUint32 aFlags, PRUint32 aSegmentSize, PRUint32 aSegmentCount, nsIOutputStream **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void close (in nsresult aReason); */
NS_IMETHODIMP nsTransport::Close(nsresult aReason)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setEventSink (in nsITransportEventSink aSink, in nsIEventQueue aEventQ); */
NS_IMETHODIMP nsTransport::SetEventSink(nsITransportEventSink *aSink, nsIEventQueue *aEventQ)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsITransportEventSink */
#define NS_ITRANSPORTEVENTSINK_IID_STR "561de8af-1b74-4cd4-8479-89447d48185c"

#define NS_ITRANSPORTEVENTSINK_IID \
  {0x561de8af, 0x1b74, 0x4cd4, \
    { 0x84, 0x79, 0x89, 0x44, 0x7d, 0x48, 0x18, 0x5c }}

class NS_NO_VTABLE nsITransportEventSink : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_ITRANSPORTEVENTSINK_IID)

  /**
     * Transport status notification.
     *
     * @param aTransport
     *        the transport sending this status notification.
     * @param aStatus
     *        the transport status (resolvable to a string using
     *        nsIErrorService).
     * @param aProgress
     *        the amount of data either read or written depending on the value
     *        of the status code.  this value is relative to aProgressMax.
     * @param aProgressMax
     *        the maximum amount of data that will be read or written.  if
     *        unknown, 0xFFFFFFFF will be passed.
     */
  /* void onTransportStatus (in nsITransport aTransport, in nsresult aStatus, in unsigned long aProgress, in unsigned long aProgressMax); */
  NS_IMETHOD OnTransportStatus(nsITransport *aTransport, nsresult aStatus, PRUint32 aProgress, PRUint32 aProgressMax) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSITRANSPORTEVENTSINK \
  NS_IMETHOD OnTransportStatus(nsITransport *aTransport, nsresult aStatus, PRUint32 aProgress, PRUint32 aProgressMax); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSITRANSPORTEVENTSINK(_to) \
  NS_IMETHOD OnTransportStatus(nsITransport *aTransport, nsresult aStatus, PRUint32 aProgress, PRUint32 aProgressMax) { return _to OnTransportStatus(aTransport, aStatus, aProgress, aProgressMax); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSITRANSPORTEVENTSINK(_to) \
  NS_IMETHOD OnTransportStatus(nsITransport *aTransport, nsresult aStatus, PRUint32 aProgress, PRUint32 aProgressMax) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnTransportStatus(aTransport, aStatus, aProgress, aProgressMax); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsTransportEventSink : public nsITransportEventSink
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSITRANSPORTEVENTSINK

  nsTransportEventSink();
  virtual ~nsTransportEventSink();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsTransportEventSink, nsITransportEventSink)

nsTransportEventSink::nsTransportEventSink()
{
  /* member initializers and constructor code */
}

nsTransportEventSink::~nsTransportEventSink()
{
  /* destructor code */
}

/* void onTransportStatus (in nsITransport aTransport, in nsresult aStatus, in unsigned long aProgress, in unsigned long aProgressMax); */
NS_IMETHODIMP nsTransportEventSink::OnTransportStatus(nsITransport *aTransport, nsresult aStatus, PRUint32 aProgress, PRUint32 aProgressMax)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsITransport_h__ */
