#!/usr/bin/python2.2
# 
# Copyright 2002, 2003 Zuza Software Foundation
# 
# This file is part of mozpotools.
#
# mozpotools is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# mozpotools is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with mozpotools; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""simple script to convert a mozilla .properties localization file to a
gettext .pot format for translation.
does a line-by-line conversion... reads from stdin, writes to stdout"""

from __future__ import generators
import sys
import extract

# the rstripeols convert dos <-> unix nicely as well
# output will be appropriate for the platform

inmultilinemsgid = 0

print '''# extracted from unknown file
msgid ""
msgstr ""
"Project-Id-Version: PACKAGE VERSION\\n"
"POT-Creation-Date: 2002-07-15 17:13+0100\\n"
"PO-Revision-Date: YEAR-MO-DA HO:MI+ZONE\\n"
"Last-Translator: FULL NAME <EMAIL@ADDRESS>\\n"
"Language-Team: LANGUAGE <LL@li.org>\\n"
"MIME-Version: 1.0\\n"
"Content-Type: text/plain; charset=ISO-8859-1\\n"
"Content-Transfer-Encoding: ENCODING\\n"'''

for line in sys.stdin.xreadlines():
  # escape unicode
  line = extract.escapeunicode(line)
  # handle multiline msgid if we're in one
  if inmultilinemsgid:
    msgid = extract.rstripeol(line).strip()
    # see if there's more
    inmultilinemsgid = (msgid[-1:] == '\\')
    # if we're still waiting for more...
    if inmultilinemsgid:
      # strip the backslash
      msgid = msgid[:-1]
    print extract.quotestr(msgid)
    if not inmultilinemsgid:
      # we're finished, print the msgstr
      print 'msgstr ""'
  # otherwise, this could be a comment
  elif line.strip()[:1] == '#':
    print extract.rstripeol(line)
  else:
    equalspos = line.find('=')
    # if no equals, just repeat it
    if equalspos == -1:
      print extract.rstripeol(line)
    # otherwise, this is a definition
    else:
      name = line[:equalspos].strip()
      msgid = extract.rstripeol(line[equalspos+1:]).strip()
      # simply ignore anything with blank msgid
      if len(msgid) > 0:
        print "#: "+name
        # backslash at end means carry string on to next line
        if msgid[-1:] == '\\':
          inmultilinemsgid = 1
          print 'msgid ""'
          print extract.quotestr(msgid[:-1]) # don't print the backslash
        else:
          print "msgid "+extract.quotestr(msgid)
          print 'msgstr ""'


