/****************************************************************************
**  LatchWordBB - Vocabulary retention and reinforcement toolbar for Mozilla
**  Copyright (c) 2003  Charles Melhorn
**
**  This file is part of LatchWordBB.
**
**  LatchWordBB is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  LatchWordBB is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**
**  Or see the GNU web site at: http://www.gnu.org
**
****************************************************************************/ 

var gRefInfoArr = 
[
  {"pref-col": true, "name-col": "", "url-col": ""},
  {"pref-col": true, "name-col": "", "url-col": ""},
  {"pref-col": true, "name-col": "", "url-col": ""},
  {"pref-col": true, "name-col": "", "url-col": ""},
  {"pref-col": true, "name-col": "", "url-col": ""},
];

var gWodInfoArr = 
[
  {"pref-col": true, "name-col": "", "url-col": ""},
  {"pref-col": true, "name-col": "", "url-col": ""},
  {"pref-col": true, "name-col": "", "url-col": ""},
  {"pref-col": true, "name-col": "", "url-col": ""},
  {"pref-col": true, "name-col": "", "url-col": ""},
];


function gRefTreeView(info_arr) 
{
  this.rowCount = info_arr.length;
  this.infoSrc = info_arr;
}

gRefTreeView.prototype =
{  
  setCellText : function(row, columnid, text)
     {
       if (columnid != "pref-col")
         this.infoSrc[row][columnid] = text;
     },
     
  getCellText : function(row, columnid)
     {
       if (columnid == "pref-col")
         rv = "";
       else
         rv = this.infoSrc[row][columnid];

       return rv;
     },

  getCellProperties: function(row, columnid, props)
     {
       if (columnid == "pref-col")
        {
          prop_str = (this.infoSrc[row][columnid] ? "preferred" : "unpreferred");

          var aserv = Components.classes["@mozilla.org/atom-service;1"].
                      createInstance(Components.interfaces.nsIAtomService);
          props.AppendElement(aserv.getAtom(prop_str));
        }
       else
        {
          if (row == 0)
           {
             var aserv = Components.classes["@mozilla.org/atom-service;1"].
                         createInstance(Components.interfaces.nsIAtomService);
             props.AppendElement(aserv.getAtom("default"));
           }
        }
     },

  setTree: function(treebox){ this.treebox = treebox; },
  isContainer: function(row){ return false; },
  isSeparator: function(row){ return false; },
  isSorted: function(row){ return false; },
  getLevel: function(row){ return 0; },
  getImageSrc: function(row,col){ return null; },
  getRowProperties: function(row,props){},
  getColumnProperties: function(colid,col,props){}

};


function initLWPrefDialog()
{
  var name_pref, url_pref, preferred_pref;


  // drill panel

  var quiztype_rgroup = document.getElementById("lw-quiztype-rgroup"); 
  var quiztype = window.arguments[0].getPrefValue("quiz_type");
  var ele_arr = quiztype_rgroup.getElementsByAttribute("value", String(quiztype));
  quiztype_rgroup.selectedItem = ele_arr[0];

  var quizmode_rgroup = document.getElementById("lw-quizmode-rgroup"); 
  var quizmode = window.arguments[0].getPrefValue("quiz_mode");
  var ele_arr = quizmode_rgroup.getElementsByAttribute("value", String(quizmode));
  quizmode_rgroup.selectedItem = ele_arr[0];

  var auto_interval = window.arguments[0].getPrefValue("auto_interval");
  document.getElementById("lw-autointerval-tbox").value = auto_interval;

  var auto_pause = window.arguments[0].getPrefValue("auto_answer_pause");
  document.getElementById("lw-autopause-tbox").value = auto_pause;

  var hint_cpicker = document.getElementById("lw-hintcolor-cpick");
  var pref_color = window.arguments[0].getPrefValue("hintbox_color");
  hint_cpicker.color = pref_color;

  var fontsize_mlist = document.getElementById("lw-fontsize-mlist");
  var pref_fontsize = window.arguments[0].getPrefValue("drill_font_size");
  fontsize_mlist.value = pref_fontsize;

  var pref_autohint = window.arguments[0].getPrefValue("autohint");
  document.getElementById("lw-autohint-cb").checked = pref_autohint;


  // references panel

  var refopen_rgroup = document.getElementById("lw-refopen-rgroup"); 
  var pref_openmethod = window.arguments[0].getPrefValue("lookup_openmethod");
  ele_arr = refopen_rgroup.getElementsByAttribute("value", String(pref_openmethod));
  refopen_rgroup.selectedItem = ele_arr[0];

  for (var i=0; i < gRefInfoArr.length; i++)
   {
     name_pref = "lookup_name" + (i+1);
     url_pref = "lookup_URL" + (i+1);
     preferred_pref = "lookup_pref" + (i+1);
     gRefInfoArr[i]["name-col"] = window.arguments[0].getPrefValue(name_pref);
     gRefInfoArr[i]["url-col"] = window.arguments[0].getPrefValue(url_pref);
     gRefInfoArr[i]["pref-col"] = window.arguments[0].getPrefValue(preferred_pref);
   }

  document.getElementById("lw-searchresources-tree").view = new gRefTreeView(gRefInfoArr);


  // WOD panel

  var wodopen_rgroup = document.getElementById("lw-wodopen-rgroup"); 
  pref_openmethod = window.arguments[0].getPrefValue("wod_openmethod");
  ele_arr = wodopen_rgroup.getElementsByAttribute("value", String(pref_openmethod));
  wodopen_rgroup.selectedItem = ele_arr[0];

  for (var i=0; i < gWodInfoArr.length; i++)
   {
     name_pref = "wod_name" + (i+1);
     url_pref = "wod_URL" + (i+1);
     preferred_pref = "wod_pref" + (i+1);
     gWodInfoArr[i]["name-col"] = window.arguments[0].getPrefValue(name_pref);
     gWodInfoArr[i]["url-col"] = window.arguments[0].getPrefValue(url_pref);
     gWodInfoArr[i]["pref-col"] = window.arguments[0].getPrefValue(preferred_pref);
   }

  document.getElementById("lw-wodresources-tree").view = new gRefTreeView(gWodInfoArr);


  // Options panel

  var pref_ignorequiz = window.arguments[0].getPrefValue("ignore_quiz_mode");
  document.getElementById("lw-ignorequiz-cb").checked = pref_ignorequiz;

}


function lwUpdateSettings()
{

  // drill panel

  var quiztype_rgroup = document.getElementById("lw-quiztype-rgroup");
  var quiztype = parseInt(quiztype_rgroup.selectedItem.value);
  window.arguments[0].setPrefValue("quiz_type", quiztype);

  var quizmode_rgroup = document.getElementById("lw-quizmode-rgroup");
  var quizmode = parseInt(quizmode_rgroup.selectedItem.value);
  window.arguments[0].setPrefValue("quiz_mode", quizmode);

  var autointerval_tbox = document.getElementById("lw-autointerval-tbox");
  window.arguments[0].setPrefValue("auto_interval", parseInt(autointerval_tbox.value));

  var autopause_tbox = document.getElementById("lw-autopause-tbox");
  window.arguments[0].setPrefValue("auto_answer_pause", parseInt(autopause_tbox.value));

  var autohint_cb = document.getElementById("lw-autohint-cb");
  window.arguments[0].setPrefValue("autohint", autohint_cb.checked);

  var hint_cpicker = document.getElementById("lw-hintcolor-cpick");
  window.arguments[0].setPrefValue("hintbox_color", hint_cpicker.color);

  var fontsize_mlist = document.getElementById("lw-fontsize-mlist");
  window.arguments[0].setPrefValue("drill_font_size", fontsize_mlist.value);


  // references panel

  var refopen_rgroup = document.getElementById("lw-refopen-rgroup");
  var ref_openmethod = parseInt(refopen_rgroup.selectedItem.value);
  window.arguments[0].setPrefValue("lookup_openmethod", ref_openmethod);

  for (var i=0; i < gRefInfoArr.length; i++)
   {
     name_pref = "lookup_name" + (i+1);
     url_pref = "lookup_URL" + (i+1);
     preferred_pref = "lookup_pref" + (i+1);
     window.arguments[0].setPrefValue(name_pref, gRefInfoArr[i]["name-col"]);
     window.arguments[0].setPrefValue(url_pref, gRefInfoArr[i]["url-col"]);
     window.arguments[0].setPrefValue(preferred_pref, gRefInfoArr[i]["pref-col"]);
   }


  // WOD panel

  var wodopen_rgroup = document.getElementById("lw-wodopen-rgroup");
  var wod_openmethod = parseInt(wodopen_rgroup.selectedItem.value);
  window.arguments[0].setPrefValue("wod_openmethod", wod_openmethod);

  for (var i=0; i < gWodInfoArr.length; i++)
   {
     name_pref = "wod_name" + (i+1);
     url_pref = "wod_URL" + (i+1);
     preferred_pref = "wod_pref" + (i+1);
     window.arguments[0].setPrefValue(name_pref, gWodInfoArr[i]["name-col"]);
     window.arguments[0].setPrefValue(url_pref, gWodInfoArr[i]["url-col"]);
     window.arguments[0].setPrefValue(preferred_pref, gWodInfoArr[i]["pref-col"]);
   }


  // Options panel

  var ignorequiz_cb = document.getElementById("lw-ignorequiz-cb");
  window.arguments[0].setPrefValue("ignore_quiz_mode", ignorequiz_cb.checked);

}


function lwEditResourceInfo(restree)
{
  var infoSrcArr; 

  if (restree.getAttribute("id") == "lw-searchresources-tree")
    infoSrcArr = gRefInfoArr;
  else
    infoSrcArr = gWodInfoArr;

  var ridx = restree.currentIndex;
  var resource_info = new Object();

  resource_info.cancel = false;
  resource_info.name = infoSrcArr[ridx]["name-col"];
  resource_info.url = infoSrcArr[ridx]["url-col"];
  resource_info.bPref = infoSrcArr[ridx]["pref-col"];

  window.openDialog('chrome://latchwordbb/content/dialogEditRef.xul',
                    'lwEditReference','chrome,modal,centerscreen', resource_info);

  if (!resource_info.cancel)
   {
     infoSrcArr[ridx]["name-col"] = resource_info.name;
     infoSrcArr[ridx]["url-col"] = resource_info.url;
     infoSrcArr[ridx]["pref-col"] = resource_info.bPref;
   }


}


function lwMakeDefaultResource()
{
  var infoSrcArr; 
  var restree = document.popupNode.parentNode;

  if (restree.getAttribute("id") == "lw-searchresources-tree")
    infoSrcArr = gRefInfoArr;
  else
    infoSrcArr = gWodInfoArr;

  var ridx = restree.currentIndex;

  if (ridx != 0)
   {
     var temp = infoSrcArr[0];
     infoSrcArr[0] = infoSrcArr[ridx];
     infoSrcArr[ridx] = temp;
   }

   restree.treeBoxObject.selection.select(0);  // changing selection also
                                               // forces tree to be redrawn
}


function lwRestoreDefaultSrchRefs()
{
  var name_pref, url_pref, preferred_pref;
  var searchtree = document.getElementById("lw-searchresources-tree");

  for (var i=0; i < gRefInfoArr.length; i++)
   {
     name_pref = "lookup_name" + (i+1);
     url_pref = "lookup_URL" + (i+1);
     preferred_pref = "lookup_pref" + (i+1);
     gRefInfoArr[i]["name-col"] = window.arguments[0].getPrefDefValue(name_pref);
     gRefInfoArr[i]["url-col"] = window.arguments[0].getPrefDefValue(url_pref);
     gRefInfoArr[i]["pref-col"] = window.arguments[0].getPrefDefValue(preferred_pref);
   }

  searchtree.treeBoxObject.invalidate();  // this forces the tree
                                          // to be redrawn

}


function lwRestoreDefaultWODRefs()
{
  var name_pref, url_pref, preferred_pref;
  var searchtree = document.getElementById("lw-wodresources-tree");

  for (var i=0; i < gWodInfoArr.length; i++)
   {
     name_pref = "wod_name" + (i+1);
     url_pref = "wod_URL" + (i+1);
     preferred_pref = "wod_pref" + (i+1);
     gWodInfoArr[i]["name-col"] = window.arguments[0].getPrefDefValue(name_pref);
     gWodInfoArr[i]["url-col"] = window.arguments[0].getPrefDefValue(url_pref);
     gWodInfoArr[i]["pref-col"] = window.arguments[0].getPrefDefValue(preferred_pref);
   }

  searchtree.treeBoxObject.invalidate();  // this forces the tree
                                          // to be redrawn

}
