/****************************************************************************
**  LatchWordBB - Vocabulary retention and reinforcement toolbar for Mozilla
**  Copyright (c) 2003  Charles Melhorn
**
**  This file is part of LatchWordBB.
**
**  LatchWordBB is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  LatchWordBB is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**
**  Or see the GNU web site at: http://www.gnu.org
**
****************************************************************************/ 


var RDFC = '@mozilla.org/rdf/container;1';
RDFC = Components.classes[RDFC].createInstance();
RDFC = RDFC.QueryInterface(Components.interfaces.nsIRDFContainer);

var RDFCUtils = '@mozilla.org/rdf/container-utils;1';
RDFCUtils = Components.classes[RDFCUtils].getService();
RDFCUtils = RDFCUtils.QueryInterface(Components.interfaces.nsIRDFContainerUtils);

var RDF = '@mozilla.org/rdf/rdf-service;1'
RDF = Components.classes[RDF].getService();
RDF = RDF.QueryInterface(Components.interfaces.nsIRDFService);

var gVocabSrc = 
{
  ds    : null,
  spec  : ""
}


function lwInitWordList()
{
  // code derived from JSLib RDF classes and XUL Planet tutorial

  var dsURI_str = window.arguments[0].getPrefValue("default_wordlist");

  if (dsURI_str == "")  // if no wordlist specified, use default which
                        // should reside in "UserProfileDir/Latchwordbb"
   {
     var dirServCID = '@mozilla.org/file/directory_service;1';
     var propIF = Components.interfaces.nsIProperties;
     var dirServ = Components.classes[dirServCID].getService(propIF);

     var userProfileDir = dirServ.get("ProfD", Components.interfaces.nsIFile);
     userProfileDir.append("Latchwordbb");
     userProfileDir.append("defVocab.rdf");

     // Get IOService to convert file path to URI
     var serv = Components.classes["@mozilla.org/network/io-service;1"].
                getService(Components.interfaces.nsIIOService);
     if (!serv) {
       throw Components.results.ERR_FAILURE;
     }
     var uri = serv.newFileURI(userProfileDir);
     dsURI_str = uri.spec;
   }

 
  var wordtree  = document.getElementById("lw-wordlist-tree");
  var vcabres;


  // Create an RDF/XML datasource using the XPCOM Component Manager
  var new_dsource = Components.classes['@mozilla.org/rdf/datasource;1?name=xml-datasource']
    .createInstance(Components.interfaces.nsIRDFDataSource);

  // The nsIRDFRemoteDataSource interface has the interfaces
  // that we need to setup the datasource.
  gVocabSrc.ds = new_dsource.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource);

  try {
    gVocabSrc.ds.Init(dsURI_str); // throws an exception if URL already in use
  }
  catch(err) {
    gVocabSrc.ds = RDF.GetDataSource(dsURI_str);
  }
     
  gVocabSrc.spec = dsURI_str;

    
  gVocabSrc.ds = gVocabSrc.ds.QueryInterface(Components.interfaces.nsIRDFDataSource);
  wordtree.database.AddDataSource(gVocabSrc.ds);
  
  var remote = gVocabSrc.ds.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource);
  remote.Refresh(true);
  wordtree.builder.rebuild(true); 

  var fileURI_str = dsURI_str;
  if (fileURI_str.length > 50)
    fileURI_str = fileURI_str.substring(0,25) + "..." +
                  fileURI_str.substring(fileURI_str.length - 20);

  document.getElementById("lw-filename-desc").value = fileURI_str;
  document.getElementById("lw-filename-desc").setAttribute("tooltiptext", dsURI_str);


  var rootnode = RDF.GetResource("urn:words:data");
  try {    
    RDFC.Init(gVocabSrc.ds,rootnode);
  }
  catch (e) {
    RDFCUtils.MakeSeq(gVocabSrc.ds,rootnode);
    RDFC.Init(gVocabSrc.ds,rootnode);
  }

  document.getElementById("lw-numentries-desc").value = RDFC.GetCount();

  doLWSort(document.getElementById("word-col"));  

  if (window.arguments.length > 1)
    document.getElementById("lw-addword-tbox").value = window.arguments[1];

}


function doLWSort(node)
{ 
  // used downloadmanager.js::doLWSort() as reference

  if (node.localName != "treecol")
    return;

  var sortResource = node.getAttribute("resource");

  var sortDirection = node.getAttribute("sortDirection");
  sortDirection = sortDirection == "ascending" ? "descending" : "ascending";

  try {
    var sortService = Components.classes["@mozilla.org/xul/xul-sort-service;1"]
                      .getService(Components.interfaces.nsIXULSortService);
    sortService.sort(node, sortResource, sortDirection);
  }
  catch(ex) {
  }

  document.getElementById("lw-wordlist-tree").view.selection.clearSelection();
  document.getElementById("lw-addword-tbox").value = "";
  document.getElementById("lw-adddefinition-tbox").value = "";
  document.getElementById("lw-dateadded-desc").value = "";

  document.getElementById("lw-addword-tbox").focus();

}


function onLwWordSelect(wordtree)
{ 
  var ridx = wordtree.currentIndex;

  if (ridx != -1)
   {
     var sel_word = wordtree.view.getCellText(ridx, "word-col");
     var sel_definition = wordtree.view.getCellText(ridx, "definition-col");
     var sel_date = wordtree.view.getCellText(ridx, "date-col");

     document.getElementById("lw-addword-tbox").value = sel_word;
     document.getElementById("lw-adddefinition-tbox").value = sel_definition;

     var dateModified = new Date();
     dateModified.setTime(parseInt(sel_date));

     var custom_date_str = (dateModified.getMonth() + 1) + "/" + dateModified.getDate() + "/" +
                           dateModified.getFullYear() + " " + dateModified.getHours() + ":" +
                           dateModified.getMinutes() + ":" + dateModified.getSeconds();

     document.getElementById("lw-dateadded-desc").value = custom_date_str;
   }

} 


function lwClearSelection()
{ 
  var wordtree = document.getElementById("lw-wordlist-tree");

  // need to clear tree selection before blanking textboxes
  // since selection.clearSelection() triggers the onselect event

  wordtree.view.selection.clearSelection();  // this doesn't reset currentIndex - bug??
  wordtree.currentIndex = -1;

  document.getElementById("lw-addword-tbox").value = "";
  document.getElementById("lw-adddefinition-tbox").value = "";
  document.getElementById("lw-dateadded-desc").value = "";

}


function lwDeleteWordListEntry()
{
  var wordtree = document.getElementById("lw-wordlist-tree");
  var ridx = wordtree.currentIndex;

  if (ridx != -1)
   {
     var sel_word = wordtree.view.getCellText(ridx, "word-col");
     var selnode = RDF.GetResource("urn:words:" + sel_word);

     RDFC.RemoveElement(selnode, true);

     var props = gVocabSrc.ds.ArcLabelsOut(selnode);
     while(props.hasMoreElements())
      { 
        var prop = props.getNext();
        var target = gVocabSrc.ds.GetTarget(selnode,prop,true);
        gVocabSrc.ds.Unassert(selnode,prop,target);
      }

     gVocabSrc.ds.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource).Flush();

     document.getElementById("lw-addword-tbox").value = "";
     document.getElementById("lw-adddefinition-tbox").value = "";
     document.getElementById("lw-dateadded-desc").value = "";
     document.getElementById("lw-numentries-desc").value = RDFC.GetCount();  
   }

}


function lwUpdateWordList()
{
  var newnode, labelprop, newvalue;
  var new_word = document.getElementById("lw-addword-tbox").value;
  var new_defin = document.getElementById("lw-adddefinition-tbox").value;
  var new_date = new Date().getTime();

  if (new_word != "")
   {
     newnode = RDF.GetResource("urn:words:" + new_word);

     labelprop = RDF.GetResource("http://latchwordbb.mozdev.org/rdf#word");
     newvalue = RDF.GetLiteral(new_word);
     gVocabSrc.ds.Assert(newnode,labelprop,newvalue,true);

     labelprop = RDF.GetResource("http://latchwordbb.mozdev.org/rdf#definition");
     newvalue = RDF.GetLiteral(new_defin);
     gVocabSrc.ds.Assert(newnode,labelprop,newvalue,true);

     labelprop = RDF.GetResource("http://latchwordbb.mozdev.org/rdf#date");
     newvalue = RDF.GetLiteral(new_date);
     gVocabSrc.ds.Assert(newnode,labelprop,newvalue,true);

     RDFC.AppendElement(newnode);
     gVocabSrc.ds.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource).Flush();

     document.getElementById("lw-addword-tbox").value = "";
     document.getElementById("lw-adddefinition-tbox").value = "";
     document.getElementById("lw-dateadded-desc").value = "";
     document.getElementById("lw-numentries-desc").value = RDFC.GetCount();  
   }

}


function lwBrowseVocabFiles()
{
  var nsIFilePicker = Components.interfaces.nsIFilePicker;
  var fp = Components.classes["@mozilla.org/filepicker;1"]
           .createInstance(nsIFilePicker);

  fp.init(window, "Select a File", nsIFilePicker.modeOpen);
  fp.appendFilter("RDF Files","*.rdf");
  fp.appendFilters(nsIFilePicker.filterAll);

  var res = fp.show();

  if (res == nsIFilePicker.returnOK)
    lwChangeWordListDataSource(fp.fileURL.spec);

}


function lwChangeWordListDataSource(dsURI_str)
{
  var wordtree = document.getElementById("lw-wordlist-tree");

  if (dsURI_str != gVocabSrc.spec)
   {
     if ( (wordtree.treeBoxObject.selection) &&   // treeBoxObject.selection will be null if
          (wordtree.currentIndex != -1) )         // there are no nodes in wordlist tree. 
      {                                           // Check before trying to use currentIndex
        wordtree.view.selection.clearSelection();
        wordtree.currentIndex = -1;
      }
     
     wordtree.database.RemoveDataSource(gVocabSrc.ds);     

     var new_dsource = Components.classes['@mozilla.org/rdf/datasource;1?name=xml-datasource']
         .createInstance(Components.interfaces.nsIRDFDataSource);

     new_dsource = new_dsource.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource);

     try {
       new_dsource.Init(dsURI_str); // throws an exception if URL already in use
     }
     catch(err) {
       new_dsource = RDF.GetDataSource(dsURI_str);
     }
     
     var new_dsource_spec = dsURI_str;

     new_dsource = new_dsource.QueryInterface(Components.interfaces.nsIRDFDataSource);
     wordtree.database.AddDataSource(new_dsource);
  
     var remote = new_dsource.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource);
     remote.Refresh(true);
     wordtree.builder.rebuild(true); 

     var fileURI_str = dsURI_str;
     if (fileURI_str.length > 50)
       fileURI_str = fileURI_str.substring(0,25) + "..." +
                     fileURI_str.substring(fileURI_str.length - 20);

     document.getElementById("lw-filename-desc").value = fileURI_str;
     document.getElementById("lw-filename-desc").setAttribute("tooltiptext", dsURI_str);

     gVocabSrc.ds = new_dsource;
     gVocabSrc.spec = dsURI_str;

     var rootnode = RDF.GetResource("urn:words:data");
     try {    
       RDFC.Init(gVocabSrc.ds,rootnode);
     }
     catch (e) {
       RDFCUtils.MakeSeq(gVocabSrc.ds,rootnode);
       RDFC.Init(gVocabSrc.ds,rootnode);
     }
     document.getElementById("lw-numentries-desc").value = RDFC.GetCount();

     window.arguments[0].setPrefValue("default_wordlist", dsURI_str);
  
   }

}


function lwCreateNewVocabFile()
{
  var PR_WRONLY = 0x02;     // File io flags - see prio.h
  var PR_TRUNCATE = 0x20;

  var dirServCID = '@mozilla.org/file/directory_service;1';
  var propIF = Components.interfaces.nsIProperties;
  var dirServ = Components.classes[dirServCID].getService(propIF);

  var userProfileDir = dirServ.get("ProfD", Components.interfaces.nsIFile);
  userProfileDir.append("Latchwordbb");

  var new_file_info = new Object();

  new_file_info.cancel = false;
  new_file_info.filename = "";
  new_file_info.directory = userProfileDir;  // pass directory object (nsIFile) to dialog
                                             // rather than directory name to avoid
                                             // having to use initWithPath to create File

  window.openDialog('chrome://latchwordbb/content/dialogNewList.xul',
                    'lwNewList','chrome,modal,centerscreen', new_file_info);

  if (!new_file_info.cancel)
   {
     new_file_info.directory.append(new_file_info.filename);

     if (new_file_info.directory.exists())
        alert("Error 01: File already exists.");
     else
      {
        var file_type = 0;  // file = 0, directory = 1
        var fperms = 0644;  // unix style file permissions - octal

        new_file_info.directory.create(file_type, fperms);

        var outstreamCID = '@mozilla.org/network/file-output-stream;1';
        var fout = Components.classes[outstreamCID].createInstance();
        fout = fout.QueryInterface(Components.interfaces.nsIFileOutputStream);

        fout.init(new_file_info.directory, PR_WRONLY | PR_TRUNCATE, 00004, null);

        var file_hdr_str =
           '<?xml version="1.0"?>\n' +
           '<RDF:RDF xmlns:RDF="http://www.w3.org/1999/02/22-rdf-syntax-ns#"\n' +
           '         xmlns:VOCAB="http://latchwordbb.mozdev.org/rdf#">\n' +
           '</RDF:RDF>\n';

        try {
          fout.write(file_hdr_str, file_hdr_str.length);
          fout.close();
        }
        catch (e) {
          alert("Error 02: Unable to write header to new vocab file.");
          return;
        }

        // Get IOService to convert file path to URI
        var serv = Components.classes["@mozilla.org/network/io-service;1"].
                   getService(Components.interfaces.nsIIOService);
        if (!serv) {
          throw Components.results.ERR_FAILURE;
        }
        var uri = serv.newFileURI(new_file_info.directory);
        lwChangeWordListDataSource(uri.spec);
      }

   } // end if !cancel

}

