/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is MacroTracker Bug Tracking System Source Code
 *
 * The Initial Developer of the Original Code is
 * R.J. Keller.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
package org.mozdev.MacroTracker.toolkit.guiPanels;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import org.mozdev.MacroTracker.toolkit.*;

/**
 *addRemovePanel generates a JPanel with GUI where the user can add and remove
 *data from a MComboBox that cannot hold duplicate items.
 *
 *<p>Items the user added can be received through the getData() method.</p>
 *
 *@author R.J. Keller <rlk@trfenv.com>
 */
public class addRemovePanel extends JPanel implements ActionListener
{
	protected MComboBox guiData;
	protected MTextField mAddBox;
	protected JButton btnAdd;
	protected JButton btnRemove;
	
	/**
	 *Creates a addRemovePanel with a JLabel containing the name of what the
	 *user is adding at the top of the panel and initial string values added to
	 *the MComboBox.
	 *
	 *@param guiName The name of the information the user is adding.
	 *@param initalValues Some default values for the MComboBox.
	 */
	public addRemovePanel(String guiName, String[] initalValues)
	{
		this(guiName);
		
		for (int i = 0; i < initalValues.length; i++)
			guiData.addItem(initalValues[i]);
	}
	
	/**
	 *Creates a addRemovePanel with a JLabel containing the name of what the
	 *user is adding at the top of the panel.
	 */
	public addRemovePanel(String guiName)
	{
		setLayout(new GridLayout(1,3));
		
		//adding GUI label
		JPanel pnlLeft = new JPanel(new GridLayout(3, 1));
		pnlLeft.add(new JLabel(guiName));

		// adding mAddBox
		mAddBox = new MTextField();
		pnlLeft.add(mAddBox);
		
		// adding btnAdd
		btnAdd = new JButton("Add");
		pnlLeft.add(btnAdd);
		
		// adding guiData and btnRemove
		guiData = new MComboBox();
		JPanel pnlButtons = new JPanel(new FlowLayout());
		btnRemove = new JButton("Remove");
		pnlButtons.add(btnRemove);
		
		//add action listeners
		btnAdd.addActionListener(this);
		btnRemove.addActionListener(this);
		mAddBox.addActionListener(this);
		
		add(pnlLeft);
		add(guiData);
		add(pnlButtons);
	}
	
	class GUIIterator implements Iterator
	{
		int curIndex = 0;
		
		public boolean hasNext()
		{
			return curIndex != guiData.getItemCount();
		}
		
		public Object next() throws NoSuchElementException
		{
			if (!hasNext())
				throw new NoSuchElementException();

			return guiData.getItemAt(curIndex++);
		}
		
		public void remove() throws UnsupportedOperationException
		{
			throw new UnsupportedOperationException();
		}
	}
	
	/**
	 *Returns an iterator with the data contained in the list.
	 */
	public Iterator getData()
	{
		return new GUIIterator();
	}
	
	/**
	 *Clears all of the data contained in the panel.
	 */
	public void clear()
	{
		mAddBox.setText("");
		guiData.clear();
	}
	
	/**
	 *Adds the String taken in to the JList contained in this panel.
	 */
	public void addItem(String items)
	{
		guiData.addItem(items);
	}
	
	public void actionPerformed(ActionEvent e)
	{
		if (e.getSource() == btnAdd || e.getSource() == mAddBox)
		{
			guiData.addItem(mAddBox.getText());
		}
		else if (e.getSource() == btnRemove)
		{
			guiData.removeSelectedItem();
		}
	}
}