/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is MacroTracker Bug Tracking System Source Code
 *
 * The Initial Developer of the Original Code is
 * R.J. Keller.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
package org.mozdev.MacroTracker.ui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import org.mozdev.MacroTracker.main.MacroTracker;
import org.mozdev.MacroTracker.ui.frmBug;
import org.mozdev.MacroTracker.classes.Bug;

import com.trfenv.rlk.Debug;

public class frmOpenBug extends JDialog implements ActionListener
{
	private JComboBox cboSelectBug;
	private JButton   btnOpen;
	private JButton   btnCancel;

	public frmOpenBug(Frame owner)
	{
		super(owner, "Open Bug");

		setSize(287, 102);

		Container contentPane = getContentPane();
		contentPane.setLayout( new BorderLayout() );

		cboSelectBug = new JComboBox();
		JPanel pnlMain = new JPanel();
		pnlMain.setLayout( new BorderLayout() );
		pnlMain.add( new JLabel(" Select Bug: "), BorderLayout.WEST );
		pnlMain.add( cboSelectBug, BorderLayout.CENTER );

		contentPane.add( pnlMain, BorderLayout.NORTH );

		btnOpen = new JButton("Open");
		btnOpen.addActionListener( this );
		btnCancel = new JButton("Cancel");
		btnCancel.addActionListener( this );

		JPanel pnlBottom = new JPanel();
		pnlBottom.setLayout( new FlowLayout(FlowLayout.LEFT) );
		pnlBottom.add(btnOpen);
		pnlBottom.add(btnCancel);

		contentPane.add( pnlBottom, BorderLayout.SOUTH );

		//Load bugs into the combo box.
		for (int i = 0; i < MacroTracker.gMasterBugDatabase.bugCount(); i++)
			cboSelectBug.addItem("Bug " + i);

		Debug.createObject(this);
	}

	public void actionPerformed(ActionEvent event)
	{
		if (event.getSource() == btnOpen)
		{
			MacroTracker.gMasterBugDesktop.addDesktopItem(new frmBug(
				MacroTracker.gMasterBugDatabase.getBug(cboSelectBug.getSelectedIndex())), "Bug " + cboSelectBug.getSelectedIndex() );
			setVisible( false );
		}
		else if (event.getSource() == btnCancel)
		{
			setVisible( false );
		}
	}
}