// Zend Studio Toolbar for Mozilla
// (c) 2004 Zend Technologies, All Rights Reserved
//
// This file is subject to
// the Zend Studio End User License Agreement

include (jslib_remotefile);

// User defined constants
const myToolbarId = "zendstudiotoolbar"; // <toolbar>'s id

// ZDE settings:
var ZDE_IP;
var ZDE_Port;
var ZDE_UseSSL;


var observer = {
	observe: function(subject,topic,data){
		try {
			var observerService = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);
			observerService.removeObserver(observer,"http-on-examine-response");

			var http = subject.QueryInterface(Components.interfaces.nsIHttpChannel);
			var header = http.getResponseHeader("X-Zend-Debug-Server");
			if( header ){
				if( header != "OK" ) alert("Zend Studio server error:\n"+header); 
				return;
			}
		}catch(e) { }
		// this is the default msg - since we can't find anything...
		// This is not 100% safe - so for now do nothing...
		//alert("Could not find a Zend Debugger on the server you try to debug.");

		
		// this is needed for windows...
		zendstudiotoolbarWindowOnLoad()
	}
};


function checkCookieEnabling() {
	document.cookie = '__test__cookie__=1'
	if ( document.cookie.indexOf('__test__cookie__') != -1) {
	document.cookie = "__test__cookie__=; expires=Thu, 01 Jan 1970 00:00:01 GMT;";
		return true;
	} else {
		return false;
	}
} 

function zendstudiotoolbarEnableSearch(enable){
	var display;
	if( enable ) display = "";
	else display = "none";

	try {
		document.getElementById("zendSearchTerms").style.display = display;
	} catch(e){}
	try {
		document.getElementById("zendSearchSites").style.display = display;
	} catch(e){}
	try {
		document.getElementById("zendstudiotoolbarSearchLbl").style.display = display;
	} catch(e){}
	try {
		document.getElementById("zendstudiotoolbarSearchLbl2").style.display = display;
	} catch(e){}
	try {	
		document.getElementById("zendsearch").style.display = display;
	} catch(e){}
}


function zendstudiotoolbarWindowOnLoad(){
	zendstudiotoolbarEnableSearch(zendstudiotoolbarGetZDESearch());

	try{
		var DebugNextPageMI = document.getElementById("zendstudiotoolbarDebugNextPage");
		var DebugNextPageContextMI = document.getElementById("zendstudiotoolbarDebugNextPage-context");
		var DebugPOSTMI = document.getElementById("zendstudiotoolbarDebugPOST");
		var DebugAllMI = document.getElementById("zendstudiotoolbarDebugAll");
	
		DebugNextPageMI.setAttribute("checked","false");
		DebugNextPageContextMI.setAttribute("checked","false");
		document.getElementById("zendstudiotoolbarDebug").disabled = false;
		document.getElementById("zendstudiotoolbarProfile").disabled = false;
	
		if ( DebugPOSTMI.getAttribute("checked")!="true" && DebugAllMI.getAttribute("checked")!="true" ) {
			zendstudiotoolbarClearDebugCookies();
		}
	} catch(e) { alert(e); }
	zendstudiotoolbarEnableRunZDE(true);
}


function zendstudiotoolbarDisplayCheck(){
	zendstudiotoolbarWindowOnLoad();
}

function zendstudiotoolbarLoadPage(url){
	window.content.document.location.href=url;
}



function zendstudiotoolbarSetDebugCookies(activeDocument){
	if( !checkCookieEnabling() ){
		alert("To use the Zend Studio toolbar, enable cookie support in your browser.");
		return;
	}

	// try and get the studio settings
	if( getZdeSettings() ){
		// connect the observer 
		var observerService = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);
		observerService.addObserver(observer,"http-on-examine-response",false);
	} else {
		return;
	}

	if (ZDE_IP != null && ZDE_IP != "") {
		activeDocument.cookie = "debug_host="+ZDE_IP+"; expires=Mon, 12 Feb 2035 01:00:00 UTC; path=/";
	}
	
	if( !zendstudiotoolbarGetZDELocal() ){
		activeDocument.cookie = "no_remote=1 ; expires=Mon, 12 Feb 2035 01:00:00 UTC; path=/";
	}
	
	if( ZDE_UseSSL ){
		activeDocument.cookie = "use_ssl=1 ; expires=Mon, 12 Feb 2035 01:00:00 UTC; path=/";
	}
	
	activeDocument.cookie = "debug_port="+ZDE_Port+"; expires=Mon, 12 Feb 2035 01:00:00 UTC; path=/";
	activeDocument.cookie = "send_debug_header=1; expires=Mon, 12 Feb 2035 01:00:00 UTC; path=/";
	activeDocument.cookie = "start_debug=1; expires=Mon, 12 Feb 2035 01:00:00 UTC; path=/";
	activeDocument.cookie = "debug_stop=1; expires=Mon, 12 Feb 2035 01:00:00 UTC; path=/";
	activeDocument.cookie = "send_sess_end=1; expires=Mon, 12 Feb 2035 01:00:00 UTC; path=/";
	activeDocument.cookie = "debug_jit=1; expires=Mon, 12 Feb 2035 01:00:00 UTC; path=/";
	activeDocument.cookie = "original_url="+activeDocument.location+"; expires=Mon, 12 Feb 2035 01:00:00 UTC; path=/";
}

function zendstudiotoolbarGetActiveDocument(clickedInFrame){
	try{
		var frame = document.popupNode.ownerDocument
		if( clickedInFrame && (frame != window._content.document) ) 
			/* return current frame */
			return frame;
	} catch(e) { /* let the user select frames - we failed...*/ }
		
	if (window._content.frames != null) {
		var tmp = new Array;
		var currentFrames = window._content.frames;

		if (currentFrames.length > 0) {
	        window.openDialog("chrome://"+myToolbarId+"/content/"+myToolbarId+"Frames.xul", 'Frame Selection', 'chrome,dialog,modal', tmp);
			return tmp[0];
        } 
	} 
	return window._content.document;
}

function getZdeSettingString(ZDE_DetectPort){
	try {
		var url = "http://127.0.0.1:"+ZDE_DetectPort;
		var rf = new RemoteFile (url);

		if( rf.open() ){
			return rf.read();
		} else {
			return false;
		}
	} catch(e) { return false; }
}

function getZdeSettings(){
try{
	// If auto detect is disabled - Use the user supplied arguments - and hope he knows what he is doing
	if( !zendstudiotoolbarGetAutodetect() ){
		ZDE_IP = zendstudiotoolbarGetZDEIP(true);
		ZDE_Port = zendstudiotoolbarGetZDEPort();
		ZDE_UseSSL = zendstudiotoolbarGetUseSSL();
		return true;
	} else {
		var ZDE_DetectPort = zendstudiotoolbarGetZDEAutodetectPort(); 
		var settingsString = getZdeSettingString(ZDE_DetectPort);
		if( !settingsString ){
			alert("Cannot auto detect ZDE settings at port: "+ZDE_DetectPort+".\nMake Sure that ZDE v4.0 or newer is running on this computer and is configured to work on this port.\nIf you have an older version, use the settings dialog to disable auto detection and manually configure the ZDE settings.");
			return false;
		}
		else{
			ZDE_IP = null;
			ZDE_Port = "10000";
			ZDE_UseSSL = false;
			settingsArray = settingsString.split("&");
			var i;
			for (i=0; i<settingsArray.length; i++) {
				// ignore setting that are not in the format of xxx=yyy
				if( settingsArray[i].indexOf("=") == -1 ) continue;
				// currently we only detect debug_port, debug_host and use_ssl
				var setting = settingsArray[i].split("=");
				if( setting[0] == "debug_port" ) ZDE_Port=setting[1];
				else if( setting[0] == "debug_host" ) ZDE_IP=setting[1];
				else if( setting[0] == "use_ssl" ) ZDE_UseSSL=setting[1];
			}
			if( ZDE_IP == null ) return false;
			return true;
		}
	}
} catch(e) { alert(e); }
}

function zendstudiotoolbarDebug(contextMenu){
	if (document.getElementById("zendstudiotoolbarDebug").getAttribute("disabled")=="true") {
		return;
	}

	zendstudiotoolbarClearDebugCookies();
	var targetDocument = zendstudiotoolbarGetActiveDocument(contextMenu);

	if (targetDocument == null) {
		return;
	}

	// Set the cookies, connect the observer and reload the page...
	zendstudiotoolbarSetDebugCookies(targetDocument);
	document.getElementById("zendstudiotoolbarDebug").disabled = true;
	document.getElementById("zendstudiotoolbarProfile").disabled = true;
	targetDocument.location.reload();
}

function zendstudiotoolbarClearDebugCookies(){
	if( !checkCookieEnabling() ){
		return;
	}

	window._content.document.cookie = "_bm=; expires=Sat, 12 Feb 2000 01:00:00 UTC; path=/";
	window._content.document.cookie = "debug_line_bp=; expires=Sat, 12 Feb 2000 01:00:00 UTC; path=/";
	window._content.document.cookie = "debug_file_bp=; expires=Sat, 12 Feb 2000 01:00:00 UTC; path=/";
	window._content.document.cookie = "debug_port=; expires=Sat, 12 Feb 2000 01:00:00 UTC; path=/";
	window._content.document.cookie = "send_debug_header=; expires=Sat, 12 Feb 2000 01:00:00 UTC; path=/";
	window._content.document.cookie = "debug_host=; expires=Sat, 12 Feb 2000 01:00:00 UTC; path=/";
	window._content.document.cookie = "start_debug=; expires=Sat, 12 Feb 2000 01:00:00 UTC; path=/";
	window._content.document.cookie = "debug_stop=; expires=Sat, 12 Feb 2000 01:00:00 UTC; path=/";
	window._content.document.cookie = "start_profile=; expires=Sat, 12 Feb 2000 01:00:00 UTC; path=/";
	window._content.document.cookie = "send_sess_end=; expires=Sat, 12 Feb 2000 01:00:00 UTC; path=/";
	window._content.document.cookie = "debug_jit=; expires=Sat, 12 Feb 2000 01:00:00 UTC; path=/";
	window._content.document.cookie = "debug_start_session=; expires=Sat, 12 Feb 2000 01:00:00 UTC; path=/";
	window._content.document.cookie = "original_url=; expires=Sat, 12 Feb 2000 01:00:00 UTC; path=/";
	window._content.document.cookie = "ZendDebuggerCookie=; expires=Sat, 12 Feb 2000 01:00:00 UTC; path=/";
	window._content.document.cookie = "start_profile=; expires=Sat, 12 Feb 2000 01:00:00 UTC; path=/";
	window._content.document.cookie = "use_ssl=; expires=Sat, 12 Feb 2000 01:00:00 UTC; path=/";
	
}


function zendstudiotoolbarDebugChangeStatus(ActiveMI){
	var DebugNextPageMI = document.getElementById("zendstudiotoolbarDebugNextPage");
	var DebugNextPageContextMI = document.getElementById("zendstudiotoolbarDebugNextPage-context");
	var DebugPOSTMI = document.getElementById("zendstudiotoolbarDebugPOST");
	var DebugAllMI = document.getElementById("zendstudiotoolbarDebugAll");
		
	if (DebugNextPageMI.getAttribute("checked")=="true"
		|| DebugPOSTMI.getAttribute("checked")=="true"
		|| DebugAllMI.getAttribute("checked")=="true") {
		zendstudiotoolbarClearDebugCookies();
	}

	// sync context menu and toolbar checkbox
	DebugNextPageContextMI.setAttribute("checked", ActiveMI.getAttribute("checked"));
	DebugNextPageMI.setAttribute("checked", ActiveMI.getAttribute("checked"));
			
	if (ActiveMI != DebugNextPageMI && ActiveMI != DebugNextPageContextMI) {
		DebugNextPageMI.setAttribute("checked", "false");
		DebugNextPageContextMI.setAttribute("checked", "false");
	}
	if (ActiveMI != DebugPOSTMI) {
		DebugPOSTMI.setAttribute("checked", "false");
	}
	if (ActiveMI != DebugAllMI) {
		DebugAllMI.setAttribute("checked", "false");
	}

	if (ActiveMI.getAttribute("checked")=="true") {
		zendstudiotoolbarSetDebugCookies(window._content.document);
		if( ActiveMI.getAttribute("id") == "zendstudiotoolbarDebugNextPage" ||
		    ActiveMI.getAttribute("id") == "zendstudiotoolbarDebugNextPage-context" ){
		} else if (ActiveMI.getAttribute("id") == "zendstudiotoolbarDebugPOST") {
			window._content.document.cookie = "debug_start_session=POST; expires=Mon, 12 Feb 2035 01:00:00 UTC; path=/";
		} else if (ActiveMI.getAttribute("id") == "zendstudiotoolbarDebugAll") {
			window._content.document.cookie = "debug_start_session=1; expires=Mon, 12 Feb 2035 01:00:00 UTC; path=/";
		}
	} else {
		zendstudiotoolbarClearDebugCookies();
	}
}


function zendstudiotoolbarProfile(){
	if( !checkCookieEnabling() ){
		alert("To use the Zend Studio toolbar, enable cookie support in your browser.");
		return;
	}


	if (document.getElementById("zendstudiotoolbarProfile").getAttribute("disabled")=="true") {
		return;
	}

	zendstudiotoolbarClearDebugCookies();

	var targetDocument = zendstudiotoolbarGetActiveDocument(false);

	if (targetDocument == null) {
		return;
	}

	if( !getZdeSettings() ) return;
		
	// Set the cookies, connect the observer and reload the page...	
	if (ZDE_IP != null && ZDE_IP !="") {
		window._content.document.cookie = "debug_host="+ZDE_IP+"; expires=Mon, 12 Feb 2035 01:00:00 UTC; path=/";
	}
	
	if( ZDE_UseSSL ){
		activeDocument.cookie = "use_ssl=1 ; expires=Mon, 12 Feb 2035 01:00:00 UTC; path=/";
	}

	window._content.document.cookie = "debug_port="+ZDE_Port+"; expires=Mon, 12 Feb 2035 01:00:00 UTC; path=/";
	window._content.document.cookie = "send_debug_header=1; expires=Mon, 12 Feb 2035 01:00:00 UTC; path=/";
	window._content.document.cookie = "start_debug=1; expires=Mon, 12 Feb 2035 01:00:00 UTC; path=/";
	window._content.document.cookie = "start_profile=1; expires=Mon, 12 Feb 2035 01:00:00 UTC; path=/";
	window._content.document.cookie = "send_sess_end=1; expires=Mon, 12 Feb 2035 01:00:00 UTC; path=/";
	window._content.document.cookie = "debug_jit=1; expires=Mon, 12 Feb 2035 01:00:00 UTC; path=/";
	window._content.document.cookie = "original_url="+targetDocument.location+"; expires=Mon, 12 Feb 2035 01:00:00 UTC; path=/";
		
	var observerService = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);
	observerService.addObserver(observer,"http-on-examine-response",false);

	document.getElementById("zendstudiotoolbarDebug").disabled = true;
	document.getElementById("zendstudiotoolbarProfile").disabled = true;
	
	targetDocument.location.reload();
}

//add a search term to the drop down.
function zendstudiotoolbarAddSearchTerms(searchTerms){
	var zendSearchTerms = document.getElementById("zendSearchTerms");
	var i;

	var childNodes = zendSearchTerms.firstChild.childNodes;
	for (i=0; i < childNodes.length; i++) {
		if (childNodes[i].getAttribute("label") == searchTerms) {
			zendSearchTerms.removeItemAt(i);
		}
	}

	zendSearchTerms.insertItemAt(0, searchTerms);
}

function zendstudiotoolbarSearch(){
	var searchTerms = document.getElementById("zendSearchTerms").value;

	zendstudiotoolbarAddSearchTerms(searchTerms);
	var terms = searchTerms.split(" ");
	
	var i;
	var URL = document.getElementById("zendSearchSites").selectedItem.getAttribute("data");;

	for (i=0; i<terms.length; i++) {
		URL += encodeURIComponent(terms[i]);
		if (i != terms.length-1) {
			URL += "+";
		}
	}
	zendstudiotoolbarLoadPage(URL);
}


function zendstudiotoolbarAbout(){
	window.openDialog("chrome://zendstudiotoolbar/content/about.xul", "zendstudiotoolbar-about-dialog", "centerscreen,chrome,modal");
}


function zendstudiotoolbarOpenSettings(){
	window.openDialog("chrome://"+myToolbarId+"/content/"+myToolbarId+"Settings.xul", "Settings", 'chrome,dialog,modal,titlebar');
	
	zendstudiotoolbarWindowOnLoad();
}

// Uninstall *******
function zendstudiotoolbarUninstall(url){
//	if(! confirm("Uninstall this extension?")) return;
//	var unreg = new exUnregisterer(	'chrome://'+myToolbarId+'/content/contents.rdf');
//	unreg.unregister();
//	unreg.removePrefs(myToolbarId);

	jslibUninstall(myToolbarId); 

//	alert("Extension uninstall is complete. Restart your browser for changes to take effect.");
}

function setRightClickMenu(){
	// if the page contains frames -> show "debug this frame"
	if ( document.popupNode.ownerDocument != window._content.document )
		document.getElementById("zendstudiotoolbarDebugFrame-context").hidden = false;
	else
		document.getElementById("zendstudiotoolbarDebugFrame-context").hidden = true;
}

function zendstudiotoolbarToggleShow(){
	var hide = !document.getElementById("zendstudiotoolbarShow-context").getAttribute("checked");
	document.getElementById("zendstudiotoolbar").setAttribute("hidden",hide);
}

function zendstudiotoolbarEnableRunZDE(enable){
	document.getElementById("zendstudiotoolbarRunZDE").disabled = !enable;
}

function zendstudiotoolbarRunZDE(){
	var cmd = zendstudiotoolbarGetZDEPath();
	try{
		var targetFile = Components.classes['@mozilla.org/file/local;1'].createInstance(Components.interfaces.nsILocalFile);
		targetFile.initWithPath(cmd);
		var process = Components.classes['@mozilla.org/process/util;1'].getService(Components.interfaces.nsIProcess);
		process.init(targetFile);
		var arg = [];
		process.run(false, arg, arg.length, {});
		// disable the button for 3 seconds
		zendstudiotoolbarEnableRunZDE(false);
		setTimeout("zendstudiotoolbarEnableRunZDE(true)",5000);

	} catch(e) { alert("Failed to run "+cmd+".\nCheck if the specified path is correct."); }
}