/* 
   - The contents of this file are subject to the Mozilla Public
   - License Version 1.1 (the "License"); you may not use this file
   - except in compliance with the License. You may obtain a copy of
   - the License at http://www.mozilla.org/MPL/
   -
   - Software distributed under the License is distributed on an "AS
   - IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
   - implied. See the License for the specific language governing
   - rights and limitations under the License.
   -
   - The Original Code is this file as it was released on
   - April 1, 2001.
   -
   - The Initial Developer of the Original Code is Henk-Johan van Rantwijk.
   - Portions created by Henk-Johan van Rantwijk are Copyright (C) 2001
   - Henk-Johan van Rantwijk.  All Rights Reserved.
   -
   - Contributor(s):
   -  Henk-Johan van Rantwijk <bugs4hj@netscape.net> (Original Author)
   -  David Perry <d.perry@utoronto.ca>
   -
   - Alternatively, the contents of this file may be used under the
   - terms of the GNU General Public License Version 2 or later (the
   - "GPL"), in which case the provisions of the GPL are applicable
   - instead of those above.  If you wish to allow use of your
   - version of this file only under the terms of the GPL and not to
   - allow others to use your version of this file under the MPL,
   - indicate your decision by deleting the provisions above and
   - replace them with the notice and other provisions required by
   - the GPL.  If you do not delete the provisions above, a recipient
   - may use your version of this file under either the MPL or the
   - GPL.
   -
*/

////////////////////////////////////////////////////////////////////////////////
// this returns a short URL from the given url, used for stickyName
////////////////////////////////////////////////////////////////////////////////
function defineShortURL( aURI )
{
  var i = aURI.indexOf(":");

  if ( i != -1 ) {
    while( !isAlphaNum( aURI[ i ] ) )
      i++;
    return aURI.substring( i, aURI.length );
  }
  return aURI;
}
////////////////////////////////////////////////////////////////////////////////
// this function returns the URL read from the clipboard
////////////////////////////////////////////////////////////////////////////////
function getLocationFromClipboard()
{
  var url;

  try {
    var clipboard = Components.classes[ "@mozilla.org/widget/clipboard;1" ]
                              .getService(Components.interfaces.nsIClipboard);

    var trans = Components.classes[ "@mozilla.org/widget/transferable;1" ]
                          .createInstance(Components.interfaces.nsITransferable);

    trans.addDataFlavor( "text/unicode" );
    clipboard.getData( trans, clipboard.kGlobalClipboard );

    var data = {};
    var dataLen = {};
    trans.getTransferData( "text/unicode", data, dataLen );

    if ( data ) {
      data = data.value.QueryInterface( Components.interfaces.nsISupportsWString );
      url = data.data.substring( 0, dataLen.value / 2 );
    }
    else {
      url = 'about:blank';
      alert('Sorry, Clipboard contains no data');
    }
  } catch ( ex ) {
    alert( 'Warning: Read From Clipboard Error' );
  }
  return url;
}
////////////////////////////////////////////////////////////////////////////////
// this function displays the current software version number
////////////////////////////////////////////////////////////////////////////////
function displayVersion()
{
  var mVersion = getBrowser().mVersion;
  window.openDialog( "chrome://multiviews/content/multiviewsAbout.xul",
                     "multiviewsClose", "chrome, dialog, dependent", 
                      mVersion, loadURI );
}
////////////////////////////////////////////////////////////////////////////////
// this function checks the website for a new update of MultiZilla
////////////////////////////////////////////////////////////////////////////////
function doCheck4Updates()
{
  var mVersion = getBrowser().mVersion;
  getBrowser().addTab( 'http://multizilla.mozdev.org/update.html?version=' + mVersion );
}
////////////////////////////////////////////////////////////////////////////////
// this function handles the ShutDown stuff
////////////////////////////////////////////////////////////////////////////////
function validateThisPage( aURL )
{
  if ( aURL ) {
    var IOService = Components.classes[ "@mozilla.org/network/io-service;1" ].
                               getService( Components.interfaces.nsIIOService );

    if (!IOService)
       return;
    var scheme = "";

    try {
     scheme = IOService.extractScheme( aURL, {schemeStartPos:0}, {schemeEndPos:0});
    } catch ( ex ) { alert('error') }

    if ( scheme == "http" ) {
      var checkURL = "http://validator.w3.org/check?uri=" + aURL + 
                     "&charset=%28detect+automatically%29&doctype=Inline";
      getBrowser().addTab( checkURL );
    }
    else alert( "Can't handle used protocol type "+ scheme +":\nThis validator supports http: only" );
  }
}
////////////////////////////////////////////////////////////////////////////////
// this function gets a localized string from chrome:multiviews.properties
////////////////////////////////////////////////////////////////////////////////
function getTextFromBundle(aStr) {
  var multiviewsBundle = "chrome://multiviews/locale/multiviews.properties";
  var aBundle = srGetStrBundle( multiviewsBundle );
  var aLabel = aBundle.GetStringFromName( aStr );
  return aLabel;
}
////////////////////////////////////////////////////////////////////////////////
// this function returns true if a given string is all alphanumeric
// Adapted from chrome/content/communitcator/pref/pref-languages.js
////////////////////////////////////////////////////////////////////////////////
function isAlphaNum(mixedCase) {
  var allCaps = mixedCase.toUpperCase();
  for (var i = allCaps.length - 1; i >= 0; i--) {
    var c = allCaps.charAt(i);
    if ((c < 'A' || c > 'Z') && (c < '0' || c > '9') && (c!='_'))
      return false;
  }
  return true;
}
//////////////////////////////////////////////////////////////////////////
// this function returns a, spoofed, referrer
//////////////////////////////////////////////////////////////////////////
function spoofReferrer(url, referrer)
{
  var spoofURL = "http://ref.spoof.org/refspoof.cgi"; // default fake referrer
  var ioService = Components.classes["@mozilla.org/network/io-service;1"]
                            .getService(Components.interfaces.nsIIOService);
  var spoofing = readMyPref("multizilla.refspoof.spoofing", "int", 3);
  switch (spoofing) {
    case 1: // send original referrer
      referrer = getDocumentReferrer(document);
    case 2: // send url as referrer
      spoofURL = url;
      try {
        referrer = ioService.newURI(spoofURL, null, null);
      } catch(ex) {
      }
      break;
    default: // send fake referrer
      try {
        spoofURL = pref.getComplexValue("multizilla.refspoof.spoofurl",
                                        Components.interfaces.nsIPrefLocalizedString).data;
      } catch (ex) {
      }
      referrer = ioService.newURI(spoofURL, null, null);
  }
  return(referrer);
}
//////////////////////////////////////////////////////////////////////////
// this is a changed function (contentAreaUtils.js) to make spoofing work
//////////////////////////////////////////////////////////////////////////
function getDocumentReferrer(doc)
{
  var focusedWindow = doc.commandDispatcher.focusedWindow;
  var sourceURL = "";
  if (focusedWindow)
    sourceURL = isDocumentFrame(focusedWindow) ? focusedWindow.location.href : focusedWindow._content.location.href;
  try {
    var uri = Components.classes["@mozilla.org/network/standard-url;1"]
                        .createInstance(Components.interfaces.nsIURI);
    uri.spec = sourceURL;
    return uri;
  } catch (ex) {
    return null;
  }
}
//////////////////////////////////////////////////////////////////////////
// This is a quick hack to work around the PT folders bug. It should be 
// removed when the corresponding mozilla bug is fixed. I'm sure this fix 
// isn't 100% reliable but than again, what is?
//////////////////////////////////////////////////////////////////////////
function handlePTFolders(node)
{
  if (!node.hasChildNodes())
    return; // no folder, bail out
  var personalToolbar = node.parentNode;
  // 'hbox' for folders and 'toolbox' for the Bookmarks button 
  if (personalToolbar.nodeName == "hbox")
    personalToolbar = personalToolbar.parentNode;
  if ("lastPopup" in personalToolbar && personalToolbar.lastPopup != null) {
    node = node.firstChild;
    if (node.nodeName == "menupopup") {
      if (personalToolbar.lastPopup != null)
        personalToolbar.lastPopup.hidePopup();
      node.showPopup(node);
    }
  }
}