const X_MSG             = "Install htmlheader";
const X_NAME            = "htmlheader";
const X_VER             = "0.0.3";
const X_JAR_FILE        = "htmlheader.jar";
const X_CONTENT         = "content/";
//const X_SKIN            = "skin/";
const X_LOCALE          = "locale/en-US/";
const X_CHROME          = "chrome";

var srDest = 1;

var err = initInstall(X_MSG, X_NAME, X_VER); 
logComment("initInstall: " + err);

logComment( "Installation started ..." );
// add software to the installation

if (verifyDiskSpace(getFolder("Program"), srDest))
{
    addFile("We're on our way ...", 
            X_JAR_FILE,           // jar source folder
            getFolder(X_CHROME),  // target folder
            "");                  // target subdir

    registerChrome(PACKAGE | DELAYED_CHROME, getFolder(X_CHROME, X_JAR_FILE), X_CONTENT);
//    registerChrome(SKIN | DELAYED_CHROME, getFolder(X_CHROME, X_JAR_FILE), X_SKIN);
    registerChrome(LOCALE | DELAYED_CHROME, getFolder(X_CHROME, X_JAR_FILE), X_LOCALE);

    err = getLastError();
    if ( err == SUCCESS )  {      // if there have been no errors:
      performInstall();           // install "htmlheader.jar"
      alert("Please restart to activate the program");
    }
    else  {                       // otherwise
      cancelInstall();            // cancel the installation.
    }
}
else
    cancelInstall(INSUFFICIENT_DISK_SPACE);

// this function verifies disk space in kilobytes
function verifyDiskSpace(dirPath, spaceRequired)
{
  var spaceAvailable;

  // Get the available disk space on the given path
  spaceAvailable = fileGetDiskSpaceAvailable(dirPath);

  // Convert the available disk space into kilobytes
  spaceAvailable = parseInt(spaceAvailable / 1024);

  // do the verification
  if(spaceAvailable < spaceRequired)
  {
    logComment("Insufficient disk space: " + dirPath);
    logComment("  required : " + spaceRequired + " K");
    logComment("  available: " + spaceAvailable + " K");
    return(false);
  }

  return(true);
}