#include "StmBossKey.h" 
#include "TCHAR.H"
//#include "mozilla/mozalloc.h"

#ifndef _DEBUG
 // default lib setting.
 #pragma comment(linker, "/defaultlib:kernel32.lib") 
 #pragma comment(linker, "/nodefaultlib:libc.lib")
 #pragma comment(linker, "/nodefaultlib:libcmt.lib")
 // section size
 //#pragma comment(linker, "/FILEALIGN:16")
 //#pragma comment(linker, "/ALIGN:16") 
 //#pragma comment(linker, "/OPT:NOWIN98")
 // section merge
 //#pragma comment(linker, "/MERGE:.rdata=.data")
 //#pragma comment(linker, "/MERGE:.text=.data")
 //#pragma comment(linker, "/MERGE:.reloc=.data")

#endif


NS_IMPL_ISUPPORTS1(StmBossKey, IStmBossKey)

#define WM_STMTRAYICON (WM_USER + 0x17b6)
#define STMTRAYMENU_EXITFF 100
#define STMTRAYMENU_RESTORE 101
#define PROP_DLLINST _T("STM_DLLINSTANCE")
#define PROP_ORIGWINPROC _T("STM_ORIGWINPROC")

ATOM StmBossKey::s_wndClass = NULL;

StmBossKey::StmBossKey() {
    m_hideKeyMOD = NULL;
    m_hideKeyVK = NULL;
    m_restoreKeyMOD = NULL;
    m_restoreKeyVK = NULL;

    m_HIDETOSYSTRAY = false;
    m_MINIMIZETOSYSTRAY = false;
    m_CLOSETOSYSTRAY = false;

    m_hideKeyRegistered = false;
    m_restoreKeyRegistered = false;
    m_dupRestoreKeyRegistered = false;

    m_TrayIconAdded = false;

    HotKeyId_Hide = 0;
    HotKeyId_Restore = 0;

    m_hPopupMenu = NULL;
    m_ListenerWindow = NULL;

    ffwndhp = NULL;
    ffwndtp = NULL;
    ffwndcp = NULL;
    m_ffwndCount = 0;
	m_ffwndCount_pre = 0;
}

StmBossKey::~StmBossKey() {
}

NS_IMETHODIMP StmBossKey::HideEntry(int32_t aFlg,
                                    const char *aKeyMOD = NULL, 
                                    uint32_t aKeyVK = NULL, 
                                    const PRUnichar *aTrayToolTips = NULL, 
                                    const PRUnichar *aParamRestore = NULL, 
                                    const PRUnichar *aParamExit = NULL
                                    ) {
	UINT modifier = 0;
    switch(aFlg) {
        case 1:
            if (m_dupRestoreKeyRegistered && m_ffwndCount_pre == GetFFWinCount()) {
                HideEntry(99);
                break;
            }

            HideFirefoxWindows(true);
            RegisterRestoreKey(true);
            if (m_HIDETOSYSTRAY) {
                ShowTrayIcon(ffwndhp->data, true);
            } else {
                ShowTrayIcon(NULL, false);
            }
            break;
        case 3:
        case 4:
            HideFirefoxWindows(true);
            ShowTrayIcon(ffwndhp->data, true);
            break;
        case 1101:
            RegisterHideKey(true);
            break;
        case 1102:
            RegisterHideKey(false);
            break;
        case 2201:
            SaveTrayStr(aTrayToolTips, aParamRestore, aParamExit);
            m_HIDETOSYSTRAY = true;
            break;
        case 2202:
            m_HIDETOSYSTRAY = false;
            break;
        case 2301:
            SaveTrayStr(aTrayToolTips, aParamRestore, aParamExit);
            m_MINIMIZETOSYSTRAY = true;
            PatchFFWindows(true);
            break;
        case 2401:
            SaveTrayStr(aTrayToolTips, aParamRestore, aParamExit);
            m_CLOSETOSYSTRAY = true;
            PatchFFWindows(true);
            break;
        case 2302:
            m_MINIMIZETOSYSTRAY = false;
            PatchFFWindows(false);
            break;
        case 2402:
            m_CLOSETOSYSTRAY = false;
            PatchFFWindows(false);
            break;
        case 1201:
            modifier = GetModifier(aKeyMOD);
            if (m_hideKeyMOD == modifier && m_hideKeyVK == aKeyVK)
                break;
            ResetHotKey(1, modifier, aKeyVK);
            break;
        case 1202:
            modifier = GetModifier(aKeyMOD);
            if (m_restoreKeyMOD == modifier && m_restoreKeyVK == aKeyVK)
                break;
            ResetHotKey(2, modifier, aKeyVK);
            break;
        case 95:
            if (m_hideKeyRegistered) ::UnregisterHotKey(m_ListenerWindow, HotKeyId_Hide);
            if (m_restoreKeyRegistered) ::UnregisterHotKey(m_ListenerWindow, HotKeyId_Restore);
            break;
        case 96:
            if (m_hideKeyRegistered) ::RegisterHotKey(m_ListenerWindow, HotKeyId_Hide, m_hideKeyMOD, m_hideKeyVK); 
            if (m_restoreKeyRegistered) ::RegisterHotKey(m_ListenerWindow, HotKeyId_Restore, m_restoreKeyMOD, m_restoreKeyVK); 
            break;
        case 99:  // restore
            HideFirefoxWindows(false);
            ShowTrayIcon(NULL, false);
            RegisterRestoreKey(false);
            break;
        case 100:  // exit
            DeleteFFWndList();
            GetFFWindows();
            ffwndcp = ffwndtp;
            while (ffwndcp) {
                DestroyWindow(ffwndcp->data);
                ffwndcp = ffwndcp->pre;
            }
            ShowTrayIcon(NULL, false);
            RegisterHideKey(false);
            RegisterRestoreKey(false);
            CreateListenerWindow(false);
            break;
    }

    return NS_OK;
}

void StmBossKey::HideFirefoxWindows(bool aHide) {
    if (aHide) {
        DeleteFFWndList();
        GetFFWindows();
        HideFFWindows();
    } else {
        ffwndcp = ffwndtp;
        while (ffwndcp) {
            ::ShowWindow(ffwndcp->data, SW_SHOW);
            ::SetForegroundWindow(ffwndcp->data);
            ffwndcp = ffwndcp->pre;
        }
        DeleteFFWndList();
    }
}

void StmBossKey::RegisterHideKey(bool aRegister) {
    if (aRegister) {
        if (!m_hideKeyRegistered) {
            CreateListenerWindow(true);

            TCHAR* PRJName = _T("StmBossKey_HideKey");
            HotKeyId_Hide = ::GlobalFindAtom(PRJName);
            if(HotKeyId_Hide == 0) 
                HotKeyId_Hide = ::GlobalAddAtom(PRJName);
            ::RegisterHotKey(m_ListenerWindow, HotKeyId_Hide, m_hideKeyMOD, m_hideKeyVK); 

            m_hideKeyRegistered = true;
        }
    } else {
        if (m_hideKeyRegistered) {
            ::UnregisterHotKey(m_ListenerWindow, HotKeyId_Hide);
            m_hideKeyRegistered = false;
            CreateListenerWindow(false);
        }
    }
}

void StmBossKey::RegisterRestoreKey(bool aRegister) {
    if (aRegister) {
        if (!m_restoreKeyRegistered) {
            if (m_hideKeyRegistered && m_hideKeyMOD == m_restoreKeyMOD && m_hideKeyVK == m_restoreKeyVK) {
                m_dupRestoreKeyRegistered = true;
            } else {
                CreateListenerWindow(true);

                TCHAR* PRJName = _T("StmBossKey_RestoreKey");
                HotKeyId_Restore = ::GlobalFindAtom(PRJName);
                if(HotKeyId_Restore == 0) 
                    HotKeyId_Restore = ::GlobalAddAtom(PRJName);
                ::RegisterHotKey(m_ListenerWindow, HotKeyId_Restore, m_restoreKeyMOD, m_restoreKeyVK); 
            }

            m_restoreKeyRegistered = true;
        }
        m_ffwndCount_pre = m_ffwndCount;
    } else {
        if (m_restoreKeyRegistered) {
            ::UnregisterHotKey(m_ListenerWindow, HotKeyId_Restore);
            m_restoreKeyRegistered = false;
            m_dupRestoreKeyRegistered = false;
            CreateListenerWindow(false);
        }
    }
}

void StmBossKey::ShowTrayIcon(HWND aIconHwnd, bool aShow) {
    if (aShow) {
        if (!m_TrayIconAdded) {
            CreateListenerWindow(true);

            m_nid.cbSize = sizeof(NOTIFYICONDATA);
            m_nid.hWnd = m_ListenerWindow;
            m_nid.uID = 1;
            m_nid.uFlags = NIF_ICON|NIF_TIP|NIF_MESSAGE;
            GetIcon(aIconHwnd, m_nid.hIcon);
            wcscpy_s (m_nid.szTip, m_TrayTips_Str);
            m_nid.uCallbackMessage = WM_STMTRAYICON;
            ::Shell_NotifyIcon(NIM_ADD, &m_nid);
            m_TrayIconAdded = true;
        }
    } else {
        ::Shell_NotifyIcon(NIM_DELETE, &m_nid);
        m_TrayIconAdded = false;
        CreateListenerWindow(false);
    }
}

void StmBossKey::SaveTrayStr(const PRUnichar *aTrayToolTips, 
                             const PRUnichar *aParamRestore, 
                             const PRUnichar *aParamExit
                             ) {
    wcscpy_s(m_TrayTips_Str, aTrayToolTips);
    wcscpy_s(m_TrayRestore_Str, aParamRestore);
    wcscpy_s(m_TrayExit_Str, aParamExit);
}

void StmBossKey::PatchFFWindows(bool aPatch) { 
    DeleteFFWndList();
    GetFFWindows();
    if (aPatch) {
        ffwndcp = ffwndhp;
        HWND hFF = 0;
        while (ffwndcp) {
            hFF = ffwndcp->data;
            if (!GetProp(hFF, PROP_DLLINST)) {
                LONG origWinProc = SetWindowLong(hFF, GWL_WNDPROC, (LONG)FFWindowProc);
                ::SetProp(hFF, PROP_ORIGWINPROC, (HANDLE)origWinProc);
                ::SetProp(hFF, PROP_DLLINST, (HANDLE)this);
            }
            ffwndcp = ffwndcp->next;
        }
    } else {
        if (!m_MINIMIZETOSYSTRAY && !m_CLOSETOSYSTRAY) {
            ffwndcp = ffwndhp;
            HWND hFF = 0;
            while (ffwndcp) {
                hFF = ffwndcp->data;
                if (GetProp(hFF, PROP_DLLINST)) {
                    SetWindowLong(hFF, GWL_WNDPROC, (LONG)GetProp(hFF, PROP_ORIGWINPROC));
                    ::RemoveProp(hFF, PROP_DLLINST);
                }
                ffwndcp = ffwndcp->next;
            }
        }
    }
}

void StmBossKey::ResetHotKey(int aFlg, UINT aModifier, PRUint32 aKeyVK) { 
    if (aFlg == 1) {
        m_hideKeyMOD = aModifier;
        m_hideKeyVK = aKeyVK;
        if (m_hideKeyRegistered) {
            RegisterHideKey(false);
            RegisterHideKey(true);
        }
    } else if (aFlg == 2){
        m_restoreKeyMOD = aModifier;
        m_restoreKeyVK = aKeyVK;
        if (m_restoreKeyRegistered) {
            RegisterRestoreKey(false);
            RegisterRestoreKey(true);
        }
    }
}

void StmBossKey::DeleteFFWndList() {
	while (ffwndhp) {
	    ffwndcp = ffwndhp; ffwndhp = ffwndhp->next;
		delete ffwndcp;
	}
}

int StmBossKey::GetFFWinCount() {
    int count = 0;
	HWND hFF = 0;
	do {
		hFF = ::FindWindowEx(0, hFF, _T("MozillaWindowClass"), 0);

        TCHAR wndTitle[255];
        ::GetWindowText(hFF,wndTitle,255);

		if (hFF && wcscmp(wndTitle, TEXT("")) != 0) count++;
	} while (hFF);
    return count;
}

void StmBossKey::GetFFWindows() {
    ffwndhp = NULL; ffwndtp = NULL;
	HWND hFF = 0;
    m_ffwndCount = 0;
	do {
		hFF = ::FindWindowEx(0, hFF, _T("MozillaWindowClass"), 0);

        TCHAR wndTitle[255];
        ::GetWindowText(hFF,wndTitle,255);

		if (hFF && wcscmp(wndTitle, TEXT("")) != 0) {   //for 4.x
			if (!ffwndhp) {
				ffwndhp = ffwndtp = new STMFFWNDLIST;
				ffwndtp->data = hFF; ffwndtp->pre = ffwndtp->next = NULL;
			} else {
				ffwndtp->next = new STMFFWNDLIST;
                ffwndtp->next->pre = ffwndtp; ffwndtp = ffwndtp->next;
				ffwndtp->data = hFF; ffwndtp->next = NULL;
			}
            m_ffwndCount++;
		}
	} while (hFF);
}

void StmBossKey::HideFFWindows() {
	ffwndcp = ffwndhp;
	while (ffwndcp) {
		::ShowWindow(ffwndcp->data, SW_HIDE);
		ffwndcp = ffwndcp->next;
	}
}

void StmBossKey::CreateListenerWindow(bool aCreate) { 
    if (aCreate) {
        if (m_ListenerWindow == NULL) {
            HINSTANCE hInst = ::GetModuleHandle(NULL);
            if (!s_wndClass) {
                WNDCLASS wndClassDef;
                wndClassDef.style          = CS_NOCLOSE | CS_GLOBALCLASS;
                wndClassDef.lpfnWndProc    = WindowProc;
                wndClassDef.cbClsExtra     = 0;
                wndClassDef.cbWndExtra     = 0;
                wndClassDef.hInstance      = hInst;
                wndClassDef.hIcon          = NULL;
                wndClassDef.hCursor        = NULL;
                wndClassDef.hbrBackground  = NULL;
                wndClassDef.lpszMenuName   = NULL;
                wndClassDef.lpszClassName  = TEXT("SuperTabMode:MsgWindowClass");

                s_wndClass = ::RegisterClass(&wndClassDef);
            }
            m_ListenerWindow = ::CreateWindow(
                        (LPCTSTR)s_wndClass,                  //class
                        TEXT("SuperTabMode:MsgWindow"),       //caption
                        WS_MINIMIZE,                          //style
                        CW_USEDEFAULT,                        //x
                        CW_USEDEFAULT,                        //y
                        CW_USEDEFAULT,                        //width
                        CW_USEDEFAULT,                        //height
                        ::GetDesktopWindow(),                 //parent
                        NULL,                                 //menu
                        hInst,                                //hInst
                        NULL);                                //param
            ::SetProp(m_ListenerWindow, PROP_DLLINST, (HANDLE)this);
            if (!m_ListenerWindow)
                if (::UnregisterClass((LPCTSTR)s_wndClass, hInst))
                    s_wndClass = NULL;
        }
    } else {
        if (m_ListenerWindow != NULL && !m_TrayIconAdded && !m_hideKeyRegistered && !m_restoreKeyRegistered) {
            ::DestroyWindow(m_ListenerWindow);
            m_ListenerWindow = NULL;
        }
    }
}

UINT StmBossKey::GetModifier(const char *aKeyMOD) { 
    UINT modifiers = 0;
	if (aKeyMOD[0] == '1') modifiers |= MOD_CONTROL;
	if (aKeyMOD[1] == '1') modifiers |= MOD_SHIFT;
	if (aKeyMOD[2] == '1') modifiers |= MOD_ALT;
	if (aKeyMOD[3] == '1') modifiers |= MOD_WIN;
    return modifiers;
}

void StmBossKey::GetIcon(HWND hWnd, HICON& result) {
    result = (HICON)::SendMessage(hWnd, WM_GETICON, ICON_SMALL, NULL);
    if (!result) result = (HICON)::GetClassLong(hWnd, GCL_HICONSM);
    if (!result) result = ::LoadIcon(NULL, IDI_WINLOGO);
}

LRESULT CALLBACK StmBossKey::FFWindowProc(HWND hWnd,
                                          UINT uMsg,
                                          WPARAM wParam,
                                          LPARAM lParam
                                          ) {
    StmBossKey* self = (StmBossKey*)GetProp(hWnd, PROP_DLLINST);
    if ((self->m_MINIMIZETOSYSTRAY && uMsg == WM_SIZE && wParam == SIZE_MINIMIZED) 
     || (self->m_CLOSETOSYSTRAY && uMsg == WM_CLOSE)) {
        if (!(self->m_CLOSETOSYSTRAY && uMsg == WM_CLOSE))
			::ShowWindow(hWnd, SW_RESTORE);
        self->DeleteFFWndList();
        self->GetFFWindows();
        self->HideFFWindows();
        self->ShowTrayIcon(hWnd, true);
        return true;
    }
    return ::CallWindowProc((WNDPROC)GetProp(hWnd, PROP_ORIGWINPROC), hWnd, uMsg, wParam, lParam);
}

void StmBossKey::ShowPopupMenus() {
    if (!m_hPopupMenu) {
        m_hPopupMenu = ::CreatePopupMenu();
        ::AppendMenu(m_hPopupMenu, MF_STRING, STMTRAYMENU_RESTORE, m_TrayRestore_Str);
        ::AppendMenu(m_hPopupMenu, MF_SEPARATOR, NULL, NULL);
        ::AppendMenu(m_hPopupMenu, MF_STRING, STMTRAYMENU_EXITFF, m_TrayExit_Str);
    }
    POINT mPos;
    ::GetCursorPos(&mPos);
    ::SetForegroundWindow(m_ListenerWindow);
    ::TrackPopupMenu(m_hPopupMenu, 0, mPos.x, mPos.y, 0, m_ListenerWindow, 0); 
}

LRESULT CALLBACK StmBossKey::WindowProc(HWND hWnd,
                                        UINT uMsg,
                                        WPARAM wParam,
                                        LPARAM lParam) {
    StmBossKey* self = (StmBossKey*)GetProp(hWnd, PROP_DLLINST);
    switch(uMsg) {
        case WM_HOTKEY:
			if((int)wParam == self->HotKeyId_Restore) {
				if (self->m_hideKeyMOD == self->m_restoreKeyMOD && self->m_hideKeyVK == self->m_restoreKeyVK) {
                    self->m_dupRestoreKeyRegistered = true;
					self->HideEntry(1);
				} else
                    self->HideEntry(99);
			} else if ((int)wParam == self->HotKeyId_Hide) 
                self->HideEntry(1);
            break;
        case WM_STMTRAYICON:
            switch(lParam) {
                case WM_LBUTTONUP:
                    self->HideEntry(99);
                    break;
                case WM_RBUTTONDOWN:
                    self->ShowPopupMenus();
                    break;
            }
            break;
        case WM_COMMAND:
            switch(wParam) {
                case STMTRAYMENU_EXITFF:
                    self->HideEntry(100);
                    break;
                case STMTRAYMENU_RESTORE:
                    self->HideEntry(99);
                    break;
            }
            break;            
    }
    return ::CallWindowProc(DefWindowProc, hWnd, uMsg, wParam, lParam);
}