/*
 * Decompiled with CFR 0.152.
 */
package eu.bibl.banalysis.asm.refactor;

import eu.bibl.banalysis.asm.ClassNode;
import eu.bibl.banalysis.asm.refactor.asm.RefactorMapper;
import eu.bibl.banalysis.storage.HookMap;
import eu.bibl.banalysis.storage.classes.ClassContainer;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;

public class Refactorer {
    protected HookMap hooks;
    protected ClassContainer container;

    public Refactorer(HookMap hooks) {
        this.setHooks(hooks);
    }

    public Refactorer(ClassContainer ct) {
        this.setContainer(ct);
    }

    public Refactorer(HookMap hooks, ClassContainer ct) {
        this.setHooks(hooks);
        this.setContainer(ct);
    }

    public HookMap getHooks() {
        return this.hooks;
    }

    public void setHooks(HookMap hooks) {
        this.hooks = hooks;
    }

    public ClassContainer getContainer() {
        return this.container;
    }

    public void setContainer(ClassContainer ct) {
        this.container = ct;
    }

    public void run() {
        if (this.getHooks() == null) {
            return;
        }
        if (this.getContainer() == null) {
            return;
        }
        RefactorMapper mapper = new RefactorMapper(this.getHooks());
        HashMap<String, ClassNode> refactored = new HashMap<String, ClassNode>();
        for (ClassNode classNode : this.getContainer().getNodes().values()) {
            String oldName = classNode.name;
            ClassReader cr = new ClassReader(this.getClassNodeBytes(classNode));
            ClassWriter cw = new ClassWriter(cr, 0);
            RemappingClassAdapter rca = new RemappingClassAdapter((ClassVisitor)cw, (Remapper)mapper);
            cr.accept((ClassVisitor)rca, 8);
            cr = new ClassReader(cw.toByteArray());
            ClassNode classNode2 = new ClassNode();
            cr.accept((ClassVisitor)classNode2, 0);
            refactored.put(oldName, classNode2);
        }
        for (Map.Entry entry : refactored.entrySet()) {
            this.getContainer().relocate((String)entry.getKey(), (ClassNode)((Object)entry.getValue()));
        }
    }

    private byte[] getClassNodeBytes(ClassNode cn) {
        ClassWriter cw = new ClassWriter(0);
        cn.accept((ClassVisitor)cw);
        byte[] b = cw.toByteArray();
        return b;
    }
}

