/*
 * Decompiled with CFR 0.152.
 */
package eu.bibl.banalysis.storage;

import eu.bibl.banalysis.storage.ClassMappingData;
import eu.bibl.banalysis.storage.Identifiable;
import eu.bibl.banalysis.storage.MappingData;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class CallbackMappingData
extends Identifiable {
    protected ClassMappingData methodOwner;
    protected ClassMappingData callbackOwner;
    protected MappingData methodName;
    protected MappingData methodDesc;
    protected MappingData callbackName;
    protected MappingData callbackDesc;
    protected boolean isStatic;

    public CallbackMappingData(MappingData methodName, MappingData methodDesc, MappingData callbackName, MappingData callbackDesc, boolean isStatic) {
        this(null, null, methodName, methodDesc, callbackName, callbackDesc, isStatic);
    }

    public CallbackMappingData(ClassMappingData methodOwner, ClassMappingData callbackOwner, MappingData methodName, MappingData methodDesc, MappingData callbackName, MappingData callbackDesc, boolean isStatic) {
        this.methodOwner = methodOwner;
        this.callbackOwner = callbackOwner;
        this.methodName = methodName;
        this.methodDesc = methodDesc;
        this.callbackName = callbackName;
        this.callbackDesc = callbackDesc;
        this.isStatic = isStatic;
    }

    public CallbackMappingData buildObfMethod(MethodInsnNode min) {
        if (this.methodName != null) {
            this.methodName.setObfuscatedName(min.name);
        }
        if (this.methodDesc != null) {
            this.methodDesc.setObfuscatedName(min.desc);
        }
        return this;
    }

    public CallbackMappingData buildObfMethod(MethodNode mn) {
        if (this.methodName != null) {
            this.methodName.setObfuscatedName(mn.name);
        }
        if (this.methodDesc != null) {
            this.methodDesc.setObfuscatedName(mn.desc);
        }
        return this;
    }

    public CallbackMappingData buildRefacMethod(MethodInsnNode min) {
        if (this.methodName != null) {
            this.methodName.setRefactoredName(min.name);
        }
        if (this.methodDesc != null) {
            this.methodDesc.setRefactoredName(min.desc);
        }
        return this;
    }

    public CallbackMappingData buildRefacMethod(MethodNode mn) {
        if (this.methodName != null) {
            this.methodName.setRefactoredName(mn.name);
        }
        if (this.methodDesc != null) {
            this.methodDesc.setRefactoredName(mn.desc);
        }
        return this;
    }

    public CallbackMappingData buildObfCallback(MethodInsnNode min) {
        if (this.callbackName != null) {
            this.callbackName.setObfuscatedName(min.name);
        }
        if (this.methodDesc != null) {
            this.methodDesc.setObfuscatedName(min.desc);
        }
        return this;
    }

    public CallbackMappingData buildObfCallback(MethodNode mn) {
        if (this.callbackName != null) {
            this.callbackName.setObfuscatedName(mn.name);
        }
        if (this.callbackDesc != null) {
            this.callbackDesc.setObfuscatedName(mn.desc);
        }
        return this;
    }

    public CallbackMappingData buildRefacCallback(MethodInsnNode min) {
        if (this.callbackName != null) {
            this.callbackName.setRefactoredName(min.name);
        }
        if (this.callbackDesc != null) {
            this.callbackDesc.setRefactoredName(min.desc);
        }
        return this;
    }

    public CallbackMappingData buildRefacCallback(MethodNode mn) {
        if (this.callbackName != null) {
            this.callbackName.setRefactoredName(mn.name);
        }
        if (this.callbackDesc != null) {
            this.callbackDesc.setRefactoredName(mn.desc);
        }
        return this;
    }

    public MappingData getMethodOwner() {
        return this.methodOwner;
    }

    public CallbackMappingData setMethodOwner(ClassMappingData methodOwner) {
        this.methodOwner = methodOwner;
        return this;
    }

    public MappingData getCallbackOwner() {
        return this.callbackOwner;
    }

    public CallbackMappingData setCallbackOwner(ClassMappingData callbackOwner) {
        this.callbackOwner = callbackOwner;
        return this;
    }

    public MappingData getMethodName() {
        return this.methodName;
    }

    public CallbackMappingData setMethodName(MappingData methodName) {
        this.methodName = methodName;
        return this;
    }

    public MappingData getMethodDesc() {
        return this.methodDesc;
    }

    public CallbackMappingData setMethodDesc(MappingData methodDesc) {
        this.methodDesc = methodDesc;
        return this;
    }

    public MappingData getCallbackName() {
        return this.callbackName;
    }

    public CallbackMappingData setCallbackName(MappingData callbackName) {
        this.callbackName = callbackName;
        return this;
    }

    public MappingData getCallbackDesc() {
        return this.callbackDesc;
    }

    public CallbackMappingData setCallbackDesc(MappingData callbackDesc) {
        this.callbackDesc = callbackDesc;
        return this;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public CallbackMappingData setStatic(boolean isStatic) {
        this.isStatic = isStatic;
        return this;
    }

    @Override
    public CallbackMappingData identify() {
        super.identify();
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.callbackDesc == null ? 0 : this.callbackDesc.hashCode());
        result = 31 * result + (this.callbackName == null ? 0 : this.callbackName.hashCode());
        result = 31 * result + (this.callbackOwner == null ? 0 : this.callbackOwner.hashCode());
        result = 31 * result + (this.isStatic ? 1231 : 1237);
        result = 31 * result + (this.methodDesc == null ? 0 : this.methodDesc.hashCode());
        result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
        result = 31 * result + (this.methodOwner == null ? 0 : this.methodOwner.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CallbackMappingData other = (CallbackMappingData)obj;
        if (this.callbackDesc == null ? other.callbackDesc != null : !this.callbackDesc.equals(other.callbackDesc)) {
            return false;
        }
        if (this.callbackName == null ? other.callbackName != null : !this.callbackName.equals(other.callbackName)) {
            return false;
        }
        if (this.callbackOwner == null ? other.callbackOwner != null : !this.callbackOwner.equals(other.callbackOwner)) {
            return false;
        }
        if (this.isStatic != other.isStatic) {
            return false;
        }
        if (this.methodDesc == null ? other.methodDesc != null : !this.methodDesc.equals(other.methodDesc)) {
            return false;
        }
        if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
            return false;
        }
        return !(this.methodOwner == null ? other.methodOwner != null : !this.methodOwner.equals(other.methodOwner));
    }
}

