/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.indexer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.service.indexer.AbstractIndexerProvider;
import org.jd.gui.util.exception.ExceptionUtil;
import org.jd.gui.util.parser.antlr.ANTLRJavaParser;
import org.jd.gui.util.parser.antlr.AbstractJavaListener;
import org.jd.gui.util.parser.antlr.JavaParser;

public class JavaFileIndexerProvider
extends AbstractIndexerProvider {
    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:file:*.java");
    }

    @Override
    public void index(API api, Container.Entry entry, Indexes indexes) {
        block16: {
            try (InputStream inputStream = entry.getInputStream();){
                Listener listener = new Listener(entry);
                ANTLRJavaParser.parse((CharStream)new ANTLRInputStream(inputStream), listener);
                JavaFileIndexerProvider.addToIndexes(indexes, "typeDeclarations", listener.getTypeDeclarationSet(), entry);
                JavaFileIndexerProvider.addToIndexes(indexes, "constructorDeclarations", listener.getConstructorDeclarationSet(), entry);
                JavaFileIndexerProvider.addToIndexes(indexes, "methodDeclarations", listener.getMethodDeclarationSet(), entry);
                JavaFileIndexerProvider.addToIndexes(indexes, "fieldDeclarations", listener.getFieldDeclarationSet(), entry);
                JavaFileIndexerProvider.addToIndexes(indexes, "typeReferences", listener.getTypeReferenceSet(), entry);
                JavaFileIndexerProvider.addToIndexes(indexes, "constructorReferences", listener.getConstructorReferenceSet(), entry);
                JavaFileIndexerProvider.addToIndexes(indexes, "methodReferences", listener.getMethodReferenceSet(), entry);
                JavaFileIndexerProvider.addToIndexes(indexes, "fieldReferences", listener.getFieldReferenceSet(), entry);
                JavaFileIndexerProvider.addToIndexes(indexes, "strings", listener.getStringSet(), entry);
                Map<String, Collection> index = indexes.getIndex("subTypeNames");
                for (Map.Entry<String, HashSet<String>> e : listener.getSuperTypeNamesMap().entrySet()) {
                    String typeName = e.getKey();
                    for (String superTypeName : e.getValue()) {
                        index.get(superTypeName).add(typeName);
                    }
                }
            }
            catch (IOException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block16;
                throw new AssertionError();
            }
        }
    }

    static {
        ANTLRJavaParser.parse((CharStream)new ANTLRInputStream("class EarlyLoading{}"), new Listener(null));
    }

    protected static class Listener
    extends AbstractJavaListener {
        protected HashSet<String> typeDeclarationSet = new HashSet();
        protected HashSet<String> constructorDeclarationSet = new HashSet();
        protected HashSet<String> methodDeclarationSet = new HashSet();
        protected HashSet<String> fieldDeclarationSet = new HashSet();
        protected HashSet<String> typeReferenceSet = new HashSet();
        protected HashSet<String> constructorReferenceSet = new HashSet();
        protected HashSet<String> methodReferenceSet = new HashSet();
        protected HashSet<String> fieldReferenceSet = new HashSet();
        protected HashSet<String> stringSet = new HashSet();
        protected HashMap<String, HashSet<String>> superTypeNamesMap = new HashMap();
        protected StringBuilder sbTypeDeclaration = new StringBuilder();

        public Listener(Container.Entry entry) {
            super(entry);
        }

        public HashSet<String> getTypeDeclarationSet() {
            return this.typeDeclarationSet;
        }

        public HashSet<String> getConstructorDeclarationSet() {
            return this.constructorDeclarationSet;
        }

        public HashSet<String> getMethodDeclarationSet() {
            return this.methodDeclarationSet;
        }

        public HashSet<String> getFieldDeclarationSet() {
            return this.fieldDeclarationSet;
        }

        public HashSet<String> getTypeReferenceSet() {
            return this.typeReferenceSet;
        }

        public HashSet<String> getConstructorReferenceSet() {
            return this.constructorReferenceSet;
        }

        public HashSet<String> getMethodReferenceSet() {
            return this.methodReferenceSet;
        }

        public HashSet<String> getFieldReferenceSet() {
            return this.fieldReferenceSet;
        }

        public HashSet<String> getStringSet() {
            return this.stringSet;
        }

        public HashMap<String, HashSet<String>> getSuperTypeNamesMap() {
            return this.superTypeNamesMap;
        }

        @Override
        public void enterPackageDeclaration(JavaParser.PackageDeclarationContext ctx) {
            super.enterPackageDeclaration(ctx);
            if (!this.packageName.isEmpty()) {
                this.sbTypeDeclaration.append(this.packageName).append('/');
            }
        }

        @Override
        public void enterClassDeclaration(JavaParser.ClassDeclarationContext ctx) {
            this.enterTypeDeclaration(ctx);
        }

        @Override
        public void exitClassDeclaration(JavaParser.ClassDeclarationContext ctx) {
            this.exitTypeDeclaration();
        }

        @Override
        public void enterEnumDeclaration(JavaParser.EnumDeclarationContext ctx) {
            this.enterTypeDeclaration(ctx);
        }

        @Override
        public void exitEnumDeclaration(JavaParser.EnumDeclarationContext ctx) {
            this.exitTypeDeclaration();
        }

        @Override
        public void enterInterfaceDeclaration(JavaParser.InterfaceDeclarationContext ctx) {
            this.enterTypeDeclaration(ctx);
        }

        @Override
        public void exitInterfaceDeclaration(JavaParser.InterfaceDeclarationContext ctx) {
            this.exitTypeDeclaration();
        }

        @Override
        public void enterAnnotationTypeDeclaration(JavaParser.AnnotationTypeDeclarationContext ctx) {
            this.enterTypeDeclaration(ctx);
        }

        @Override
        public void exitAnnotationTypeDeclaration(JavaParser.AnnotationTypeDeclarationContext ctx) {
            this.exitTypeDeclaration();
        }

        protected void enterTypeDeclaration(ParserRuleContext ctx) {
            TerminalNode identifier = ctx.getToken(100, 0);
            if (identifier != null) {
                JavaParser.TypeListContext superInterfaces;
                String superQualifiedTypeName;
                String typeName = identifier.getText();
                int length = this.sbTypeDeclaration.length();
                if (length == 0 || this.sbTypeDeclaration.charAt(length - 1) == '/') {
                    this.sbTypeDeclaration.append(typeName);
                } else {
                    this.sbTypeDeclaration.append('$').append(typeName);
                }
                String internalTypeName = this.sbTypeDeclaration.toString();
                this.typeDeclarationSet.add(internalTypeName);
                this.nameToInternalTypeName.put(typeName, internalTypeName);
                HashSet<String> superInternalTypeNameSet = new HashSet<String>();
                JavaParser.TypeContext superType = (JavaParser.TypeContext)ctx.getRuleContext(JavaParser.TypeContext.class, 0);
                if (superType != null && (superQualifiedTypeName = this.resolveInternalTypeName(superType.classOrInterfaceType().Identifier())).charAt(0) != '*') {
                    superInternalTypeNameSet.add(superQualifiedTypeName);
                }
                if ((superInterfaces = (JavaParser.TypeListContext)ctx.getRuleContext(JavaParser.TypeListContext.class, 0)) != null) {
                    for (JavaParser.TypeContext superInterface : superInterfaces.type()) {
                        String superQualifiedInterfaceName = this.resolveInternalTypeName(superInterface.classOrInterfaceType().Identifier());
                        if (superQualifiedInterfaceName.charAt(0) == '*') continue;
                        superInternalTypeNameSet.add(superQualifiedInterfaceName);
                    }
                }
                if (!superInternalTypeNameSet.isEmpty()) {
                    this.superTypeNamesMap.put(internalTypeName, superInternalTypeNameSet);
                }
            }
        }

        protected void exitTypeDeclaration() {
            int index = this.sbTypeDeclaration.lastIndexOf("$");
            if (index == -1) {
                index = this.sbTypeDeclaration.lastIndexOf("/") + 1;
            }
            if (index == -1) {
                this.sbTypeDeclaration.setLength(0);
            } else {
                this.sbTypeDeclaration.setLength(index);
            }
        }

        @Override
        public void enterType(JavaParser.TypeContext ctx) {
            String internalTypeName;
            JavaParser.ClassOrInterfaceTypeContext classOrInterfaceType = ctx.classOrInterfaceType();
            if (classOrInterfaceType != null && (internalTypeName = this.resolveInternalTypeName(classOrInterfaceType.Identifier())).charAt(0) != '*') {
                this.typeReferenceSet.add(internalTypeName);
            }
        }

        @Override
        public void enterConstDeclaration(JavaParser.ConstDeclarationContext ctx) {
            for (JavaParser.ConstantDeclaratorContext constantDeclaratorContext : ctx.constantDeclarator()) {
                String name = constantDeclaratorContext.Identifier().getText();
                this.fieldDeclarationSet.add(name);
            }
        }

        @Override
        public void enterFieldDeclaration(JavaParser.FieldDeclarationContext ctx) {
            for (JavaParser.VariableDeclaratorContext declaration : ctx.variableDeclarators().variableDeclarator()) {
                TerminalNode identifier = declaration.variableDeclaratorId().Identifier();
                if (identifier == null) continue;
                String name = identifier.getText();
                this.fieldDeclarationSet.add(name);
            }
        }

        @Override
        public void enterMethodDeclaration(JavaParser.MethodDeclarationContext ctx) {
            TerminalNode identifier = ctx.Identifier();
            if (identifier != null) {
                String name = identifier.getText();
                this.methodDeclarationSet.add(name);
            }
        }

        @Override
        public void enterInterfaceMethodDeclaration(JavaParser.InterfaceMethodDeclarationContext ctx) {
            TerminalNode identifier = ctx.Identifier();
            if (identifier != null) {
                String name = identifier.getText();
                this.methodDeclarationSet.add(name);
            }
        }

        @Override
        public void enterConstructorDeclaration(JavaParser.ConstructorDeclarationContext ctx) {
            String name = ctx.Identifier().getText();
            this.constructorDeclarationSet.add(name);
        }

        @Override
        public void enterCreatedName(JavaParser.CreatedNameContext ctx) {
            String internalTypeName = this.resolveInternalTypeName(ctx.Identifier());
            if (internalTypeName != null && internalTypeName.charAt(0) != '*') {
                this.constructorReferenceSet.add(internalTypeName);
            }
        }

        @Override
        public void enterExpression(JavaParser.ExpressionContext ctx) {
            switch (ctx.getChildCount()) {
                case 3: {
                    TerminalNode identifier0;
                    if (this.getToken(ctx.children, 1, 65) != null) {
                        TerminalNode identifier3 = this.getToken(ctx.children, 2, 100);
                        if (identifier3 == null) break;
                        String fieldName = identifier3.getText();
                        this.fieldReferenceSet.add(fieldName);
                        break;
                    }
                    if (this.getToken(ctx.children, 1, 57) == null || this.getToken(ctx.children, 2, 58) == null || (identifier0 = this.getRightTerminalNode((ParseTree)ctx.children.get(0))) == null) break;
                    String methodName = identifier0.getText();
                    this.methodReferenceSet.add(methodName);
                    break;
                }
                case 4: {
                    TerminalNode identifier0;
                    JavaParser.ExpressionListContext expressionListContext;
                    if (this.getToken(ctx.children, 1, 57) == null || this.getToken(ctx.children, 3, 58) == null || (expressionListContext = ctx.expressionList()) == null || expressionListContext != ctx.children.get(2) || (identifier0 = this.getRightTerminalNode((ParseTree)ctx.children.get(0))) == null) break;
                    String methodName = identifier0.getText();
                    this.methodReferenceSet.add(methodName);
                }
            }
        }

        protected TerminalNode getToken(List<ParseTree> children, int i, int type) {
            ParseTree pt = children.get(i);
            if (pt instanceof TerminalNode && ((TerminalNode)pt).getSymbol().getType() == type) {
                return (TerminalNode)pt;
            }
            return null;
        }

        protected TerminalNode getRightTerminalNode(ParseTree pt) {
            int size;
            List children;
            if (pt instanceof ParserRuleContext && (children = ((ParserRuleContext)pt).children) != null && (size = children.size()) > 0) {
                ParseTree last = (ParseTree)children.get(size - 1);
                if (last instanceof TerminalNode) {
                    return (TerminalNode)last;
                }
                return this.getRightTerminalNode(last);
            }
            return null;
        }

        @Override
        public void enterLiteral(JavaParser.LiteralContext ctx) {
            TerminalNode stringLiteral = ctx.StringLiteral();
            if (stringLiteral != null) {
                this.stringSet.add(stringLiteral.getSymbol().getText());
            }
        }
    }
}

