import os
import subprocess
import sys


TEST_BACKEND_VERSION = os.getenv("TEST_BACKEND_VERSION", "python")


def run(args, env=None):
    return subprocess.run(
        args, universal_newlines=True, stdout=sys.stdout, stderr=sys.stderr,
        check=True, env=env
    )


def run_python(args, env=None):
    run([TEST_BACKEND_VERSION, "-u", "-W", "error", *args], env=env)
