/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.gdbtrace.core.trace;

import com.google.common.collect.ImmutableList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.gdbtrace.core.event.GdbTraceEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfContentFieldAspect;

public final class GdbEventAspects {
    @NonNull
    private static final Iterable<ITmfEventAspect> GDB_ASPECTS = (Iterable)NonNullUtils.checkNotNull((Object)ImmutableList.of((Object)new TmfContentFieldAspect("Trace Frame", new String[]{"Trace Frame"}), (Object)new TmfContentFieldAspect("Tracepoint", new String[]{"Tracepoint"}), (Object)new GdbFileAspect(), (Object)ITmfEventAspect.BaseAspects.CONTENTS));

    private GdbEventAspects() {
    }

    @NonNull
    public static Iterable<ITmfEventAspect> getAspects() {
        return GDB_ASPECTS;
    }

    private static class GdbFileAspect
    implements ITmfEventAspect {
        private GdbFileAspect() {
        }

        public String getName() {
            return "File";
        }

        public String getHelpText() {
            return "";
        }

        public String resolve(ITmfEvent event) {
            if (!(event instanceof GdbTraceEvent)) {
                return "";
            }
            String ret = ((GdbTraceEvent)event).getReference();
            return ret == null ? "" : ret;
        }
    }
}

