/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.wizards.datatransfer;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class ZipFileStructureProvider
implements IImportStructureProvider {
    private ZipFile zipFile;
    private ZipEntry root = new ZipEntry("/");
    private Map children;
    private Map directoryEntryCache = new HashMap();

    public ZipFileStructureProvider(ZipFile sourceFile) {
        this.zipFile = sourceFile;
    }

    protected void addToChildren(ZipEntry parent, ZipEntry child) {
        ArrayList<ZipEntry> childList = (ArrayList<ZipEntry>)this.children.get(parent);
        if (childList == null) {
            childList = new ArrayList<ZipEntry>();
            this.children.put(parent, childList);
        }
        childList.add(child);
    }

    protected void createContainer(IPath pathname) {
        if (this.directoryEntryCache.containsKey(pathname)) {
            return;
        }
        ZipEntry parent = pathname.segmentCount() == 1 ? this.root : (ZipEntry)this.directoryEntryCache.get(pathname.removeLastSegments(1));
        ZipEntry newEntry = new ZipEntry(pathname.toString());
        this.directoryEntryCache.put(pathname, newEntry);
        this.addToChildren(parent, newEntry);
    }

    protected void createFile(ZipEntry entry) {
        Path pathname = new Path(entry.getName());
        ZipEntry parent = pathname.segmentCount() == 1 ? this.root : (ZipEntry)this.directoryEntryCache.get(pathname.removeLastSegments(1));
        this.addToChildren(parent, entry);
    }

    @Override
    public List getChildren(Object element) {
        if (this.children == null) {
            this.initialize();
        }
        return (List)this.children.get(element);
    }

    @Override
    public InputStream getContents(Object element) {
        try {
            return this.zipFile.getInputStream((ZipEntry)element);
        }
        catch (IOException e) {
            IDEWorkbenchPlugin.log(e.getLocalizedMessage(), e);
            return null;
        }
    }

    @Override
    public String getFullPath(Object element) {
        return ((ZipEntry)element).getName();
    }

    @Override
    public String getLabel(Object element) {
        if (element.equals(this.root)) {
            return ((ZipEntry)element).getName();
        }
        return new Path(((ZipEntry)element).getName()).lastSegment();
    }

    public ZipEntry getRoot() {
        return this.root;
    }

    public ZipFile getZipFile() {
        return this.zipFile;
    }

    protected void initialize() {
        this.children = new HashMap(1000);
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            IPath path = new Path(entry.getName()).addTrailingSeparator();
            int pathSegmentCount = path.segmentCount();
            int i = 1;
            while (i < pathSegmentCount) {
                this.createContainer(path.uptoSegment(i));
                ++i;
            }
            this.createFile(entry);
        }
    }

    @Override
    public boolean isFolder(Object element) {
        return ((ZipEntry)element).isDirectory();
    }
}

