/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.FileSystemObjectImportStructureProvider;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.FileSystemObjectLeveledImportStructureProvider;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.GzipFile;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.GzipLeveledStructureProvider;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.IFileSystemObject;
import org.eclipse.tracecompass.tmf.core.util.Pair;
import org.eclipse.ui.internal.wizards.datatransfer.ArchiveFileManipulations;
import org.eclipse.ui.internal.wizards.datatransfer.ILeveledImportStructureProvider;
import org.eclipse.ui.internal.wizards.datatransfer.TarException;
import org.eclipse.ui.internal.wizards.datatransfer.TarFile;
import org.eclipse.ui.internal.wizards.datatransfer.TarLeveledStructureProvider;
import org.eclipse.ui.internal.wizards.datatransfer.ZipLeveledStructureProvider;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class ArchiveUtil {
    public static boolean isArchiveFile(File sourceFile) {
        String absolutePath = sourceFile.getAbsolutePath();
        return ArchiveUtil.isTarFile(absolutePath) || ArchiveFileManipulations.isZipFile((String)absolutePath) || ArchiveUtil.isGzipFile(absolutePath);
    }

    private static boolean isTarFile(String fileName) {
        TarFile specifiedTarSourceFile = ArchiveUtil.getSpecifiedTarSourceFile(fileName);
        if (specifiedTarSourceFile != null) {
            try {
                specifiedTarSourceFile.close();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean isGzipFile(String fileName) {
        if (!fileName.isEmpty()) {
            Throwable throwable = null;
            Object var2_4 = null;
            GzipFile specifiedTarSourceFile = new GzipFile(fileName);
            if (specifiedTarSourceFile != null) {
                specifiedTarSourceFile.close();
            }
            try {
                return true;
            }
            catch (Throwable throwable2) {
                try {
                    if (specifiedTarSourceFile != null) {
                        specifiedTarSourceFile.close();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    try {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        return false;
    }

    private static ZipFile getSpecifiedZipSourceFile(String fileName) {
        if (fileName.length() == 0) {
            return null;
        }
        try {
            return new ZipFile(fileName);
        }
        catch (ZipException zipException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static TarFile getSpecifiedTarSourceFile(String fileName) {
        if (fileName.length() == 0) {
            return null;
        }
        if (new File(fileName).length() < 512L) {
            return null;
        }
        try {
            return new TarFile(fileName);
        }
        catch (IOException | TarException throwable) {
            return null;
        }
    }

    static boolean ensureZipSourceIsValid(String archivePath, Shell shell) {
        ZipFile specifiedFile = ArchiveUtil.getSpecifiedZipSourceFile(archivePath);
        if (specifiedFile == null) {
            return false;
        }
        return ArchiveFileManipulations.closeZipFile((ZipFile)specifiedFile, (Shell)shell);
    }

    static boolean ensureTarSourceIsValid(String archivePath, Shell shell) {
        TarFile specifiedFile = ArchiveUtil.getSpecifiedTarSourceFile(archivePath);
        if (specifiedFile == null) {
            return false;
        }
        return ArchiveFileManipulations.closeTarFile((TarFile)specifiedFile, (Shell)shell);
    }

    static boolean ensureGzipSourceIsValid(String archivePath) {
        return ArchiveUtil.isGzipFile(archivePath);
    }

    public static Pair<IFileSystemObject, FileSystemObjectImportStructureProvider> getRootObjectAndProvider(File sourceFile, Shell shell) {
        if (sourceFile == null) {
            return null;
        }
        IFileSystemObject rootElement = null;
        FileSystemObjectImportStructureProvider importStructureProvider = null;
        if (!ArchiveUtil.isArchiveFile(sourceFile)) {
            importStructureProvider = new FileSystemObjectImportStructureProvider((IImportStructureProvider)FileSystemStructureProvider.INSTANCE, null);
            rootElement = importStructureProvider.getIFileSystemObject(sourceFile);
        } else {
            FileSystemObjectLeveledImportStructureProvider leveledImportStructureProvider = null;
            String archivePath = sourceFile.getAbsolutePath();
            if (ArchiveUtil.isTarFile(archivePath)) {
                if (ArchiveUtil.ensureTarSourceIsValid(archivePath, shell)) {
                    TarFile tarFile = ArchiveUtil.getSpecifiedTarSourceFile(archivePath);
                    leveledImportStructureProvider = new FileSystemObjectLeveledImportStructureProvider((ILeveledImportStructureProvider)new TarLeveledStructureProvider(tarFile), archivePath);
                }
            } else if (ArchiveUtil.ensureZipSourceIsValid(archivePath, shell)) {
                ZipFile zipFile = ArchiveUtil.getSpecifiedZipSourceFile(archivePath);
                leveledImportStructureProvider = new FileSystemObjectLeveledImportStructureProvider((ILeveledImportStructureProvider)new ZipLeveledStructureProvider(zipFile), archivePath);
            } else if (ArchiveUtil.ensureGzipSourceIsValid(archivePath)) {
                GzipFile zipFile = null;
                try {
                    zipFile = new GzipFile(archivePath);
                    leveledImportStructureProvider = new FileSystemObjectLeveledImportStructureProvider(new GzipLeveledStructureProvider(zipFile), archivePath);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (leveledImportStructureProvider == null) {
                return null;
            }
            rootElement = leveledImportStructureProvider.getRoot();
            importStructureProvider = leveledImportStructureProvider;
        }
        if (rootElement == null) {
            return null;
        }
        return new Pair((Object)rootElement, (Object)importStructureProvider);
    }
}

