/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ImportConfirmation;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.Messages;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;

public class ImportConflictHandler {
    private Shell fShell;
    private TmfTraceFolder fTraceFolderElement;
    private ImportConfirmation fConfirmationMode;

    public ImportConflictHandler(Shell shell, TmfTraceFolder folder, ImportConfirmation initialMode) {
        this.fShell = shell;
        this.fTraceFolderElement = folder;
        this.fConfirmationMode = initialMode;
    }

    public String checkAndHandleNameClash(IPath tracePath, IProgressMonitor monitor) throws InterruptedException, CoreException {
        ImportConfirmation mode = this.checkForNameClash(tracePath);
        switch (mode) {
            case RENAME: 
            case RENAME_ALL: {
                return this.rename(tracePath);
            }
            case OVERWRITE: 
            case OVERWRITE_ALL: {
                this.delete(tracePath, monitor);
            }
            case CONTINUE: {
                return tracePath.lastSegment();
            }
        }
        return null;
    }

    private ImportConfirmation checkForNameClash(IPath tracePath) throws InterruptedException {
        if (this.getExistingTrace(tracePath) != null) {
            if (this.fConfirmationMode == ImportConfirmation.RENAME_ALL || this.fConfirmationMode == ImportConfirmation.OVERWRITE_ALL || this.fConfirmationMode == ImportConfirmation.SKIP_ALL) {
                return this.fConfirmationMode;
            }
            int returnCode = this.promptForOverwrite(tracePath);
            if (returnCode < 0) {
                throw new InterruptedException();
            }
            this.fConfirmationMode = ImportConfirmation.values()[returnCode];
            return this.fConfirmationMode;
        }
        return ImportConfirmation.CONTINUE;
    }

    private int promptForOverwrite(IPath tracePath) {
        final MessageDialog dialog = new MessageDialog(this.fShell, null, null, NLS.bind((String)Messages.ImportTraceWizard_TraceAlreadyExists, (Object)tracePath.makeRelativeTo(this.fTraceFolderElement.getProject().getPath())), 3, new String[]{ImportConfirmation.RENAME.getInName(), ImportConfirmation.RENAME_ALL.getInName(), ImportConfirmation.OVERWRITE.getInName(), ImportConfirmation.OVERWRITE_ALL.getInName(), ImportConfirmation.SKIP.getInName(), ImportConfirmation.SKIP_ALL.getInName()}, 4){

            protected int getShellStyle() {
                return super.getShellStyle() | 0x10000000;
            }
        };
        final int[] returnValue = new int[1];
        this.fShell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                returnValue[0] = dialog.open();
            }
        });
        return returnValue[0];
    }

    private String rename(IPath tracePath) {
        String name;
        IResource resource;
        TmfTraceElement trace = this.getExistingTrace(tracePath);
        if (trace == null) {
            return tracePath.lastSegment();
        }
        IContainer folder = (IContainer)trace.getParent().getResource();
        int i = 2;
        while ((resource = folder.findMember(name = String.valueOf(trace.getName()) + '(' + Integer.toString(i++) + ')')) != null) {
        }
        return name;
    }

    private void delete(IPath tracePath, IProgressMonitor monitor) throws CoreException {
        TmfTraceElement trace = this.getExistingTrace(tracePath);
        if (trace == null) {
            return;
        }
        trace.delete(monitor);
    }

    private TmfTraceElement getExistingTrace(IPath tracePath) {
        List<TmfTraceElement> traces = this.fTraceFolderElement.getTraces();
        for (TmfTraceElement t : traces) {
            if (!t.getPath().equals((Object)tracePath)) continue;
            return t;
        }
        return null;
    }
}

