/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.mediawiki.core;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.mylyn.wikitext.core.parser.markup.IdGenerationStrategy;

public class MediaWikiIdGenerationStrategy
extends IdGenerationStrategy {
    private final Map<String, Integer> anchorReferenceCount = new HashMap<String, Integer>();

    public String generateId(String headingText) {
        String anchor = MediaWikiIdGenerationStrategy.headingTextToId(headingText);
        Integer previousRefCount = this.anchorReferenceCount.put(anchor, 1);
        if (previousRefCount != null) {
            int refCount = previousRefCount + 1;
            this.anchorReferenceCount.put(anchor, refCount);
            anchor = String.valueOf(anchor) + '_' + refCount;
        }
        return anchor;
    }

    static String headingTextToId(String headingText) {
        String escaped = headingText.replaceAll("\\s", "_");
        try {
            escaped = URLEncoder.encode(escaped, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        return escaped.replace("%3A", ":").replace('%', '.');
    }
}

