/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.analysis;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModuleHelper;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModuleSource;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAnalysisModuleHelperConfigElement;

public final class TmfAnalysisModuleSourceConfigElement
implements IAnalysisModuleSource {
    public static final String TMF_ANALYSIS_TYPE_ID = "org.eclipse.linuxtools.tmf.core.analysis";
    public static final String MODULE_ELEM = "module";
    public static final String PARAMETER_ELEM = "parameter";
    public static final String ID_ATTR = "id";
    public static final String NAME_ATTR = "name";
    public static final String ANALYSIS_MODULE_ATTR = "analysis_module";
    public static final String AUTOMATIC_ATTR = "automatic";
    public static final String APPLIES_EXP_ATTR = "applies_experiment";
    public static final String ICON_ATTR = "icon";
    public static final String DEFAULT_VALUE_ATTR = "default_value";
    public static final String TRACETYPE_ELEM = "tracetype";
    public static final String CLASS_ATTR = "class";
    public static final String APPLIES_ATTR = "applies";
    private final List<IAnalysisModuleHelper> fAnalysisHelpers = new ArrayList<IAnalysisModuleHelper>();

    public static IConfigurationElement[] getTypeElements() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(TMF_ANALYSIS_TYPE_ID);
        LinkedList<IConfigurationElement> typeElements = new LinkedList<IConfigurationElement>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals(MODULE_ELEM)) {
                typeElements.add(element);
            }
            ++n2;
        }
        return (IConfigurationElement[])NonNullUtils.checkNotNull((Object)typeElements.toArray(new IConfigurationElement[typeElements.size()]));
    }

    public TmfAnalysisModuleSourceConfigElement() {
        this.populateAnalysisList();
    }

    @Override
    public Iterable<IAnalysisModuleHelper> getAnalysisModules() {
        return this.fAnalysisHelpers;
    }

    private void populateAnalysisList() {
        if (this.fAnalysisHelpers.isEmpty()) {
            IConfigurationElement[] config;
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(TMF_ANALYSIS_TYPE_ID);
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ce = iConfigurationElementArray[n2];
                String elementName = ce.getName();
                if (elementName.equals(MODULE_ELEM)) {
                    this.fAnalysisHelpers.add(new TmfAnalysisModuleHelperConfigElement(ce));
                }
                ++n2;
            }
        }
    }
}

