/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.sourcelookup;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.core.sourcelookup.MappingSourceContainer;
import org.eclipse.cdt.debug.internal.core.sourcelookup.MapEntrySourceContainer;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.SWTUtil;
import org.eclipse.cdt.debug.internal.ui.sourcelookup.SourceLookupUIMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class MappingSourceContainerDialog
extends TitleAreaDialog {
    private static final String CP_COMPILATION_PATH = "compilationPath";
    private static final String CP_FILE_SYSTEM_PATH = "fileSystemPath";
    private MappingSourceContainer fOriginalContainer;
    private MappingSourceContainer fContainer;
    private Text fNameText;
    private TableViewer fViewer;
    private Button fAddButton;
    private Button fRemoveButton;
    private Button fUpButton;
    private Button fDownButton;
    private ControlListener fTableListener;
    private boolean fIsValid = true;

    public MappingSourceContainerDialog(Shell shell, MappingSourceContainer container) {
        super(shell);
        this.fOriginalContainer = container;
        this.fContainer = container.copy();
        this.fTableListener = new ControlListener(){

            public void controlMoved(ControlEvent e) {
                MappingSourceContainerDialog.this.controlMoved(e);
            }

            public void controlResized(ControlEvent e) {
                MappingSourceContainerDialog.this.controlResized(e);
            }
        };
    }

    public boolean close() {
        this.fViewer.getTable().removeControlListener(this.fTableListener);
        this.fContainer.dispose();
        return super.close();
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(SourceLookupUIMessages.PathMappingDialog_16);
        newShell.setToolTipText(SourceLookupUIMessages.MappingSourceContainerDialog_0);
        newShell.setImage(CDebugImages.get("org.eclipse.cdt.debug.ui.mapping_obj.gif"));
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.initialize();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite control = (Composite)super.createDialogArea(parent);
        this.setTitle(SourceLookupUIMessages.PathMappingDialog_0);
        this.setTitleImage(CDebugImages.get("org.eclipse.cdt.debug.ui.mapping_wiz.gif"));
        Composite composite = new Composite(control, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createNameArea(composite);
        this.createViewer(composite);
        this.createViewerButtonBar(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), ICDebugHelpContextIds.SOURCE_PATH_MAP_ENTRY_DIALOG);
        return control;
    }

    protected void okPressed() {
        this.fOriginalContainer.clear();
        this.fOriginalContainer.setName(this.fNameText.getText().trim());
        try {
            this.fOriginalContainer.addMapEntries((MapEntrySourceContainer[])this.fContainer.getSourceContainers());
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        super.okPressed();
    }

    public void setErrorMessage(String newErrorMessage) {
        this.fIsValid = newErrorMessage == null;
        super.setErrorMessage(newErrorMessage);
    }

    public MappingSourceContainer getContainer() {
        return this.fOriginalContainer;
    }

    private void createNameArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        Label label = new Label(composite, 0);
        label.setText(SourceLookupUIMessages.PathMappingDialog_12);
        this.fNameText = new Text(composite, 2052);
        GridData data = new GridData(4, 0x1000000, false, false);
        data.widthHint = 200;
        this.fNameText.setLayoutData((Object)data);
        this.fNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
    }

    private void createViewer(Composite parent) {
        Composite tableComp = new Composite(parent, 0);
        tableComp.setLayout((Layout)new GridLayout());
        tableComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fViewer = new TableViewer(tableComp, 67586);
        Table table = this.fViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 500;
        data.heightHint = 200;
        table.setLayoutData((Object)data);
        table.addControlListener(this.fTableListener);
        TableColumn nameColumn = new TableColumn(table, 0);
        nameColumn.setResizable(true);
        nameColumn.setText(SourceLookupUIMessages.PathMappingDialog_1);
        nameColumn.setToolTipText(SourceLookupUIMessages.MappingSourceContainerDialog_1);
        TableColumn valueColumn = new TableColumn(table, 0);
        valueColumn.setResizable(true);
        valueColumn.setText(SourceLookupUIMessages.PathMappingDialog_2);
        valueColumn.setToolTipText(SourceLookupUIMessages.MappingSourceContainerDialog_2);
        this.fViewer.setColumnProperties(new String[]{CP_COMPILATION_PATH, CP_FILE_SYSTEM_PATH});
        this.fViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof MappingSourceContainer) {
                    try {
                        return ((MappingSourceContainer)inputElement).getSourceContainers();
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.fViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)table), new DirectoryCellEditor((Composite)table)});
        this.fViewer.setCellModifier((ICellModifier)new EntryCellModifier());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new EntryLabelProvider());
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MappingSourceContainerDialog.this.updateViewerButtons();
            }
        });
    }

    private void createViewerButtonBar(Composite parent) {
        Composite buttonComp = new Composite(parent, 0);
        buttonComp.setLayout((Layout)new GridLayout());
        buttonComp.setLayoutData((Object)new GridData(131072, 4, false, false));
        this.fAddButton = this.createPushButton(buttonComp, SourceLookupUIMessages.MappingSourceContainerDialog_3);
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MappingSourceContainerDialog.this.addPathEntry();
            }
        });
        this.fRemoveButton = this.createPushButton(buttonComp, SourceLookupUIMessages.PathMappingDialog_15);
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MappingSourceContainerDialog.this.removePathEntries();
            }
        });
        this.fUpButton = this.createPushButton(buttonComp, SourceLookupUIMessages.MappingSourceContainerDialog_4);
        this.fUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MappingSourceContainerDialog.this.move(true);
            }
        });
        this.fDownButton = this.createPushButton(buttonComp, SourceLookupUIMessages.MappingSourceContainerDialog_5);
        this.fDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MappingSourceContainerDialog.this.move(false);
            }
        });
    }

    private void initialize() {
        this.fNameText.setText(this.fContainer.getName());
        this.fNameText.selectAll();
        this.fViewer.setInput((Object)this.fContainer);
        this.updateViewerButtons();
    }

    private Button createPushButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setText(label);
        GridData gd = new GridData(4, 1, true, false);
        gd.widthHint = SWTUtil.getButtonWidthHint(button);
        button.setLayoutData((Object)gd);
        return button;
    }

    private MapEntrySourceContainer[] getSelectedEntries() {
        List list = ((IStructuredSelection)this.fViewer.getSelection()).toList();
        return list.toArray(new MapEntrySourceContainer[list.size()]);
    }

    private void updateErrorMessage() {
        this.setErrorMessage(null);
        try {
            ISourceContainer[] containers = this.fContainer.getSourceContainers();
            if (containers.length == 0) {
                return;
            }
            ISourceContainer[] iSourceContainerArray = containers;
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                ISourceContainer c = iSourceContainerArray[n2];
                MapEntrySourceContainer entry = (MapEntrySourceContainer)c;
                IPath backendPath = entry.getBackendPath();
                if (backendPath.isEmpty()) {
                    this.setErrorMessage(SourceLookupUIMessages.PathMappingDialog_5);
                    break;
                }
                if (!backendPath.isValidPath(backendPath.toString())) {
                    this.setErrorMessage(SourceLookupUIMessages.PathMappingDialog_6);
                    break;
                }
                IPath localPath = entry.getLocalPath();
                if (localPath.isEmpty()) {
                    this.setErrorMessage(SourceLookupUIMessages.PathMappingDialog_7);
                    break;
                }
                if (!localPath.toFile().exists()) {
                    this.setErrorMessage(SourceLookupUIMessages.PathMappingDialog_8);
                    break;
                }
                if (!localPath.toFile().isDirectory()) {
                    this.setErrorMessage(SourceLookupUIMessages.PathMappingDialog_9);
                    break;
                }
                if (!localPath.toFile().isAbsolute()) {
                    this.setErrorMessage(SourceLookupUIMessages.PathMappingDialog_10);
                    break;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private void updateViewerButtons() {
        boolean ok = true;
        boolean remove = true;
        boolean up = true;
        boolean down = true;
        try {
            ISourceContainer[] allEntries = this.fContainer.getSourceContainers();
            MapEntrySourceContainer[] entries = this.getSelectedEntries();
            if (entries.length == 0) {
                remove = false;
            }
            if (entries.length != 1) {
                up = false;
                down = false;
            } else {
                up = !entries[0].equals((Object)allEntries[0]);
                down = !entries[0].equals((Object)allEntries[allEntries.length - 1]);
            }
            ok = allEntries.length != 0 && this.fIsValid;
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.getButton(0).setEnabled(ok);
        this.fRemoveButton.setEnabled(remove);
        this.fUpButton.setEnabled(up);
        this.fDownButton.setEnabled(down);
    }

    private void refresh() {
        ISelection s = this.fViewer.getSelection();
        this.fViewer.refresh();
        this.fViewer.setSelection(s);
        this.updateErrorMessage();
        this.updateViewerButtons();
    }

    void controlMoved(ControlEvent e) {
    }

    void controlResized(ControlEvent e) {
        Table table = this.fViewer.getTable();
        int width = table.getSize().x;
        if (width > 0) {
            TableColumn[] columns = table.getColumns();
            int colWidth = width / columns.length;
            TableColumn[] tableColumnArray = columns;
            int n = columns.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn col = tableColumnArray[n2];
                if (col.getWidth() == 0) {
                    col.setWidth(colWidth);
                }
                ++n2;
            }
        }
    }

    void addPathEntry() {
        MapEntrySourceContainer entry = new MapEntrySourceContainer();
        this.fContainer.addMapEntry(entry);
        this.fViewer.refresh();
        this.fViewer.setSelection((ISelection)new StructuredSelection((Object)entry), true);
        this.updateViewerButtons();
        this.fViewer.editElement((Object)entry, 0);
    }

    void removePathEntries() {
        MapEntrySourceContainer[] entries = this.getSelectedEntries();
        this.fContainer.removeMapEntries(entries);
        this.refresh();
    }

    void move(boolean up) {
        MapEntrySourceContainer[] selEntries = this.getSelectedEntries();
        if (selEntries.length != 1) {
            return;
        }
        MapEntrySourceContainer entry = selEntries[0];
        try {
            ISourceContainer[] containers = this.fContainer.getSourceContainers();
            ArrayList<MapEntrySourceContainer> list = new ArrayList<MapEntrySourceContainer>(containers.length);
            ISourceContainer[] iSourceContainerArray = containers;
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                ISourceContainer container = iSourceContainerArray[n2];
                list.add(((MapEntrySourceContainer)container).copy());
                ++n2;
            }
            int index = list.indexOf(entry);
            list.remove(index);
            index = up ? index - 1 : index + 1;
            list.add(index, entry);
            this.fContainer.clear();
            this.fContainer.addMapEntries(list.toArray(new MapEntrySourceContainer[list.size()]));
            this.refresh();
        }
        catch (CoreException coreException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    class DirectoryCellEditor
    extends DialogCellEditor {
        DirectoryCellEditor(Composite parent) {
            super(parent);
        }

        protected Object openDialogBox(Control cellEditorWindow) {
            TableItem[] selection = ((Table)cellEditorWindow.getParent()).getSelection();
            DirectoryDialog dialog = new DirectoryDialog(cellEditorWindow.getShell());
            dialog.setFilterPath(selection[0].getText(1));
            return dialog.open();
        }
    }

    class EntryCellModifier
    implements ICellModifier {
        EntryCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return MappingSourceContainerDialog.CP_COMPILATION_PATH.equals(property) || MappingSourceContainerDialog.CP_FILE_SYSTEM_PATH.equals(property);
        }

        public Object getValue(Object element, String property) {
            if (element instanceof MapEntrySourceContainer) {
                MapEntrySourceContainer entry = (MapEntrySourceContainer)element;
                if (MappingSourceContainerDialog.CP_COMPILATION_PATH.equals(property)) {
                    return entry.getBackendPath().toOSString();
                }
                if (MappingSourceContainerDialog.CP_FILE_SYSTEM_PATH.equals(property)) {
                    return entry.getLocalPath().toOSString();
                }
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            MapEntrySourceContainer entry = element instanceof Item ? (MapEntrySourceContainer)((Item)element).getData() : (MapEntrySourceContainer)element;
            boolean isDirty = false;
            if (MappingSourceContainerDialog.CP_COMPILATION_PATH.equals(property)) {
                entry.setBackendPath((IPath)new Path((String)value));
                isDirty = true;
            } else if (MappingSourceContainerDialog.CP_FILE_SYSTEM_PATH.equals(property)) {
                entry.setLocalPath((IPath)new Path((String)value));
                isDirty = true;
            }
            if (isDirty) {
                MappingSourceContainerDialog.this.refresh();
            }
        }
    }

    class EntryLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        EntryLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof MapEntrySourceContainer && columnIndex == 0) {
                return CDebugImages.get("org.eclipse.cdt.debug.ui.mapentry_obj.gif");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof MapEntrySourceContainer) {
                MapEntrySourceContainer entry = (MapEntrySourceContainer)element;
                if (columnIndex == 0) {
                    return entry.getBackendPath().toOSString();
                }
                if (columnIndex == 1) {
                    return entry.getLocalPath().toOSString();
                }
            }
            return null;
        }
    }
}

