/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.folderwizard;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.ISourceEntry;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.internal.core.model.InternalCoreModelUtil;
import org.eclipse.cdt.internal.core.model.PathEntryManager;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.dialogs.TypedElementSelectionValidator;
import org.eclipse.cdt.internal.ui.dialogs.TypedViewerFilter;
import org.eclipse.cdt.internal.ui.util.CoreUtility;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.internal.ui.wizards.NewElementWizardPage;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.cdt.internal.ui.wizards.folderwizard.NewFolderWizardMessages;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class NewSourceFolderWizardPage
extends NewElementWizardPage {
    private static final String PAGE_NAME = "NewSourceFolderWizardPage";
    private StringButtonDialogField fProjectField;
    private StatusInfo fProjectStatus;
    private StringButtonDialogField fRootDialogField;
    private StatusInfo fRootStatus;
    private SelectionButtonDialogField fExcludeInOthersFields;
    private IWorkspaceRoot fWorkspaceRoot;
    private ICProject fCurrCProject;
    private IPathEntry[] fEntries;
    private IPathEntry[] fNewEntries;
    private boolean fIsProjectAsSourceFolder;
    private ISourceRoot fCreatedRoot;

    public NewSourceFolderWizardPage() {
        super(PAGE_NAME);
        this.setTitle(NewFolderWizardMessages.NewSourceFolderWizardPage_title);
        this.setDescription(NewFolderWizardMessages.NewSourceFolderWizardPage_description);
        this.fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        RootFieldAdapter adapter = new RootFieldAdapter();
        this.fProjectField = new StringButtonDialogField(adapter);
        this.fProjectField.setDialogFieldListener(adapter);
        this.fProjectField.setLabelText(NewFolderWizardMessages.NewSourceFolderWizardPage_project_label);
        this.fProjectField.setButtonLabel(NewFolderWizardMessages.NewSourceFolderWizardPage_project_button);
        this.fRootDialogField = new StringButtonDialogField(adapter);
        this.fRootDialogField.setDialogFieldListener(adapter);
        this.fRootDialogField.setLabelText(NewFolderWizardMessages.NewSourceFolderWizardPage_root_label);
        this.fRootDialogField.setButtonLabel(NewFolderWizardMessages.NewSourceFolderWizardPage_root_button);
        this.fExcludeInOthersFields = new SelectionButtonDialogField(32);
        this.fExcludeInOthersFields.setDialogFieldListener(adapter);
        this.fExcludeInOthersFields.setLabelText(NewFolderWizardMessages.NewSourceFolderWizardPage_exclude_label);
        this.fRootStatus = new StatusInfo();
        this.fProjectStatus = new StatusInfo();
    }

    public void init(IStructuredSelection selection) {
        ICProject jproject;
        if (selection == null || selection.isEmpty()) {
            this.setDefaultAttributes();
            return;
        }
        Object selectedElement = selection.getFirstElement();
        if (selectedElement == null) {
            selectedElement = EditorUtility.getActiveEditorCInput();
        }
        String projPath = null;
        if (selectedElement instanceof IResource) {
            IProject proj = ((IResource)selectedElement).getProject();
            if (proj != null) {
                projPath = proj.getFullPath().makeRelative().toString();
            }
        } else if (selectedElement instanceof ICElement && (jproject = ((ICElement)selectedElement).getCProject()) != null) {
            projPath = jproject.getProject().getFullPath().makeRelative().toString();
        }
        if (projPath != null) {
            this.fProjectField.setText(projPath);
            this.fRootDialogField.setText("");
        } else {
            this.setDefaultAttributes();
        }
    }

    private void setDefaultAttributes() {
        String projPath = "";
        try {
            IProject[] projects;
            IProject[] iProjectArray = projects = this.fWorkspaceRoot.getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject proj = iProjectArray[n2];
                if (proj.hasNature("org.eclipse.cdt.core.cnature") || proj.hasNature("org.eclipse.cdt.core.ccnature")) {
                    projPath = proj.getFullPath().makeRelative().toString();
                    break;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.fProjectField.setText(projPath);
        this.fRootDialogField.setText("");
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        this.fProjectField.doFillIntoGrid(composite, 3);
        this.fRootDialogField.doFillIntoGrid(composite, 3);
        this.fExcludeInOthersFields.doFillIntoGrid(composite, 3);
        int maxFieldWidth = this.convertWidthInCharsToPixels(40);
        LayoutUtil.setWidthHint((Control)this.fProjectField.getTextControl(null), maxFieldWidth);
        LayoutUtil.setHorizontalGrabbing((Control)this.fProjectField.getTextControl(null), true);
        LayoutUtil.setWidthHint((Control)this.fRootDialogField.getTextControl(null), maxFieldWidth);
        this.fExcludeInOthersFields.setSelection(true);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.cdt.ui.new_srcfldr_wizard_page_context");
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fRootDialogField.setFocus();
        }
    }

    protected void packRootChangeControlPressed(DialogField field) {
        ICProject jproject;
        if (field == this.fRootDialogField) {
            String title = NewFolderWizardMessages.NewSourceFolderWizardPage_ChooseExistingRootDialog_title;
            String message = NewFolderWizardMessages.NewSourceFolderWizardPage_ChooseExistingRootDialog_description;
            Path initialPath = new Path(this.fRootDialogField.getText());
            IFolder folder = this.chooseFolder(title, message, (IPath)initialPath);
            if (folder != null) {
                IPath path = folder.getFullPath().removeFirstSegments(1);
                this.fRootDialogField.setText(path.toString());
            }
        } else if (field == this.fProjectField && (jproject = this.chooseProject()) != null) {
            IPath path = jproject.getProject().getFullPath().makeRelative();
            this.fProjectField.setText(path.toString());
        }
    }

    protected void packRootDialogFieldChanged(DialogField field) {
        if (field == this.fRootDialogField) {
            this.updateRootStatus();
        } else if (field == this.fProjectField) {
            this.updateProjectStatus();
            this.updateRootStatus();
        } else if (field == this.fExcludeInOthersFields) {
            this.updateRootStatus();
        }
        this.updateStatus(new IStatus[]{this.fProjectStatus, this.fRootStatus});
    }

    private void updateProjectStatus() {
        this.fCurrCProject = null;
        this.fIsProjectAsSourceFolder = false;
        String str = this.fProjectField.getText();
        if (str.length() == 0) {
            this.fProjectStatus.setError(NewFolderWizardMessages.NewSourceFolderWizardPage_error_EnterProjectName);
            return;
        }
        Path path = new Path(str);
        if (path.segmentCount() != 1) {
            this.fProjectStatus.setError(NewFolderWizardMessages.NewSourceFolderWizardPage_error_InvalidProjectPath);
            return;
        }
        IProject project = this.fWorkspaceRoot.getProject(path.toString());
        if (!project.exists()) {
            this.fProjectStatus.setError(NewFolderWizardMessages.NewSourceFolderWizardPage_error_ProjectNotExists);
            return;
        }
        try {
            if (project.hasNature("org.eclipse.cdt.core.cnature") || project.hasNature("org.eclipse.cdt.core.ccnature")) {
                this.fCurrCProject = CoreModel.getDefault().create(project);
                this.fEntries = this.fCurrCProject.getRawPathEntries();
                this.fProjectStatus.setOK();
                return;
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
            this.fCurrCProject = null;
        }
        this.fProjectStatus.setError(NewFolderWizardMessages.NewSourceFolderWizardPage_error_NotACProject);
    }

    private void updateRootStatus() {
        this.fRootDialogField.enableButton(this.fCurrCProject != null);
        this.fIsProjectAsSourceFolder = false;
        if (this.fCurrCProject == null) {
            return;
        }
        this.fRootStatus.setOK();
        IPath projPath = this.fCurrCProject.getProject().getFullPath();
        String str = this.fRootDialogField.getText();
        if (str.length() == 0) {
            this.fRootStatus.setError(NLS.bind((String)NewFolderWizardMessages.NewSourceFolderWizardPage_error_EnterRootName, (Object)this.fCurrCProject.getProject().getFullPath().toString()));
        } else {
            IPath path = projPath.append(str);
            IStatus validate = this.fWorkspaceRoot.getWorkspace().validatePath(path.toString(), 2);
            if (validate.matches(4)) {
                this.fRootStatus.setError(NLS.bind((String)NewFolderWizardMessages.NewSourceFolderWizardPage_error_InvalidRootName, (Object)validate.getMessage()));
            } else {
                IResource res = this.fWorkspaceRoot.findMember(path);
                if (res != null && res.getType() != 2) {
                    this.fRootStatus.setError(NewFolderWizardMessages.NewSourceFolderWizardPage_error_NotAFolder);
                    return;
                }
                ArrayList<Object> newEntries = new ArrayList<Object>(this.fEntries.length + 1);
                int projectEntryIndex = -1;
                int i = 0;
                while (i < this.fEntries.length) {
                    IPathEntry curr = this.fEntries[i];
                    if (curr.getEntryKind() == 8) {
                        if (path.equals((Object)curr.getPath())) {
                            this.fRootStatus.setError(NewFolderWizardMessages.NewSourceFolderWizardPage_error_AlreadyExisting);
                            return;
                        }
                        if (projPath.equals((Object)curr.getPath())) {
                            projectEntryIndex = i;
                        }
                    }
                    newEntries.add(curr);
                    ++i;
                }
                ISourceEntry newEntry = CoreModel.newSourceEntry((IPath)path);
                HashSet modified = new HashSet();
                if (this.fExcludeInOthersFields.isSelected()) {
                    InternalCoreModelUtil.addExclusionPatterns((IPathEntry)newEntry, newEntries, modified);
                    newEntries.add(CoreModel.newSourceEntry((IPath)path));
                } else if (projectEntryIndex >= 0) {
                    this.fIsProjectAsSourceFolder = true;
                    newEntries.set(projectEntryIndex, newEntry);
                } else {
                    newEntries.add(CoreModel.newSourceEntry((IPath)path));
                }
                this.fNewEntries = newEntries.toArray(new IPathEntry[newEntries.size()]);
                ICModelStatus status = PathEntryManager.getDefault().validatePathEntry(this.fCurrCProject, this.fNewEntries);
                if (!status.isOK()) {
                    ICModelStatus status2 = PathEntryManager.getDefault().validatePathEntry(this.fCurrCProject, this.fNewEntries);
                    if (status2.isOK()) {
                        return;
                    }
                    this.fRootStatus.setError(status.getMessage());
                    return;
                }
                if (this.fIsProjectAsSourceFolder) {
                    this.fRootStatus.setInfo(NewFolderWizardMessages.NewSourceFolderWizardPage_warning_ReplaceSF);
                    return;
                }
                if (!modified.isEmpty()) {
                    this.fRootStatus.setInfo(NLS.bind((String)NewFolderWizardMessages.NewSourceFolderWizardPage_warning_AddedExclusions, (Object)String.valueOf(modified.size())));
                    return;
                }
            }
        }
    }

    public ISourceRoot getNewSourceRoot() {
        return this.fCreatedRoot;
    }

    public IResource getCorrespondingResource() {
        return this.fCurrCProject.getProject().getFolder(this.fRootDialogField.getText());
    }

    public void createSourceRoot(IProgressMonitor monitor) throws CoreException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NewFolderWizardMessages.NewSourceFolderWizardPage_operation, 3);
        try {
            String relPath = this.fRootDialogField.getText();
            IProject project = this.fCurrCProject.getProject();
            IFolder folder = project.getFolder(relPath);
            if (!folder.exists()) {
                CoreUtility.createFolder(folder, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            if (CCorePlugin.getDefault().isNewStyleProject(project)) {
                InternalCoreModelUtil.addSourceEntry((IProject)project, (IFolder)folder, (boolean)this.fIsProjectAsSourceFolder, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            } else {
                this.fCurrCProject.setRawPathEntries(this.fNewEntries, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            }
            this.fCreatedRoot = this.fCurrCProject.findSourceRoot((IResource)folder);
        }
        finally {
            monitor.done();
        }
    }

    private IFolder chooseFolder(String title, String message, IPath initialPath) {
        Class[] acceptedClasses = new Class[]{IFolder.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false);
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, null);
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        IProject currProject = this.fCurrCProject.getProject();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)currProject);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        IResource res = currProject.findMember(initialPath);
        if (res != null) {
            dialog.setInitialSelection((Object)res);
        }
        if (dialog.open() == 0) {
            return (IFolder)dialog.getFirstResult();
        }
        return null;
    }

    private ICProject chooseProject() {
        Object[] projects;
        try {
            projects = CoreModel.create((IWorkspaceRoot)this.fWorkspaceRoot).getCProjects();
        }
        catch (CModelException e) {
            CUIPlugin.log(e);
            projects = new ICProject[]{};
        }
        CElementLabelProvider labelProvider = new CElementLabelProvider(CElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(NewFolderWizardMessages.NewSourceFolderWizardPage_ChooseProjectDialog_title);
        dialog.setMessage(NewFolderWizardMessages.NewSourceFolderWizardPage_ChooseProjectDialog_description);
        dialog.setElements(projects);
        dialog.setInitialSelections(new Object[]{this.fCurrCProject});
        if (dialog.open() == 0) {
            return (ICProject)dialog.getFirstResult();
        }
        return null;
    }

    private class RootFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private RootFieldAdapter() {
        }

        @Override
        public void changeControlPressed(DialogField field) {
            NewSourceFolderWizardPage.this.packRootChangeControlPressed(field);
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            NewSourceFolderWizardPage.this.packRootDialogFieldChanged(field);
        }
    }
}

