/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileFoldingStructureProvider;
import org.eclipse.linuxtools.internal.rpm.ui.editor.outline.SpecfileContentOutlinePage;
import org.eclipse.linuxtools.rpm.ui.editor.SpecfileEditor;
import org.eclipse.linuxtools.rpm.ui.editor.parser.Specfile;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class SpecfileReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private SpecfileFoldingStructureProvider sFoldingStructureProvider;
    SpecfileContentOutlinePage outline;
    SpecfileEditor editor;
    IDocumentProvider documentProvider;

    public SpecfileReconcilingStrategy(SpecfileEditor editor) {
        this.outline = (SpecfileContentOutlinePage)((Object)editor.getAdapter(IContentOutlinePage.class));
        this.editor = editor;
        this.documentProvider = editor.getDocumentProvider();
        this.sFoldingStructureProvider = new SpecfileFoldingStructureProvider(editor);
    }

    public void setDocument(IDocument document) {
        this.sFoldingStructureProvider.setDocument(document);
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.sFoldingStructureProvider.setProgressMonitor(monitor);
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile();
    }

    public void initialReconcile() {
        this.reconcile();
    }

    private void reconcile() {
        Specfile specfile = this.editor.getSpecfile();
        if (specfile != null) {
            this.editor.setSpecfile(this.editor.getParser().parse(this.documentProvider.getDocument((Object)this.editor.getEditorInput())));
            this.outline.update();
            this.updateFolding();
            this.updateEditor();
        }
    }

    public void reconcile(IRegion partition) {
        this.reconcile();
    }

    private void updateEditor() {
        Shell shell = this.editor.getSite().getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SpecfileReconcilingStrategy.this.editor.setSpecfile(SpecfileReconcilingStrategy.this.editor.getParser().parse(SpecfileReconcilingStrategy.this.documentProvider.getDocument((Object)SpecfileReconcilingStrategy.this.editor.getEditorInput())));
                }
            });
        }
    }

    private void updateFolding() {
        this.sFoldingStructureProvider.updateFoldingRegions();
    }
}

