/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor.hyperlink;

import com.ibm.icu.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.linuxtools.internal.rpm.ui.editor.hyperlink.SpecfileElementHyperlink;
import org.eclipse.linuxtools.internal.rpm.ui.editor.parser.SpecfileSource;
import org.eclipse.linuxtools.rpm.ui.editor.SpecfileEditor;
import org.eclipse.linuxtools.rpm.ui.editor.parser.Specfile;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileDefine;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileElement;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileParser;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class SpecfileElementHyperlinkDetector
extends AbstractHyperlinkDetector {
    private static final String PATCH_IDENTIFIER = "%patch";
    private static final String SOURCE_IDENTIFIER = "%{SOURCE";
    private Specfile specfile;

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        SpecfileSource source;
        String line;
        IRegion lineInfo;
        if (region == null || textViewer == null) {
            return null;
        }
        IDocument document = textViewer.getDocument();
        if (document == null) {
            return null;
        }
        if (this.specfile == null) {
            SpecfileEditor a = (SpecfileEditor)((Object)this.getAdapter(SpecfileEditor.class));
            if (a != null && a.getSpecfile() != null) {
                this.specfile = a.getSpecfile();
            } else {
                SpecfileParser parser = new SpecfileParser();
                this.specfile = parser.parse(document);
            }
        }
        int offset = region.getOffset();
        try {
            lineInfo = document.getLineInformationOfOffset(offset);
            line = document.get(lineInfo.getOffset(), lineInfo.getLength());
        }
        catch (BadLocationException ex) {
            return null;
        }
        int offsetInLine = offset - lineInfo.getOffset();
        StringTokenizer tokens = new StringTokenizer(line);
        String word = "";
        int tempLineOffset = 0;
        int wordOffsetInLine = 0;
        while (tokens.hasMoreTokens()) {
            String tempWord = tokens.nextToken();
            Pattern defineRegexp = Pattern.compile("%\\{(.*?)\\}");
            Matcher fit = defineRegexp.matcher(tempWord);
            while (fit.find()) {
                if (fit.start() + tempLineOffset > offsetInLine || offsetInLine > fit.end() + tempLineOffset) continue;
                tempWord = fit.group();
                wordOffsetInLine = fit.start();
                tempLineOffset += fit.start();
                break;
            }
            word = tempWord;
            if ((tempLineOffset += tempWord.length()) > offsetInLine) break;
        }
        if (word.startsWith(SOURCE_IDENTIFIER)) {
            int sourceNumber = Integer.valueOf(word.substring(SOURCE_IDENTIFIER.length(), word.length() - 1));
            source = this.specfile.getSource(sourceNumber);
            if (source != null) {
                return this.prepareHyperlink(lineInfo, line, word, source);
            }
        } else if (word.startsWith(PATCH_IDENTIFIER)) {
            int sourceNumber = Integer.valueOf(word.substring(PATCH_IDENTIFIER.length(), word.length()));
            source = this.specfile.getPatch(sourceNumber);
            if (source != null) {
                return this.prepareHyperlink(lineInfo, line, word, source);
            }
        } else {
            String defineName = this.getDefineName(word);
            SpecfileDefine define = this.specfile.getDefine(defineName);
            if (define != null) {
                return this.prepareHyperlink(lineInfo, line, defineName, define, wordOffsetInLine);
            }
        }
        return null;
    }

    private String getDefineName(String word) {
        if (word.startsWith("%{")) {
            return word.substring(2, word.length() - 1);
        }
        return "";
    }

    private IHyperlink[] prepareHyperlink(IRegion lineInfo, String line, String word, SpecfileElement source, int lineIndex) {
        Region urlRegion = new Region(lineInfo.getOffset() + line.indexOf(word, lineIndex), word.length());
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        IWorkbenchPage page = win.getActivePage();
        IEditorPart editor = page.getActiveEditor();
        if (editor.getEditorInput() instanceof FileEditorInput) {
            IFile original = ((FileEditorInput)editor.getEditorInput()).getFile();
            return new IHyperlink[]{new SpecfileElementHyperlink((IRegion)urlRegion, source, original)};
        }
        return null;
    }

    private IHyperlink[] prepareHyperlink(IRegion lineInfo, String line, String word, SpecfileElement source) {
        return this.prepareHyperlink(lineInfo, line, word, source, 0);
    }

    public void setSpecfile(Specfile specfile) {
        this.specfile = specfile;
    }
}

