/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.trace;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.trace.CTFIOException;
import org.eclipse.tracecompass.ctf.core.trace.CTFStreamInput;
import org.eclipse.tracecompass.ctf.core.trace.CTFStreamPacketOutputWriter;
import org.eclipse.tracecompass.ctf.core.trace.ICTFPacketDescriptor;
import org.eclipse.tracecompass.internal.ctf.core.SafeMappedByteBuffer;
import org.eclipse.tracecompass.internal.ctf.core.trace.StreamInputPacketIndex;

public class CTFStreamOutputWriter {
    @Nullable
    private final CTFStreamInput fStreamInput;
    @NonNull
    private final CTFStreamPacketOutputWriter fStreamPacketOutputWriter;
    @NonNull
    private final File fOutFile;

    public CTFStreamOutputWriter(@NonNull CTFStreamInput streamInput, @NonNull File file) throws CTFException {
        this.fStreamInput = streamInput;
        String inFileName = streamInput.getFile().getName();
        Path outFilePath = FileSystems.getDefault().getPath(file.getAbsolutePath(), inFileName);
        try {
            this.fOutFile = (File)NonNullUtils.checkNotNull((Object)Files.createFile(outFilePath, new FileAttribute[0]).toFile());
        }
        catch (IOException e) {
            throw new CTFIOException("Output file can't be created: " + outFilePath, e);
        }
        this.fStreamPacketOutputWriter = new CTFStreamPacketOutputWriter();
    }

    public void copyPackets(long startTime, long endTime) throws CTFException {
        CTFStreamInput streamInput = this.fStreamInput;
        if (streamInput == null) {
            throw new CTFIOException("StreamInput is null. Can't copy packets");
        }
        try {
            Throwable throwable = null;
            Object var7_7 = null;
            try (FileChannel fc = (FileChannel)NonNullUtils.checkNotNull((Object)FileChannel.open(this.fOutFile.toPath(), StandardOpenOption.WRITE));){
                boolean deleteResult;
                StreamInputPacketIndex index = streamInput.getIndex();
                int count = 0;
                Throwable throwable2 = null;
                Object var12_15 = null;
                try (FileChannel source = FileChannel.open(streamInput.getFile().toPath(), StandardOpenOption.READ);){
                    int i = 0;
                    while (i < index.size()) {
                        ICTFPacketDescriptor entry = index.getElement(i);
                        if (entry.getTimestampBegin() >= startTime && entry.getTimestampBegin() <= endTime) {
                            ByteBuffer buffer = SafeMappedByteBuffer.map(source, FileChannel.MapMode.READ_ONLY, entry.getOffsetBytes(), entry.getPacketSizeBits() / 8L);
                            this.fStreamPacketOutputWriter.writePacket(buffer, fc);
                            ++count;
                        }
                        ++i;
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                if (count == 0 && this.fOutFile.exists() && !(deleteResult = this.fOutFile.delete())) {
                    throw new CTFIOException("Could not delete " + this.fOutFile.getAbsolutePath());
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CTFIOException("Error copying packets: " + e.toString(), e);
        }
    }

    public File getOutFile() {
        return this.fOutFile;
    }
}

