/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.ui.PlatformUiUtil;
import org.eclipse.mylyn.commons.ui.compatibility.CommonFonts;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.AbstractTaskListFilter;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskContainer;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;

public class CustomTaskListDecorationDrawer
implements Listener {
    private final int activationImageOffset;
    private final Image taskActive = CommonImages.getImage((ImageDescriptor)TasksUiImages.CONTEXT_ACTIVE);
    private final Image taskInactive = CommonImages.getImage((ImageDescriptor)TasksUiImages.CONTEXT_INACTIVE_EMPTY);
    private final Image taskInactiveContext = CommonImages.getImage((ImageDescriptor)TasksUiImages.CONTEXT_INACTIVE);
    private final int platformSpecificSquish;
    private boolean useStrikethroughForCompleted;
    private boolean synchronizationOverlaid;
    private boolean focusedMode;
    private final IPropertyChangeListener PROPERTY_LISTENER = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("org.eclipse.mylyn.tasks.ui.strikethrough.for.completed")) {
                if (event.getNewValue() instanceof Boolean) {
                    CustomTaskListDecorationDrawer.this.useStrikethroughForCompleted = (Boolean)event.getNewValue();
                }
            } else if (event.getProperty().equals("org.eclipse.mylyn.tasks.ui.overlays.incoming.tight") && event.getNewValue() instanceof Boolean) {
                CustomTaskListDecorationDrawer.this.synchronizationOverlaid = (Boolean)event.getNewValue();
            }
        }
    };

    public CustomTaskListDecorationDrawer(int activationImageOffset, boolean focusedMode) {
        this.activationImageOffset = activationImageOffset;
        this.platformSpecificSquish = PlatformUiUtil.getTreeItemSquish();
        this.synchronizationOverlaid = TasksUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.overlays.incoming.tight");
        this.useStrikethroughForCompleted = TasksUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.strikethrough.for.completed");
        this.focusedMode = focusedMode;
        TasksUiPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.PROPERTY_LISTENER);
    }

    public void handleEvent(Event event) {
        AbstractTask task;
        Object data = event.item.getData();
        Image activationImage = null;
        if (data instanceof ITask) {
            task = (AbstractTask)data;
            activationImage = task.isActive() ? this.taskActive : (TasksUiPlugin.getContextStore().hasContext((ITask)task) ? this.taskInactiveContext : this.taskInactive);
        }
        if (!CommonFonts.HAS_STRIKETHROUGH && data instanceof AbstractTask & this.useStrikethroughForCompleted && (task = (AbstractTask)data).isCompleted()) {
            Rectangle bounds = ((TreeItem)event.item).getTextBounds(0);
            int lineY = bounds.y + bounds.height / 2;
            String itemText = ((TreeItem)event.item).getText();
            Point extent = event.gc.textExtent(itemText);
            event.gc.drawLine(bounds.x, lineY, bounds.x + extent.x, lineY);
        }
        if (data instanceof ITaskContainer) {
            switch (event.type) {
                case 40: {
                    if (!"gtk".equals(SWT.getPlatform())) break;
                    if (activationImage != null) {
                        this.drawActivationImage(this.activationImageOffset, event, activationImage);
                    }
                    if (this.synchronizationOverlaid || !(data instanceof ITaskContainer)) break;
                    this.drawSyncronizationImage((ITaskContainer)data, event);
                    break;
                }
                case 42: {
                    if (activationImage != null) {
                        this.drawActivationImage(this.activationImageOffset, event, activationImage);
                    }
                    if (!(data instanceof ITaskContainer)) break;
                    this.drawSyncronizationImage((ITaskContainer)data, event);
                }
            }
        }
    }

    private void drawSyncronizationImage(ITaskContainer element, Event event) {
        Image image = null;
        int offsetX = PlatformUiUtil.getIncomingImageOffset();
        int offsetY = event.height / 2 - 5;
        if (this.synchronizationOverlaid) {
            offsetX = event.x + 18 - this.platformSpecificSquish;
            offsetY += 2;
        }
        if (element != null) {
            if (element instanceof ITask) {
                image = CommonImages.getImage((ImageDescriptor)this.getSynchronizationImageDescriptor(element, this.synchronizationOverlaid));
            } else {
                RepositoryQuery query;
                int imageOffset = 0;
                if (!this.hideDecorationOnContainer(element, (TreeItem)event.item) && AbstractTaskListFilter.hasDescendantIncoming(element)) {
                    image = this.synchronizationOverlaid ? CommonImages.getImage((ImageDescriptor)CommonImages.OVERLAY_SYNC_OLD_INCOMMING) : CommonImages.getImage((ImageDescriptor)CommonImages.OVERLAY_SYNC_INCOMMING);
                } else if (element instanceof IRepositoryQuery && (query = (RepositoryQuery)element).getStatus() != null) {
                    image = CommonImages.getImage((ImageDescriptor)TasksUiInternal.getIconFromStatusOfQuery(query));
                    imageOffset = this.synchronizationOverlaid ? 11 : 3;
                }
                int additionalSquish = 0;
                if (this.platformSpecificSquish > 0 && this.synchronizationOverlaid) {
                    additionalSquish = this.platformSpecificSquish + 3;
                } else if (this.platformSpecificSquish > 0) {
                    additionalSquish = this.platformSpecificSquish / 2;
                }
                offsetX = this.synchronizationOverlaid ? 42 - imageOffset - additionalSquish : 24 - imageOffset - additionalSquish;
            }
        }
        if (image != null) {
            event.gc.drawImage(image, offsetX, event.y + offsetY);
        }
    }

    private boolean hideDecorationOnContainer(ITaskContainer element, TreeItem treeItem) {
        RepositoryQuery query;
        if (element instanceof ScheduledTaskContainer) {
            return true;
        }
        if (element instanceof UnmatchedTaskContainer) {
            if (!this.focusedMode) {
                return false;
            }
            if (AbstractTaskListFilter.hasDescendantIncoming(element)) {
                return true;
            }
        } else if (element instanceof IRepositoryQuery && (query = (RepositoryQuery)element).getStatus() != null) {
            return true;
        }
        if (this.focusedMode) {
            return false;
        }
        if (element instanceof IRepositoryQuery || element instanceof TaskCategory) {
            return treeItem.getExpanded();
        }
        return false;
    }

    protected void drawActivationImage(int activationImageOffset, Event event, Image image) {
        Rectangle rect = image.getBounds();
        int offset = Math.max(0, (event.height - rect.height) / 2);
        event.gc.drawImage(image, activationImageOffset, event.y + offset);
    }

    private ImageDescriptor getSynchronizationImageDescriptor(Object element, boolean synchViewStyle) {
        if (element instanceof ITask) {
            ITask repositoryTask = (ITask)element;
            if (repositoryTask.getSynchronizationState() == ITask.SynchronizationState.INCOMING_NEW) {
                if (synchViewStyle) {
                    return CommonImages.OVERLAY_SYNC_OLD_INCOMMING_NEW;
                }
                return CommonImages.OVERLAY_SYNC_INCOMMING_NEW;
            }
            if (repositoryTask.getSynchronizationState() == ITask.SynchronizationState.OUTGOING_NEW) {
                if (synchViewStyle) {
                    return CommonImages.OVERLAY_SYNC_OLD_OUTGOING;
                }
                return CommonImages.OVERLAY_SYNC_OUTGOING_NEW;
            }
            ImageDescriptor imageDescriptor = null;
            if (repositoryTask.getSynchronizationState() == ITask.SynchronizationState.OUTGOING || repositoryTask.getSynchronizationState() == ITask.SynchronizationState.OUTGOING_NEW) {
                imageDescriptor = synchViewStyle ? CommonImages.OVERLAY_SYNC_OLD_OUTGOING : CommonImages.OVERLAY_SYNC_OUTGOING;
            } else if (repositoryTask.getSynchronizationState() == ITask.SynchronizationState.INCOMING) {
                if (!Boolean.parseBoolean(repositoryTask.getAttribute("task.common.suppress.incoming"))) {
                    imageDescriptor = synchViewStyle ? CommonImages.OVERLAY_SYNC_OLD_INCOMMING : CommonImages.OVERLAY_SYNC_INCOMMING;
                }
            } else if (repositoryTask.getSynchronizationState() == ITask.SynchronizationState.CONFLICT) {
                imageDescriptor = CommonImages.OVERLAY_SYNC_CONFLICT;
            }
            if (imageDescriptor == null && repositoryTask instanceof AbstractTask && ((AbstractTask)repositoryTask).getStatus() != null) {
                return CommonImages.OVERLAY_SYNC_WARNING;
            }
            if (imageDescriptor != null) {
                return imageDescriptor;
            }
        } else if (element instanceof IRepositoryQuery) {
            RepositoryQuery query = (RepositoryQuery)element;
            return TasksUiInternal.getIconFromStatusOfQuery(query);
        }
        return CommonImages.OVERLAY_CLEAR;
    }

    public void dispose() {
        TasksUiPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.PROPERTY_LISTENER);
    }

    public void setUseStrikethroughForCompleted(boolean useStrikethroughForCompleted) {
        this.useStrikethroughForCompleted = useStrikethroughForCompleted;
    }

    public void setSynchronizationOverlaid(boolean synchronizationOverlaid) {
        this.synchronizationOverlaid = synchronizationOverlaid;
    }

    public boolean isFocusedMode() {
        return this.focusedMode;
    }

    public void setFocusedMode(boolean focusedMode) {
        this.focusedMode = focusedMode;
    }
}

