/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import com.ibm.icu.text.MessageFormat;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICLogConstants;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.internal.core.model.DebugLogConstants;
import org.eclipse.cdt.internal.core.util.CharArrayBuffer;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class Util
implements ICLogConstants {
    public static boolean VERBOSE_PARSER = false;
    public static boolean VERBOSE_SCANNER = false;
    public static boolean VERBOSE_MODEL = false;
    public static boolean VERBOSE_DELTA = false;
    public static boolean PARSER_EXCEPTIONS = false;
    public static String LINE_SEPARATOR = System.getProperty("line.separator");

    private Util() {
    }

    public static StringBuffer getContent(IFile file) throws IOException {
        BufferedInputStream stream = null;
        try {
            stream = new BufferedInputStream(file.getContents(true));
        }
        catch (CoreException e) {
            throw new IOException(e.getMessage());
        }
        try {
            char[] b = Util.getInputStreamAsCharArray(stream, -1, null);
            StringBuffer stringBuffer = new StringBuffer(b.length).append(b);
            return stringBuffer;
        }
        finally {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
    }

    public static char[] getInputStreamAsCharArray(InputStream stream, int length, String encoding) throws IOException {
        try (InputStreamReader reader = encoding == null ? new InputStreamReader(stream) : new InputStreamReader(stream, encoding);){
            char[] contents;
            if (length == -1) {
                contents = new char[]{};
                int contentsLength = 0;
                int charsRead = -1;
                do {
                    int available;
                    if (contentsLength + (available = stream.available()) > contents.length) {
                        char[] cArray = contents;
                        contents = new char[contentsLength + available];
                        System.arraycopy(cArray, 0, contents, 0, contentsLength);
                    }
                    if ((charsRead = reader.read(contents, contentsLength, available)) <= 0) continue;
                    contentsLength += charsRead;
                } while (charsRead > 0);
                if (contentsLength < contents.length) {
                    char[] cArray = contents;
                    contents = new char[contentsLength];
                    System.arraycopy(cArray, 0, contents, 0, contentsLength);
                }
            } else {
                contents = new char[length];
                int len = 0;
                int readSize = 0;
                while (readSize != -1 && len != length) {
                    readSize = reader.read(contents, len += readSize, length - len);
                }
                if (len != length) {
                    char[] cArray = contents;
                    contents = new char[len];
                    System.arraycopy(cArray, 0, contents, 0, len);
                }
            }
            char[] cArray = contents;
            return cArray;
        }
    }

    public static char[] getResourceContentsAsCharArray(IFile file) throws CModelException {
        try {
            return Util.getResourceContentsAsCharArray(file, file.getCharset());
        }
        catch (CoreException exc) {
            throw new CModelException(exc, 966);
        }
    }

    public static char[] getResourceContentsAsCharArray(IFile file, String encoding) throws CModelException {
        BufferedInputStream stream = null;
        try {
            stream = new BufferedInputStream(file.getContents(true));
        }
        catch (CoreException e) {
            throw new CModelException(e, 969);
        }
        try {
            char[] cArray = Util.getInputStreamAsCharArray(stream, -1, encoding);
            return cArray;
        }
        catch (IOException e) {
            throw new CModelException(e, 985);
        }
        finally {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void log(Throwable e, String message, ICLogConstants.LogConst logType) {
        Status status = new Status(4, "org.eclipse.cdt.core", message, e);
        Util.log((IStatus)status, logType);
    }

    public static void log(IStatus status, ICLogConstants.LogConst logType) {
        if (logType.equals(ICLogConstants.PDE)) {
            CCorePlugin.getDefault().getLog().log(status);
        } else if (logType.equals(ICLogConstants.CDT)) {
            CCorePlugin.getDefault().cdtLog.log(status);
        }
    }

    public static void log(String message, ICLogConstants.LogConst logType) {
        Status status = new Status(1, "org.eclipse.cdt.core", 1, message, null);
        Util.log((IStatus)status, logType);
    }

    public static void debugLog(String message, DebugLogConstants client) {
        Util.debugLog(message, client, true);
    }

    public static void debugLog(String message, DebugLogConstants client, boolean addTimeStamp) {
        if (CCorePlugin.getDefault() == null) {
            return;
        }
        if (CCorePlugin.getDefault().isDebugging() && Util.isActive(client)) {
            if (addTimeStamp) {
                message = MessageFormat.format((String)"[{0}] {1}", (Object[])new Object[]{new Long(System.currentTimeMillis()), message});
            }
            while (message.length() > 100) {
                String partial = message.substring(0, 100);
                message = message.substring(100);
                System.out.println(String.valueOf(partial) + "\\");
            }
            if (message.endsWith("\n")) {
                System.err.print(message);
            } else {
                System.out.println(message);
            }
        }
    }

    public static boolean isActive(DebugLogConstants client) {
        if (client.equals((Object)DebugLogConstants.PARSER)) {
            return VERBOSE_PARSER;
        }
        if (client.equals((Object)DebugLogConstants.SCANNER)) {
            return VERBOSE_SCANNER;
        }
        if (client.equals((Object)DebugLogConstants.MODEL)) {
            return VERBOSE_MODEL;
        }
        return false;
    }

    public static void setDebugging(boolean value) {
        CCorePlugin.getDefault().setDebugging(value);
    }

    public static int combineHashCodes(int hashCode1, int hashCode2) {
        return hashCode1 * 17 + hashCode2;
    }

    public static boolean equalArraysOrNull(Object[] a, Object[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int len = a.length;
        if (len != b.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (a[i] == null ? b[i] != null : !a[i].equals(b[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalArraysOrNull(int[] a, int[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int len = a.length;
        if (len != b.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalOrNull(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static char[] normalizeCRs(char[] text, char[] buffer) {
        CharArrayBuffer result = new CharArrayBuffer();
        int lineStart = 0;
        int length = text.length;
        if (length == 0) {
            return text;
        }
        String lineSeparator = Util.getLineSeparator(text, buffer);
        int nextChar = text[0];
        int i = 0;
        while (i < length) {
            int currentChar = nextChar;
            nextChar = i < length - 1 ? text[i + 1] : 32;
            switch (currentChar) {
                case 10: {
                    int lineLength = i - lineStart;
                    char[] line = new char[lineLength];
                    System.arraycopy(text, lineStart, line, 0, lineLength);
                    result.append(line);
                    result.append(lineSeparator);
                    lineStart = i + 1;
                    break;
                }
                case 13: {
                    char[] line;
                    int lineLength = i - lineStart;
                    if (lineLength >= 0) {
                        line = new char[lineLength];
                        System.arraycopy(text, lineStart, line, 0, lineLength);
                        result.append(line);
                        result.append(lineSeparator);
                        if (nextChar == 10) {
                            nextChar = 32;
                            lineStart = i + 2;
                            break;
                        }
                        lineStart = i + 1;
                        break;
                    }
                    lineStart = i + 1;
                }
            }
            ++i;
        }
        if (lineStart > 0) {
            int lastLineLength = length - lineStart;
            if (lastLineLength > 0) {
                char[] lastLine = new char[lastLineLength];
                System.arraycopy(text, lineStart, lastLine, 0, lastLineLength);
                result.append(lastLine);
            }
            return result.getContents();
        }
        return text;
    }

    public static String normalizeCRs(String text, String buffer) {
        return new String(Util.normalizeCRs(text.toCharArray(), buffer.toCharArray()));
    }

    private static String getLineSeparator(char[] text, char[] buffer) {
        String lineSeparator = Util.findLineSeparator(buffer);
        if (lineSeparator == null && (lineSeparator = Util.findLineSeparator(text)) == null) {
            return LINE_SEPARATOR;
        }
        return lineSeparator;
    }

    public static String findLineSeparator(char[] text) {
        int length = text.length;
        if (length > 0) {
            int nextChar = text[0];
            int i = 0;
            while (i < length) {
                int currentChar = nextChar;
                nextChar = i < length - 1 ? text[i + 1] : 32;
                switch (currentChar) {
                    case 10: {
                        return "\n";
                    }
                    case 13: {
                        return nextChar == 10 ? "\r\n" : "\r";
                    }
                }
                ++i;
            }
        }
        return null;
    }

    private static String getLineSeparatorFromPreferences(Preferences node) {
        try {
            if (node.nodeExists("org.eclipse.core.runtime")) {
                return node.node("org.eclipse.core.runtime").get("line.separator", null);
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        return null;
    }

    public static String getLineSeparator(URI fileUri) {
        String value = null;
        InputStream input = null;
        try {
            try {
                File file = new File(fileUri);
                if (file.exists()) {
                    input = new FileInputStream(file);
                    value = Util.getLineSeparator(input);
                }
            }
            catch (Exception exception) {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
        }
        return value;
    }

    public static String getLineSeparator(IFile file) {
        String value;
        block15: {
            value = null;
            InputStream input = null;
            try {
                try {
                    input = file.getContents();
                    value = Util.getLineSeparator(input);
                }
                catch (CoreException coreException) {
                    try {
                        if (input != null) {
                            input.close();
                        }
                        break block15;
                    }
                    catch (IOException iOException) {}
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (value == null) {
            value = Util.getDefaultLineSeparator(file.getProject());
        }
        return value;
    }

    public static String getDefaultLineSeparator(IProject project) {
        String value = null;
        IEclipsePreferences rootNode = Platform.getPreferencesService().getRootNode();
        if (project != null && (value = Util.getLineSeparatorFromPreferences(rootNode.node("project").node(project.getName()))) != null) {
            return value;
        }
        value = Util.getDefaultLineSeparator();
        return value;
    }

    public static String getDefaultLineSeparator() {
        IEclipsePreferences rootNode = Platform.getPreferencesService().getRootNode();
        String value = null;
        value = Util.getLineSeparatorFromPreferences(rootNode.node("instance"));
        if (value != null) {
            return value;
        }
        value = Util.getLineSeparatorFromPreferences(rootNode.node("default"));
        if (value != null) {
            return value;
        }
        return LINE_SEPARATOR;
    }

    private static String getLineSeparator(InputStream input) {
        int c;
        block6: {
            c = input.read();
            while (c != -1 && c != 13 && c != 10) {
                c = input.read();
            }
            if (c != 10) break block6;
            return "\n";
        }
        try {
            if (c == 13) {
                int c2 = input.read();
                if (c2 == 10) {
                    return "\r\n";
                }
                return "\r";
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static boolean isNonZeroLengthFile(IPath path) {
        return Util.isNonZeroLengthFile(URIUtil.toURI((IPath)path));
    }

    public static boolean isNonZeroLengthFile(URI uri) {
        try {
            IFileInfo file = EFS.getStore((URI)uri).fetchInfo();
            return file.getLength() != 0L;
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

