/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorUndefStatement;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDirective;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.parser.ISignificantMacros;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.index.IIndexFragmentName;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.index.IWritableIndexFragment;
import org.eclipse.cdt.internal.core.index.IndexFileLocation;
import org.eclipse.cdt.internal.core.parser.scanner.SignificantMacros;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.YieldableIndexLock;
import org.eclipse.cdt.internal.core.pdom.db.BTree;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeComparator;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.dom.Messages;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMInclude;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacro;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacroContainer;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacroReferenceName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class PDOMFile
implements IIndexFragmentFile {
    private final PDOMLinkage fLinkage;
    private final long record;
    private IIndexFileLocation location;
    private ISignificantMacros sigMacros;
    private static final int FIRST_NAME = 0;
    private static final int FIRST_INCLUDE = 4;
    private static final int FIRST_INCLUDED_BY = 8;
    private static final int FIRST_MACRO = 12;
    private static final int LOCATION_REPRESENTATION = 16;
    private static final int LINKAGE_ID = 20;
    private static final int FLAGS = 23;
    private static final int TIME_STAMP = 24;
    private static final int SOURCE_READ_TIME = 32;
    private static final int CONTENT_HASH = 40;
    private static final int SIZE_AND_ENCODING_HASH = 48;
    private static final int LAST_USING_DIRECTIVE = 52;
    private static final int FIRST_MACRO_REFERENCE = 56;
    private static final int SIGNIFICANT_MACROS = 60;
    private static final int REPLACEMENT_HEADER = 64;
    private static final int RECORD_SIZE = 68;
    private static final int FLAG_PRAGMA_ONCE_SEMANTICS = 1;

    public PDOMFile(PDOMLinkage linkage, long record) {
        this.fLinkage = linkage;
        this.record = record;
    }

    public PDOMFile(PDOMLinkage linkage, IIndexFileLocation location, int linkageID, ISignificantMacros macros) throws CoreException {
        this.fLinkage = linkage;
        this.location = location;
        Database db = this.fLinkage.getDB();
        this.record = db.malloc(68);
        String locationString = this.fLinkage.getPDOM().getLocationConverter().toInternalFormat(location);
        if (locationString == null) {
            throw new CoreException(CCorePlugin.createStatus(String.valueOf(Messages.getString("PDOMFile.toInternalProblem")) + location.getURI()));
        }
        IString locationDBString = db.newString(locationString);
        db.putRecPtr(this.record + 16L, locationDBString.getRecord());
        db.put3ByteUnsignedInt(this.record + 20L, linkageID);
        db.putRecPtr(this.record + 60L, db.newString(macros.encode()).getRecord());
        this.setTimestamp(-1L);
    }

    public long getRecord() {
        return this.record;
    }

    public PDOM getPDOM() {
        return this.fLinkage.getPDOM();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PDOMFile) {
            PDOMFile other = (PDOMFile)obj;
            return this.fLinkage.getPDOM().equals(other.getLinkage().getPDOM()) && this.record == other.record;
        }
        return false;
    }

    public final int hashCode() {
        return System.identityHashCode(this.fLinkage.getPDOM()) + (int)(41L * this.record);
    }

    public void replaceContentsFrom(PDOMFile sourceFile) throws CoreException {
        this.clear();
        this.setLastUsingDirective(sourceFile.getLastUsingDirectiveRec());
        PDOMInclude include = sourceFile.getFirstInclude();
        this.setFirstInclude(include);
        while (include != null) {
            include.setIncludedBy(this);
            include = include.getNextInIncludes();
        }
        this.transferIncluders(sourceFile);
        PDOMMacro macro = sourceFile.getFirstMacro();
        this.setFirstMacro(macro);
        while (macro != null) {
            macro.setFile(this);
            macro = macro.getNextMacro();
        }
        PDOMMacroReferenceName mref = sourceFile.getFirstMacroReference();
        this.setFirstMacroReference(mref);
        while (mref != null) {
            mref.setFile(this);
            mref = mref.getNextInFile();
        }
        PDOMName name = sourceFile.getFirstName();
        this.setFirstName(name);
        while (name != null) {
            name.setFile(this);
            name = name.getNextInFile();
        }
        this.setTimestamp(sourceFile.getTimestamp());
        this.setSourceReadTime(sourceFile.getSourceReadTime());
        this.setSizeAndEncodingHashcode(sourceFile.getSizeAndEncodingHashcode());
        this.setContentsHash(sourceFile.getContentsHash());
        Database db = this.fLinkage.getDB();
        db.putByte(this.record + 23L, db.getByte(sourceFile.record + 23L));
        db.putRecPtr(this.record + 64L, db.getRecPtr(sourceFile.record + 64L));
        db.putRecPtr(sourceFile.record + 64L, 0L);
        sourceFile.delete();
    }

    @Override
    public void transferIncluders(IIndexFragmentFile sourceFile) throws CoreException {
        PDOMFile source = (PDOMFile)sourceFile;
        PDOMInclude include = source.getFirstIncludedBy();
        if (include != null) {
            source.setFirstIncludedBy(null);
            PDOMInclude i = include;
            while (i != null) {
                i.setIncludes(this);
                i = i.getNextInIncludedBy();
            }
            PDOMInclude last = this.getFirstIncludedBy();
            if (last == null) {
                this.setFirstIncludedBy(include);
            } else {
                PDOMInclude i2 = last;
                while (i2 != null) {
                    last = i2;
                    i2 = i2.getNextInIncludedBy();
                }
                last.setNextInIncludedBy(include);
                include.setPrevInIncludedBy(last);
            }
        }
    }

    @Override
    public void transferContext(IIndexFragmentFile sourceFile) throws CoreException {
        PDOMFile source = (PDOMFile)sourceFile;
        PDOMInclude include = source.getFirstIncludedBy();
        if (include != null) {
            PDOMInclude next = include.getNextInIncludedBy();
            include.setNextInIncludedBy(null);
            source.setFirstIncludedBy(next);
            if (next != null) {
                next.setPrevInIncludedBy(null);
            }
            include.setIncludes(this);
            this.addIncludedBy(include, false);
        }
    }

    public void setLocation(IIndexFileLocation location) throws CoreException {
        String locationString = this.fLinkage.getPDOM().getLocationConverter().toInternalFormat(location);
        if (locationString == null) {
            throw new CoreException(CCorePlugin.createStatus(String.valueOf(Messages.getString("PDOMFile.toInternalProblem")) + location.getURI()));
        }
        this.setInternalLocation(locationString);
    }

    public void setInternalLocation(String internalLocation) throws CoreException {
        Database db = this.fLinkage.getDB();
        long oldRecord = db.getRecPtr(this.record + 16L);
        if (oldRecord != 0L) {
            db.getString(oldRecord).delete();
        }
        db.putRecPtr(this.record + 16L, db.newString(internalLocation).getRecord());
        this.location = null;
    }

    @Override
    public int getLinkageID() throws CoreException {
        Database db = this.fLinkage.getDB();
        return db.get3ByteUnsignedInt(this.record + 20L);
    }

    @Override
    public long getTimestamp() throws CoreException {
        Database db = this.fLinkage.getDB();
        return db.getLong(this.record + 24L);
    }

    @Override
    public void setTimestamp(long timestamp) throws CoreException {
        Database db = this.fLinkage.getDB();
        db.putLong(this.record + 24L, timestamp);
    }

    @Override
    public long getSourceReadTime() throws CoreException {
        Database db = this.fLinkage.getDB();
        return db.getLong(this.record + 32L);
    }

    @Override
    public void setSourceReadTime(long time) throws CoreException {
        Database db = this.fLinkage.getDB();
        db.putLong(this.record + 32L, time);
    }

    @Override
    public long getContentsHash() throws CoreException {
        Database db = this.fLinkage.getDB();
        return db.getLong(this.record + 40L);
    }

    @Override
    public void setContentsHash(long hash) throws CoreException {
        Database db = this.fLinkage.getDB();
        db.putLong(this.record + 40L, hash);
    }

    @Override
    public int getScannerConfigurationHashcode() throws CoreException {
        return 0;
    }

    @Override
    public int getSizeAndEncodingHashcode() throws CoreException {
        Database db = this.fLinkage.getDB();
        return db.getInt(this.record + 48L);
    }

    @Override
    @Deprecated
    public int getEncodingHashcode() throws CoreException {
        return 0;
    }

    @Override
    public void setSizeAndEncodingHashcode(int hashcode) throws CoreException {
        Database db = this.fLinkage.getDB();
        db.putInt(this.record + 48L, hashcode);
    }

    @Override
    public boolean hasPragmaOnceSemantics() throws CoreException {
        return (this.fLinkage.getDB().getByte(this.record + 23L) & 1) != 0;
    }

    @Override
    public void setPragmaOnceSemantics(boolean value) throws CoreException {
        Database db = this.fLinkage.getDB();
        byte flags = db.getByte(this.record + 23L);
        flags = value ? (byte)(flags | 1) : (byte)(flags & 0xFFFFFFFE);
        db.putByte(this.record + 23L, flags);
    }

    private PDOMName getFirstName() throws CoreException {
        long namerec = this.fLinkage.getDB().getRecPtr(this.record + 0L);
        return namerec != 0L ? new PDOMName(this.fLinkage, namerec) : null;
    }

    private void setFirstName(PDOMName firstName) throws CoreException {
        long namerec = firstName != null ? firstName.getRecord() : 0L;
        this.fLinkage.getDB().putRecPtr(this.record + 0L, namerec);
    }

    private PDOMMacroReferenceName getFirstMacroReference() throws CoreException {
        long namerec = this.fLinkage.getDB().getRecPtr(this.record + 56L);
        return namerec != 0L ? new PDOMMacroReferenceName(this.fLinkage, namerec) : null;
    }

    private void setFirstMacroReference(PDOMMacroReferenceName firstName) throws CoreException {
        long namerec = firstName != null ? firstName.getRecord() : 0L;
        this.fLinkage.getDB().putRecPtr(this.record + 56L, namerec);
    }

    public PDOMInclude getFirstInclude() throws CoreException {
        long increc = this.fLinkage.getDB().getRecPtr(this.record + 4L);
        return increc != 0L ? new PDOMInclude(this.fLinkage, increc) : null;
    }

    public void setFirstInclude(PDOMInclude include) throws CoreException {
        long rec = include != null ? include.getRecord() : 0L;
        this.fLinkage.getDB().putRecPtr(this.record + 4L, rec);
    }

    public PDOMInclude getFirstIncludedBy() throws CoreException {
        long rec = this.fLinkage.getDB().getRecPtr(this.record + 8L);
        return rec != 0L ? new PDOMInclude(this.fLinkage, rec) : null;
    }

    @Override
    public IIndexInclude getParsedInContext() throws CoreException {
        return this.getFirstIncludedBy();
    }

    public void setFirstIncludedBy(PDOMInclude includedBy) throws CoreException {
        long rec = includedBy != null ? includedBy.getRecord() : 0L;
        this.fLinkage.getDB().putRecPtr(this.record + 8L, rec);
    }

    public PDOMMacro getFirstMacro() throws CoreException {
        long rec = this.fLinkage.getDB().getRecPtr(this.record + 12L);
        return rec != 0L ? new PDOMMacro(this.fLinkage, rec) : null;
    }

    public void setFirstMacro(PDOMMacro macro) throws CoreException {
        long rec = macro != null ? macro.getRecord() : 0L;
        this.fLinkage.getDB().putRecPtr(this.record + 12L, rec);
    }

    public void addMacros(IASTPreprocessorStatement[] macros) throws CoreException {
        assert (this.getFirstMacro() == null);
        PDOMMacro lastMacro = null;
        PDOMLinkage linkage = this.getLinkage();
        IASTPreprocessorStatement[] iASTPreprocessorStatementArray = macros;
        int n = macros.length;
        int n2 = 0;
        while (n2 < n) {
            PDOMMacroContainer container;
            IASTPreprocessorStatement stmt = iASTPreprocessorStatementArray[n2];
            PDOMMacro pdomMacro = null;
            if (stmt instanceof IASTPreprocessorMacroDefinition) {
                IASTPreprocessorMacroDefinition macro = (IASTPreprocessorMacroDefinition)stmt;
                container = linkage.getMacroContainer(macro.getName().getSimpleID());
                pdomMacro = new PDOMMacro(this.fLinkage, container, macro, this);
            } else if (stmt instanceof IASTPreprocessorUndefStatement) {
                IASTPreprocessorUndefStatement undef = (IASTPreprocessorUndefStatement)stmt;
                container = linkage.getMacroContainer(undef.getMacroName().getSimpleID());
                pdomMacro = new PDOMMacro(this.fLinkage, container, undef, this);
            }
            if (pdomMacro != null) {
                if (lastMacro == null) {
                    this.setFirstMacro(pdomMacro);
                } else {
                    lastMacro.setNextMacro(pdomMacro);
                }
                lastMacro = pdomMacro;
            }
            ++n2;
        }
    }

    final PDOMLinkage getLinkage() {
        return this.fLinkage;
    }

    public void addNames(IASTName[][] names, YieldableIndexLock lock) throws CoreException, InterruptedException {
        assert (this.getFirstName() == null);
        assert (this.getFirstMacroReference() == null);
        PDOMLinkage linkage = this.getLinkage();
        HashMap<IASTName, PDOMName> nameCache = new HashMap<IASTName, PDOMName>();
        PDOMName lastName = null;
        PDOMMacroReferenceName lastMacroName = null;
        IASTName[][] iASTNameArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            IASTName[] name = iASTNameArray[n2];
            if (name[0] != null) {
                PDOMName caller;
                IIndexFragmentName fname;
                if (lock != null) {
                    lock.yield();
                }
                if ((fname = this.createPDOMName(linkage, name[0], caller = (PDOMName)nameCache.get(name[1]))) instanceof PDOMName) {
                    PDOMName pdomName = (PDOMName)fname;
                    nameCache.put(name[0], pdomName);
                    if (lastName == null) {
                        this.setFirstName(pdomName);
                    } else {
                        lastName.setNextInFile(pdomName);
                    }
                    lastName = pdomName;
                } else if (fname instanceof PDOMMacroReferenceName) {
                    PDOMMacroReferenceName macroName = (PDOMMacroReferenceName)fname;
                    if (lastMacroName == null) {
                        this.setFirstMacroReference(macroName);
                    } else {
                        lastMacroName.setNextInFile(macroName);
                    }
                    lastMacroName = macroName;
                }
            }
            ++n2;
        }
    }

    private IIndexFragmentName createPDOMName(PDOMLinkage linkage, IASTName name, PDOMName caller) throws CoreException {
        IBinding binding = name.getBinding();
        if (binding instanceof IParameter) {
            return null;
        }
        try {
            if (binding instanceof IMacroBinding || binding == null && name.getPropertyInParent() == IASTPreprocessorStatement.MACRO_NAME) {
                return this.createPDOMMacroReferenceName(linkage, name);
            }
            PDOMBinding pdomBinding = linkage.addBinding(name);
            if (pdomBinding != null) {
                PDOMName result = new PDOMName(this.fLinkage, name, this, pdomBinding, caller);
                linkage.onCreateName(this, name, result);
                return result;
            }
        }
        catch (CoreException e) {
            IStatus status = e.getStatus();
            if (status != null && status.getCode() == 4 && "org.eclipse.cdt.core".equals(status.getPlugin())) {
                throw e;
            }
            CCorePlugin.log(e);
        }
        return null;
    }

    private IIndexFragmentName createPDOMMacroReferenceName(PDOMLinkage linkage, IASTName name) throws CoreException {
        PDOMMacroContainer cont = linkage.getMacroContainer(name.getSimpleID());
        return new PDOMMacroReferenceName(this.fLinkage, name, this, cont);
    }

    public void clear() throws CoreException {
        ICPPUsingDirective[] directives;
        ICPPUsingDirective[] iCPPUsingDirectiveArray = directives = this.getUsingDirectives();
        int n = directives.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPUsingDirective ud = iCPPUsingDirectiveArray[n2];
            if (ud instanceof IPDOMNode) {
                ((IPDOMNode)((Object)ud)).delete(null);
            }
            ++n2;
        }
        this.setLastUsingDirective(0L);
        PDOMInclude include = this.getFirstInclude();
        while (include != null) {
            PDOMInclude nextInclude = include.getNextInIncludes();
            include.delete();
            include = nextInclude;
        }
        this.setFirstInclude(null);
        PDOMLinkage linkage = this.getLinkage();
        PDOMMacro macro = this.getFirstMacro();
        while (macro != null) {
            PDOMMacro nextMacro = macro.getNextMacro();
            macro.delete(linkage);
            macro = nextMacro;
        }
        this.setFirstMacro(null);
        ArrayList<PDOMName> names = new ArrayList<PDOMName>();
        PDOMName name2 = this.getFirstName();
        while (name2 != null) {
            names.add(name2);
            linkage.onDeleteName(name2);
            name2 = name2.getNextInFile();
        }
        for (PDOMName name2 : names) {
            name2.delete();
        }
        this.setFirstName(null);
        ArrayList<PDOMMacroReferenceName> mrefs = new ArrayList<PDOMMacroReferenceName>();
        PDOMMacroReferenceName mref = this.getFirstMacroReference();
        while (mref != null) {
            mrefs.add(mref);
            mref = mref.getNextInFile();
        }
        for (PDOMMacroReferenceName m : mrefs) {
            m.delete();
        }
        this.setFirstMacroReference(null);
        this.setSourceReadTime(0L);
        this.setTimestamp(-1L);
    }

    public void delete() throws CoreException {
        Database db = this.fLinkage.getDB();
        long locRecord = db.getRecPtr(this.record + 16L);
        if (locRecord != 0L) {
            db.getString(locRecord).delete();
        }
        if ((locRecord = db.getRecPtr(this.record + 60L)) != 0L) {
            db.getString(locRecord).delete();
        }
        if ((locRecord = db.getRecPtr(this.record + 64L)) != 0L) {
            db.getString(locRecord).delete();
        }
        db.free(this.record);
    }

    public void addIncludesTo(IWritableIndex.IncludeInformation[] includeInfos) throws CoreException {
        assert (this.getFirstInclude() == null);
        PDOMInclude lastInclude = null;
        IWritableIndex.IncludeInformation[] includeInformationArray = includeInfos;
        int n = includeInfos.length;
        int n2 = 0;
        while (n2 < n) {
            IWritableIndex.IncludeInformation info = includeInformationArray[n2];
            PDOMFile targetFile = (PDOMFile)info.fTargetFile;
            PDOMInclude pdomInclude = new PDOMInclude(this.fLinkage, info.fStatement, this, targetFile);
            assert (targetFile == null || targetFile.getIndexFragment() instanceof IWritableIndexFragment);
            if (targetFile != null) {
                targetFile.addIncludedBy(pdomInclude, info.fIsContext);
            }
            if (lastInclude == null) {
                this.setFirstInclude(pdomInclude);
            } else {
                lastInclude.setNextInIncludes(pdomInclude);
            }
            lastInclude = pdomInclude;
            ++n2;
        }
    }

    public void addIncludedBy(PDOMInclude include, boolean isContext) throws CoreException {
        PDOMInclude firstIncludedBy = this.getFirstIncludedBy();
        if (firstIncludedBy != null) {
            if (isContext) {
                this.setFirstIncludedBy(include);
                include.setNextInIncludedBy(firstIncludedBy);
                firstIncludedBy.setPrevInIncludedBy(include);
            } else {
                PDOMInclude secondIncludedBy = firstIncludedBy.getNextInIncludedBy();
                if (secondIncludedBy != null) {
                    include.setNextInIncludedBy(secondIncludedBy);
                    secondIncludedBy.setPrevInIncludedBy(include);
                }
                include.setPrevInIncludedBy(firstIncludedBy);
                firstIncludedBy.setNextInIncludedBy(include);
            }
        } else {
            this.setFirstIncludedBy(include);
        }
    }

    @Override
    public IIndexInclude[] getIncludes() throws CoreException {
        ArrayList<PDOMInclude> result = new ArrayList<PDOMInclude>();
        PDOMInclude include = this.getFirstInclude();
        while (include != null) {
            result.add(include);
            include = include.getNextInIncludes();
        }
        return result.toArray(new IIndexInclude[result.size()]);
    }

    @Override
    public boolean hasUnresolvedInclude() throws CoreException {
        PDOMInclude include = this.getFirstInclude();
        while (include != null) {
            if (!include.isResolved() && include.isActive()) {
                return true;
            }
            include = include.getNextInIncludes();
        }
        return false;
    }

    @Override
    public IIndexMacro[] getMacros() throws CoreException {
        ArrayList<PDOMMacro> result = new ArrayList<PDOMMacro>();
        PDOMMacro macro = this.getFirstMacro();
        while (macro != null) {
            result.add(macro);
            macro = macro.getNextMacro();
        }
        return result.toArray(new IIndexMacro[result.size()]);
    }

    @Override
    public IIndexFragment getIndexFragment() {
        return this.fLinkage.getPDOM();
    }

    @Override
    public IIndexName[] findNames(int offset, int length) throws CoreException {
        int nameOffset;
        ArrayList<IIndexFragmentName> result = new ArrayList<IIndexFragmentName>();
        IIndexFragmentName name = this.getFirstName();
        while (name != null) {
            nameOffset = ((PDOMName)name).getNodeOffset();
            if (nameOffset >= offset) {
                if (nameOffset + ((PDOMName)name).getNodeLength() <= offset + length) {
                    result.add(name);
                } else if (((PDOMName)name).isReference()) break;
            }
            name = ((PDOMName)name).getNextInFile();
        }
        PDOMMacro macro = this.getFirstMacro();
        while (macro != null) {
            nameOffset = macro.getNodeOffset();
            if (nameOffset >= offset) {
                if (nameOffset + macro.getNodeLength() > offset + length) break;
                IIndexFragmentName name2 = macro.getDefinition();
                if (name2 != null) {
                    result.add(name2);
                }
            }
            macro = macro.getNextMacro();
        }
        name = this.getFirstMacroReference();
        while (name != null) {
            nameOffset = ((PDOMMacroReferenceName)name).getNodeOffset();
            if (nameOffset >= offset) {
                if (nameOffset + ((PDOMMacroReferenceName)name).getNodeLength() > offset + length) break;
                result.add(name);
            }
            name = ((PDOMMacroReferenceName)name).getNextInFile();
        }
        return result.toArray(new IIndexName[result.size()]);
    }

    public static IIndexFragmentFile[] findFiles(PDOMLinkage linkage, BTree btree, IIndexFileLocation location, IIndexLocationConverter strategy) throws CoreException {
        String internalRepresentation = strategy.toInternalFormat(location);
        if (internalRepresentation != null) {
            Finder finder = new Finder(linkage.getDB(), internalRepresentation, linkage.getLinkageID(), null);
            btree.accept(finder);
            long[] records = finder.getRecords();
            IIndexFragmentFile[] result = new IIndexFragmentFile[records.length];
            int i = 0;
            while (i < result.length) {
                result[i] = new PDOMFile(linkage, records[i]);
                ++i;
            }
            return result;
        }
        return IIndexFragmentFile.EMPTY_ARRAY;
    }

    @Deprecated
    public static PDOMFile findFile(PDOMLinkage linkage, BTree btree, IIndexFileLocation location, IIndexLocationConverter strategy) throws CoreException {
        return PDOMFile.findFile(linkage, btree, location, strategy, null);
    }

    public static PDOMFile findFile(PDOMLinkage linkage, BTree btree, IIndexFileLocation location, IIndexLocationConverter strategy, ISignificantMacros macroDictionary) throws CoreException {
        String internalRepresentation = strategy.toInternalFormat(location);
        if (internalRepresentation != null) {
            Finder finder = new Finder(linkage.getDB(), internalRepresentation, linkage.getLinkageID(), macroDictionary);
            btree.accept(finder);
            long record = finder.getRecord();
            if (record != 0L) {
                return new PDOMFile(linkage, record);
            }
        }
        return null;
    }

    public static IIndexFragmentFile[] findFiles(PDOM pdom, BTree btree, IIndexFileLocation location, IIndexLocationConverter strategy) throws CoreException {
        String internalRepresentation = strategy.toInternalFormat(location);
        if (internalRepresentation != null) {
            Finder finder = new Finder(pdom.getDB(), internalRepresentation, -1, null);
            btree.accept(finder);
            long[] records = finder.getRecords();
            IIndexFragmentFile[] result = new PDOMFile[records.length];
            int i = 0;
            while (i < result.length) {
                result[i] = PDOMFile.recreateFile(pdom, records[i]);
                ++i;
            }
            return result;
        }
        return IIndexFragmentFile.EMPTY_ARRAY;
    }

    public static PDOMFile recreateFile(PDOM pdom, long record) throws CoreException {
        Database db = pdom.getDB();
        int linkageID = db.get3ByteUnsignedInt(record + 20L);
        PDOMLinkage linkage = pdom.getLinkage(linkageID);
        if (linkage == null) {
            throw new CoreException(PDOMFile.createStatus("Invalid linkage ID in database"));
        }
        return new PDOMFile(linkage, record);
    }

    @Override
    public IIndexFileLocation getLocation() throws CoreException {
        if (this.location == null) {
            Database db = this.fLinkage.getDB();
            String raw = db.getString(db.getRecPtr(this.record + 16L)).getString();
            this.location = this.fLinkage.getPDOM().getLocationConverter().fromInternalFormat(raw);
            if (this.location == null) {
                URI uri;
                try {
                    int idx = raw.lastIndexOf(62);
                    uri = new URI("file", null, raw.substring(idx + 1), null);
                }
                catch (URISyntaxException e) {
                    uri = URI.create("file:/unknown-location");
                }
                this.location = new IndexFileLocation(uri, null);
            }
        }
        return this.location;
    }

    @Override
    public ISignificantMacros getSignificantMacros() throws CoreException {
        if (this.sigMacros == null) {
            Database db = this.fLinkage.getDB();
            IString encoded = db.getString(db.getRecPtr(this.record + 60L));
            this.sigMacros = encoded == null ? ISignificantMacros.NONE : new SignificantMacros(encoded.getChars());
        }
        return this.sigMacros;
    }

    @Override
    public boolean hasContent() throws CoreException {
        return this.getTimestamp() != -1L;
    }

    public void convertIncludersToUnresolved() throws CoreException {
        PDOMInclude include = this.getFirstIncludedBy();
        while (include != null) {
            PDOMInclude nextInclude = include.getNextInIncludedBy();
            include.convertToUnresolved();
            include.setNextInIncludedBy(null);
            include.setPrevInIncludedBy(null);
            include = nextInclude;
        }
        this.setFirstIncludedBy(null);
    }

    public long getLastUsingDirectiveRec() throws CoreException {
        return this.fLinkage.getDB().getRecPtr(this.record + 52L);
    }

    public void setLastUsingDirective(long rec) throws CoreException {
        this.fLinkage.getDB().putRecPtr(this.record + 52L, rec);
    }

    @Override
    public ICPPUsingDirective[] getUsingDirectives() throws CoreException {
        return this.fLinkage.getUsingDirectives(this);
    }

    @Override
    public String getReplacementHeader() throws CoreException {
        Database db = this.fLinkage.getDB();
        long rec = db.getRecPtr(this.record + 64L);
        return rec == 0L ? null : db.getString(rec).getString();
    }

    @Override
    public void setReplacementHeader(String replacementHeader) throws CoreException {
        Database db = this.fLinkage.getDB();
        long oldRecord = db.getRecPtr(this.record + 64L);
        if (oldRecord != 0L) {
            db.getString(oldRecord).delete();
        }
        long newRecord = replacementHeader == null ? 0L : db.newString(replacementHeader).getRecord();
        db.putRecPtr(this.record + 64L, newRecord);
    }

    private static IStatus createStatus(String msg) {
        return new Status(4, "org.eclipse.cdt.core", msg, null);
    }

    public String toString() {
        IIndexFileLocation loc = null;
        try {
            loc = this.getLocation();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return loc != null ? loc.toString() : super.toString();
    }

    @Override
    public String toDebugString() {
        StringBuilder buf = new StringBuilder();
        try {
            buf.append("location: ");
            buf.append(this.getLocation());
            buf.append(", timestamp: ");
            buf.append(this.getTimestamp());
            buf.append(", linkageID: ");
            buf.append(this.getLinkageID());
            buf.append(", contentsHash: ");
            buf.append(this.getContentsHash());
            IIndexInclude parsedInContext = this.getParsedInContext();
            if (parsedInContext != null) {
                buf.append(", parsedInContext: ");
                buf.append(parsedInContext.getIncludedBy());
            }
            buf.append(", significantMacros: ");
            buf.append(this.getSignificantMacros());
            buf.append(", names: ");
            buf.append(this.findNames(0, Integer.MAX_VALUE).length);
            buf.append(", macros: ");
            buf.append(this.getMacros().length);
            buf.append(", includes: ");
            buf.append(this.getIncludes().length);
        }
        catch (CoreException e) {
            buf.append(" (incomplete due to " + ((Object)((Object)e)).getClass().getName() + ")");
        }
        return buf.toString();
    }

    public static class Comparator
    implements IBTreeComparator {
        private Database db;

        public Comparator(Database db) {
            this.db = db;
        }

        @Override
        public int compare(long record1, long record2) throws CoreException {
            IString name2;
            IString name1 = this.db.getString(this.db.getRecPtr(record1 + 16L));
            int cmp = name1.compare(name2 = this.db.getString(this.db.getRecPtr(record2 + 16L)), true);
            if (cmp == 0 && (cmp = this.db.get3ByteUnsignedInt(record1 + 20L) - this.db.get3ByteUnsignedInt(record2 + 20L)) == 0) {
                IString sm1 = this.getString(record1 + 60L);
                IString sm2 = this.getString(record2 + 60L);
                cmp = sm1 == null ? (sm2 == null ? 0 : -1) : (sm2 == null ? 1 : sm1.compare(sm2, true));
            }
            return cmp;
        }

        private IString getString(long offset) throws CoreException {
            long rec = this.db.getRecPtr(offset);
            return rec != 0L ? this.db.getString(rec) : null;
        }
    }

    private static class Finder
    implements IBTreeVisitor {
        private static final long[] EMPTY = new long[0];
        private final Database db;
        private final String rawKey;
        private long record;
        private long[] records;
        private final int linkageID;
        private char[] rawSignificantMacros;

        public Finder(Database db, String internalRepresentation, int linkageID, ISignificantMacros sigMacros) {
            this.db = db;
            this.rawKey = internalRepresentation;
            this.linkageID = linkageID;
            char[] cArray = this.rawSignificantMacros = sigMacros == null ? null : sigMacros.encode();
            assert (linkageID >= 0 || this.rawSignificantMacros == null);
        }

        public long[] getRecords() {
            if (this.records == null) {
                if (this.record == 0L) {
                    return EMPTY;
                }
                return new long[]{this.record};
            }
            return this.records;
        }

        @Override
        public int compare(long record) throws CoreException {
            IString name = this.db.getString(this.db.getRecPtr(record + 16L));
            int cmp = name.compare(this.rawKey, true);
            if (cmp == 0 && this.linkageID >= 0 && (cmp = this.db.get3ByteUnsignedInt(record + 20L) - this.linkageID) == 0 && this.rawSignificantMacros != null) {
                IString significantMacrosStr = this.getString(record + 60L);
                cmp = significantMacrosStr != null ? significantMacrosStr.compare(this.rawSignificantMacros, true) : (this.rawSignificantMacros.length > 0 ? -1 : 0);
            }
            return cmp;
        }

        private IString getString(long offset) throws CoreException {
            long rec = this.db.getRecPtr(offset);
            return rec != 0L ? this.db.getString(rec) : null;
        }

        @Override
        public boolean visit(long record) throws CoreException {
            if (this.rawSignificantMacros != null) {
                this.record = record;
                return false;
            }
            if (this.record == 0L) {
                this.record = record;
            } else if (this.records == null) {
                this.records = new long[]{this.record, record};
            } else {
                long[] cpy = new long[this.records.length + 1];
                System.arraycopy(this.records, 0, cpy, 0, this.records.length);
                cpy[cpy.length - 1] = record;
                this.records = cpy;
            }
            return true;
        }

        public long getRecord() {
            return this.record;
        }
    }
}

