/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.core;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionChangeListener;
import org.eclipse.remote.core.IRemoteConnectionControlService;
import org.eclipse.remote.core.IRemoteConnectionPropertyService;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.core.RemoteConnectionChangeEvent;
import org.eclipse.remote.core.exception.ConnectionExistsException;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.internal.core.RemoteConnectionType;
import org.eclipse.remote.internal.core.RemoteConnectionWorkingCopy;
import org.eclipse.remote.internal.core.RemoteCorePlugin;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class RemoteConnection
implements IRemoteConnection {
    private final RemoteConnectionType connectionType;
    private String name;
    private final Map<Class<? extends IRemoteConnection.Service>, IRemoteConnection.Service> servicesMap = new HashMap<Class<? extends IRemoteConnection.Service>, IRemoteConnection.Service>();
    private final ListenerList fListeners = new ListenerList();
    static final String EMPTY_STRING = "";

    public RemoteConnection(RemoteConnectionType connectionType, String name) {
        this.connectionType = connectionType;
        this.name = name;
    }

    @Override
    public IRemoteConnectionType getConnectionType() {
        return this.connectionType;
    }

    @Override
    public <T extends IRemoteConnection.Service> T getService(Class<T> service) {
        IRemoteConnection.Service obj = this.servicesMap.get(service);
        if (obj == null && (obj = this.connectionType.getConnectionService(this, service)) != null) {
            this.servicesMap.put(service, obj);
        }
        return (T)obj;
    }

    @Override
    public <T extends IRemoteConnection.Service> boolean hasService(Class<T> service) {
        return this.servicesMap.get(service.getName()) != null || this.connectionType.hasConnectionService(service);
    }

    @Override
    public String getName() {
        return this.name;
    }

    void rename(String newName) throws ConnectionExistsException {
        try {
            if (this.connectionType.getPreferenceNode().nodeExists(newName)) {
                throw new ConnectionExistsException(newName);
            }
            Preferences newPrefs = this.connectionType.getPreferenceNode().node(newName);
            Preferences oldPrefs = this.getPreferences();
            String[] stringArray = oldPrefs.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                newPrefs.put(key, oldPrefs.get(key, null));
                ++n2;
            }
            oldPrefs.removeNode();
        }
        catch (BackingStoreException e) {
            RemoteCorePlugin.log(e);
        }
        this.name = newName;
    }

    Preferences getPreferences() {
        try {
            return this.connectionType.getPreferenceNode().node(URLEncoder.encode(this.name, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    ISecurePreferences getSecurePreferences() {
        try {
            return this.connectionType.getSecurePreferencesNode().node(URLEncoder.encode(this.name, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getAttribute(String key) {
        return this.getPreferences().get(key, EMPTY_STRING);
    }

    @Override
    public String getSecureAttribute(String key) {
        try {
            return this.getSecurePreferences().get(key, EMPTY_STRING);
        }
        catch (StorageException e) {
            RemoteCorePlugin.log(e);
            return EMPTY_STRING;
        }
    }

    @Override
    public IRemoteConnectionWorkingCopy getWorkingCopy() {
        return new RemoteConnectionWorkingCopy(this);
    }

    @Override
    public String getProperty(String key) {
        IRemoteConnectionPropertyService propertyService = this.getService(IRemoteConnectionPropertyService.class);
        if (propertyService != null) {
            return propertyService.getProperty(key);
        }
        return null;
    }

    @Override
    public void open(IProgressMonitor monitor) throws RemoteConnectionException {
        IRemoteConnectionControlService controlService = this.getService(IRemoteConnectionControlService.class);
        if (controlService != null) {
            controlService.open(monitor);
        }
    }

    @Override
    public void close() {
        IRemoteConnectionControlService controlService = this.getService(IRemoteConnectionControlService.class);
        if (controlService != null) {
            controlService.close();
        }
    }

    @Override
    public boolean isOpen() {
        IRemoteConnectionControlService controlService = this.getService(IRemoteConnectionControlService.class);
        if (controlService != null) {
            return controlService.isOpen();
        }
        return true;
    }

    @Override
    public void addConnectionChangeListener(IRemoteConnectionChangeListener listener) {
        this.fListeners.add((Object)listener);
    }

    @Override
    public void removeConnectionChangeListener(IRemoteConnectionChangeListener listener) {
        this.fListeners.remove((Object)listener);
    }

    @Override
    public void fireConnectionChangeEvent(int type) {
        RemoteConnectionChangeEvent event = new RemoteConnectionChangeEvent(this, type);
        Object[] objectArray = this.fListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IRemoteConnectionChangeListener)listener).connectionChanged(event);
            ++n2;
        }
        this.connectionType.getRemoteServicesManager().fireRemoteConnectionChangeEvent(event);
    }

    public String toString() {
        return String.valueOf(this.name) + " - " + this.connectionType.getName();
    }
}

