/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gprof.dialog;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.linuxtools.internal.gprof.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class OpenGmonDialog
extends Dialog {
    private Text binText;
    private String binValue;
    private Label errorLabel;
    private boolean binaryValid;
    private final String defaultValue;
    private final IPath gmonFile;

    public OpenGmonDialog(Shell parentShell, String binPath, IPath gmonFile) {
        super(parentShell);
        this.gmonFile = gmonFile;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.defaultValue = binPath;
    }

    public String getBinaryFile() {
        return this.binValue;
    }

    protected Control createContents(Composite parent) {
        Control composite = super.createContents(parent);
        this.validateBinary();
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.OpenGmonDialog_GMON_BINARY_FILE);
        Composite composite = (Composite)super.createDialogArea(parent);
        Group c = new Group(composite, 0);
        c.setText(Messages.OpenGmonDialog_BINARY_FILE);
        c.setToolTipText(Messages.OpenGmonDialog_PLEASE_ENTER_BINARY_FILE_FULL_MSG);
        GridLayout layout = new GridLayout(2, false);
        c.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        c.setLayoutData((Object)data);
        Label binLabel = new Label((Composite)c, 0);
        binLabel.setText(Messages.OpenGmonDialog_PLEASE_ENTER_BINARY_FILE_FULL_MSG);
        data = new GridData();
        data.horizontalSpan = 2;
        binLabel.setLayoutData((Object)data);
        this.binText = new Text((Composite)c, 2048);
        this.binText.setText(this.defaultValue);
        data = new GridData(768);
        data.widthHint = 200;
        this.binText.setLayoutData((Object)data);
        this.binText.addModifyListener((ModifyListener)new BinaryModifyListener());
        Composite cbBin = new Composite((Composite)c, 0);
        data = new GridData(128);
        cbBin.setLayoutData((Object)data);
        cbBin.setLayout((Layout)new GridLayout(2, true));
        Button binBrowseWorkspaceButton = new Button(cbBin, 8);
        binBrowseWorkspaceButton.setText(Messages.OpenGmonDialog_WORKSPACE);
        binBrowseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent sev) {
                OpenGmonDialog.this.handleBrowseWorkspace(Messages.OpenGmonDialog_OPEN_BINARY_FILE, OpenGmonDialog.this.binText);
            }
        });
        Button binBrowseFileSystemButton = new Button(cbBin, 8);
        binBrowseFileSystemButton.setText(Messages.OpenGmonDialog_FILE_SYSTEM);
        binBrowseFileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent sev) {
                OpenGmonDialog.this.handleBrowse(Messages.OpenGmonDialog_OPEN_BINARY_FILE, OpenGmonDialog.this.binText);
            }
        });
        this.errorLabel = new Label(composite, 0);
        data = new GridData(768);
        data.horizontalSpan = 3;
        this.errorLabel.setLayoutData((Object)data);
        this.errorLabel.setForeground(this.getShell().getDisplay().getSystemColor(3));
        c.layout();
        return composite;
    }

    private void validateBinary() {
        this.binValue = this.binText.getText();
        IStringVariableManager mgr = VariablesPlugin.getDefault().getStringVariableManager();
        try {
            this.binValue = mgr.performStringSubstitution(this.binValue, false);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        File f = new File(this.binValue);
        if (!f.exists()) {
            this.binaryValid = false;
            this.getButton(0).setEnabled(false);
            if (!this.binValue.equals("")) {
                this.errorLabel.setText("\"" + this.binText.getText() + "\" " + Messages.OpenGmonDialog_DOES_NOT_EXIST);
            } else {
                this.errorLabel.setText(Messages.OpenGmonDialog_PLEASE_ENTER_BINARY_FILE);
            }
            return;
        }
        this.binaryValid = true;
        this.getButton(0).setEnabled(this.binaryValid);
        this.errorLabel.setText("");
    }

    private void handleBrowseWorkspace(String msg, Text text) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle(msg);
        dialog.setMessage(msg);
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setAllowMultiple(false);
        IContainer c = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(this.gmonFile);
        if (c != null) {
            dialog.setInitialSelection((Object)c.getProject());
        }
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length != 1) {
                    return new Status(4, "org.eclipse.linuxtools.gprof", 0, "", null);
                }
                if (!(selection[0] instanceof IFile)) {
                    return new Status(4, "org.eclipse.linuxtools.gprof", 0, "", null);
                }
                return new Status(0, "org.eclipse.linuxtools.gprof", 0, "", null);
            }
        });
        if (dialog.open() == 0) {
            IResource resource = (IResource)dialog.getFirstResult();
            text.setText("${resource_loc:" + resource.getFullPath() + "}");
        }
    }

    private void handleBrowse(String msg, Text text) {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setText(msg);
        String t = text.getText();
        IStringVariableManager mgr = VariablesPlugin.getDefault().getStringVariableManager();
        try {
            t = mgr.performStringSubstitution(t, false);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        File f = new File(t);
        t = f.getParent();
        if (t == null || t.length() == 0) {
            t = this.gmonFile.removeLastSegments(1).toOSString();
        }
        dialog.setFilterPath(t);
        String s = dialog.open();
        if (s != null) {
            text.setText(s);
        }
    }

    private class BinaryModifyListener
    implements ModifyListener {
        private BinaryModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            OpenGmonDialog.this.validateBinary();
        }
    }
}

