/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.command;

import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.command.MICommand;
import org.eclipse.cdt.debug.mi.core.output.MIDataDisassembleInfo;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;

public class MIDataDisassemble
extends MICommand {
    private static final int MIN_MODE = 0;
    private static final int MAX_MODE = 3;
    private static final String MODE_OUT_OF_RANGE = "Mode out of range: ";

    public MIDataDisassemble(String miVersion, String start, String end, boolean mode) {
        this(miVersion, start, end, mode ? 1 : 0);
    }

    public MIDataDisassemble(String miVersion, String start, String end, int mode) {
        super(miVersion, "-data-disassemble");
        this.setOptions(new String[]{"-s", start, "-e", end});
        if (mode < 0 || mode > 3) {
            throw new IllegalArgumentException(MODE_OUT_OF_RANGE + mode);
        }
        this.setParameters(new String[]{Integer.toString(mode)});
    }

    public MIDataDisassemble(String miVersion, String file, int linenum, int lines, boolean mode) {
        this(miVersion, file, linenum, lines, mode ? 1 : 0);
    }

    public MIDataDisassemble(String miVersion, String file, int linenum, int lines, int mode) {
        super(miVersion, "-data-disassemble");
        this.setOptions(new String[]{"-f", file, "-l", Integer.toString(linenum), "-n", Integer.toString(lines)});
        if (mode < 0 || mode > 3) {
            throw new IllegalArgumentException(MODE_OUT_OF_RANGE + mode);
        }
        this.setParameters(new String[]{Integer.toString(mode)});
    }

    public MIDataDisassembleInfo getMIDataDisassembleInfo() throws MIException {
        return (MIDataDisassembleInfo)this.getMIInfo();
    }

    @Override
    public MIInfo getMIInfo() throws MIException {
        MIDataDisassembleInfo info = null;
        MIOutput out = this.getMIOutput();
        if (out != null && (info = new MIDataDisassembleInfo(out)).isError()) {
            this.throwMIException(info, out);
        }
        return info;
    }

    @Override
    protected String parametersToString() {
        String[] parameters = this.getParameters();
        if (parameters != null && parameters.length > 0) {
            return "-- " + parameters[0];
        }
        return new String();
    }
}

