/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.command.factories;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.factories.CommandFactoriesMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CommandFactoryDescriptor {
    private static final String IDENTIFIER = "id";
    private static final String CLASS = "class";
    private static final String NAME = "name";
    private static final String DEBUGGER_ID = "debuggerID";
    private static final String MI_VERSIONS = "miVersions";
    private static final String DESCRIPTION = "description";
    private static final String PLATFORMS = "platforms";
    private IConfigurationElement fElement;
    private Set fPlatforms;
    private String[] fMIVersions = new String[0];

    protected CommandFactoryDescriptor(IConfigurationElement element) {
        this.fElement = element;
    }

    protected IConfigurationElement getConfigurationElement() {
        return this.fElement;
    }

    public String getIdentifier() {
        return this.getConfigurationElement().getAttribute(IDENTIFIER);
    }

    public String getName() {
        return this.getConfigurationElement().getAttribute(NAME);
    }

    public String getDebuggerIdentifier() {
        return this.getConfigurationElement().getAttribute(DEBUGGER_ID);
    }

    public String[] getMIVersions() {
        if (this.fMIVersions.length == 0) {
            String miVersions = this.getConfigurationElement().getAttribute(MI_VERSIONS);
            if (miVersions == null || miVersions.trim().length() == 0) {
                miVersions = "mi";
            }
            StringTokenizer tokenizer = new StringTokenizer(miVersions, ",");
            ArrayList<String> list = new ArrayList<String>(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                list.add(tokenizer.nextToken().trim());
            }
            this.fMIVersions = list.toArray(new String[list.size()]);
        }
        return this.fMIVersions;
    }

    public String getDescription() {
        String desc = this.getConfigurationElement().getAttribute(DESCRIPTION);
        if (this.isEmpty(desc)) {
            desc = "";
        }
        return desc;
    }

    protected Set getSupportedPlatforms() {
        if (this.fPlatforms == null) {
            String platforms = this.getConfigurationElement().getAttribute(PLATFORMS);
            if (platforms == null) {
                return new HashSet(0);
            }
            StringTokenizer tokenizer = new StringTokenizer(platforms, ",");
            this.fPlatforms = new HashSet(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                this.fPlatforms.add(tokenizer.nextToken().trim());
            }
        }
        return this.fPlatforms;
    }

    public boolean supportsPlatform(String platform) {
        Set all = this.getSupportedPlatforms();
        return all.isEmpty() || all.contains("*") || all.contains(platform);
    }

    public String[] getSupportedPlatformList() {
        Set platforms = this.getSupportedPlatforms();
        return platforms.toArray(new String[platforms.size()]);
    }

    public CommandFactory getCommandFactory() throws CoreException {
        Object clazz = this.getConfigurationElement().createExecutableExtension(CLASS);
        if (clazz instanceof CommandFactory) {
            return (CommandFactory)clazz;
        }
        throw new CoreException((IStatus)new Status(4, MIPlugin.getUniqueIdentifier(), -1, CommandFactoriesMessages.getString("CommandFactoryDescriptor.0"), null));
    }

    private boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }
}

