/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.structures;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDEPlugin;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.Localization;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.preferences.PreferenceConstants;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.ManpageCacher;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.Messages;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.TapsetItemType;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.TreeSettings;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.tparsers.FunctionParser;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.tparsers.ProbeParser;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.tparsers.SharedParser;
import org.eclipse.linuxtools.systemtap.structures.TreeNode;
import org.eclipse.linuxtools.systemtap.ui.consolelog.internal.ConsoleLogPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public final class TapsetLibrary {
    private static FunctionParser functionParser = FunctionParser.getInstance();
    private static ProbeParser probeParser = ProbeParser.getInstance();
    private static boolean initialized = false;
    private static final IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if (property.equals("TapsetPreference")) {
                TapsetLibrary.applyTapsetChanges((String)event.getOldValue(), (String)event.getNewValue());
            } else if (property.equals(PreferenceConstants.P_ENV.SYSTEMTAP_TAPSET.toPrefKey()) || property.equals("RemoteProbes")) {
                TapsetLibrary.runStapParser();
            } else if (property.equals("UseStoredTreePreference")) {
                if (event.getNewValue().equals(false)) {
                    TreeSettings.deleteTrees();
                    TapsetLibrary.runStapParser();
                } else if (TapsetLibrary.isReady()) {
                    TreeSettings.setTrees(TapsetLibrary.getFunctions(), TapsetLibrary.getProbes());
                }
            }
        }
    };
    private static final IPropertyChangeListener credentialChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            TapsetLibrary.runStapParser();
        }
    };
    private static JobChangeAdapter parseCompletionListener = new JobChangeAdapter(){

        public void done(IJobChangeEvent event) {
            if (event.getResult().isOK()) {
                if (TapsetLibrary.isReady() && IDEPlugin.getDefault().getPreferenceStore().getBoolean("UseStoredTreePreference")) {
                    TreeSettings.setTrees(TapsetLibrary.getFunctions(), TapsetLibrary.getProbes());
                }
                if (event.getJob() instanceof ProbeParser) {
                    ManpageCacher.clear(TapsetItemType.PROBE, TapsetItemType.PROBEVAR);
                } else {
                    ManpageCacher.clear(TapsetItemType.FUNCTION);
                }
            }
        }
    };

    public static TreeNode getProbes() {
        return probeParser.getTree();
    }

    public static TreeNode getStaticProbes() {
        return TapsetLibrary.getProbes().getChildByName(Messages.ProbeParser_staticProbes);
    }

    public static TreeNode getProbeAliases() {
        return TapsetLibrary.getProbes().getChildByName(Messages.ProbeParser_aliasProbes);
    }

    public static TreeNode[] getProbeCategoryNodes() {
        return new TreeNode[]{TapsetLibrary.getStaticProbes(), TapsetLibrary.getProbeAliases()};
    }

    public static TreeNode getFunctions() {
        return functionParser.getTree();
    }

    public static synchronized void init() {
        if (!initialized) {
            initialized = true;
            IPreferenceStore preferenceStore = IDEPlugin.getDefault().getPreferenceStore();
            preferenceStore.addPropertyChangeListener(propertyChangeListener);
            ConsoleLogPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(credentialChangeListener);
            functionParser.addJobChangeListener((IJobChangeListener)parseCompletionListener);
            probeParser.addJobChangeListener((IJobChangeListener)parseCompletionListener);
            if (preferenceStore.getBoolean("UseStoredTreePreference") && TapsetLibrary.isTreeFileCurrent()) {
                TapsetLibrary.readTreeFile();
            } else {
                TapsetLibrary.runStapParser();
            }
        }
    }

    private static boolean isReady() {
        IStatus probeResult = probeParser.getLatestResult();
        IStatus funcResult = functionParser.getLatestResult();
        return probeResult != null && funcResult != null && probeResult.isOK() && funcResult.isOK();
    }

    public static void runStapParser() {
        TapsetLibrary.stop();
        SharedParser.getInstance().clearTapsetContents();
        functionParser.schedule();
        probeParser.schedule();
    }

    private static void applyTapsetChanges(String oldTapsets, String newTapsets) {
        List<String> oldList = Arrays.asList(oldTapsets.split(File.pathSeparator));
        List<String> newList = Arrays.asList(newTapsets.split(File.pathSeparator));
        ArrayList<String> additions = new ArrayList<String>(newList);
        additions.removeAll(oldList);
        additions.remove("");
        ArrayList<String> deletions = new ArrayList<String>(oldList);
        deletions.removeAll(newList);
        deletions.remove("");
        String[] additionArray = additions.toArray(new String[additions.size()]);
        String[] deletionArray = deletions.toArray(new String[deletions.size()]);
        SharedParser.getInstance().clearTapsetContents();
        probeParser.runUpdate(additionArray, deletionArray);
        functionParser.runUpdate(additionArray, deletionArray);
    }

    public static void readTreeFile() {
        functionParser.setTree(TreeSettings.getFunctionTree());
        probeParser.setTree(TreeSettings.getProbeTree());
    }

    private static boolean isTreeFileCurrent() {
        long treesDate = TreeSettings.getTreeFileDate();
        File f = TapsetLibrary.getTapsetLocation();
        if (f == null || !TapsetLibrary.checkIsCurrentFolder(treesDate, f)) {
            return false;
        }
        IPreferenceStore p = IDEPlugin.getDefault().getPreferenceStore();
        String[] tapsets = p.getString("TapsetPreference").split(File.pathSeparator);
        if (!tapsets[0].trim().isEmpty()) {
            int i = 0;
            while (i < tapsets.length) {
                f = new File(tapsets[i]);
                if (!f.exists() || f.lastModified() > treesDate || f.canRead() && !TapsetLibrary.checkIsCurrentFolder(treesDate, f)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static File getTapsetLocation() {
        final IPreferenceStore p = IDEPlugin.getDefault().getPreferenceStore();
        File f = TapsetLibrary.attemptToGetFileFrom(p.getString(PreferenceConstants.P_ENV.SYSTEMTAP_TAPSET.toPrefKey()));
        if (f != null) {
            return f;
        }
        f = TapsetLibrary.attemptToGetFileFrom(System.getenv(PreferenceConstants.P_ENV.SYSTEMTAP_TAPSET.toEnvKey()));
        if (f != null) {
            return f;
        }
        f = TapsetLibrary.attemptToGetFileFrom("/usr/share/systemtap/tapset");
        if (f != null) {
            return f;
        }
        f = TapsetLibrary.attemptToGetFileFrom("/usr/local/share/systemtap/tapset");
        if (f != null) {
            return f;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                InputDialog i = new InputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Localization.getString("TapsetBrowserView.TapsetLocation"), Localization.getString("TapsetBrowserView.WhereDefaultTapset"), null, null);
                i.open();
                String path = i.getValue();
                if (path != null) {
                    p.setValue(PreferenceConstants.P_ENV.SYSTEMTAP_TAPSET.toPrefKey(), i.getValue());
                }
            }
        });
        return null;
    }

    private static File attemptToGetFileFrom(String path) {
        if (path == null) {
            return null;
        }
        String trimmed = path.trim();
        if (trimmed.isEmpty()) {
            return null;
        }
        File f = new File(trimmed);
        return f.exists() ? f : null;
    }

    private static boolean checkIsCurrentFolder(long time, File folder) {
        File[] fs = folder.listFiles();
        int i = 0;
        while (i < fs.length) {
            if (fs[i].lastModified() > time) {
                return false;
            }
            if (fs[i].isDirectory() && fs[i].canRead() && !TapsetLibrary.checkIsCurrentFolder(time, fs[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void stop() {
        functionParser.cancel();
        try {
            functionParser.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        probeParser.cancel();
        try {
            probeParser.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

