/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils;

import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class Urls {
    public static String mangle(URL url) {
        return Urls.mangle(url.toExternalForm());
    }

    public static String mangle(String url) {
        return url.replaceAll("\\W", "_");
    }

    public static URL toUrl(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static URI toUri(URL url) {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static Optional<URI> parseURI(String uriString) {
        try {
            return Optional.of((Object)new URI(uriString));
        }
        catch (URISyntaxException uRISyntaxException) {
            return Optional.absent();
        }
    }

    public static boolean isUriProtocolSupported(URI uri, List<String> protocols) {
        for (String protocol : protocols) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)protocol, (CharSequence)uri.getScheme())) continue;
            return true;
        }
        return false;
    }

    private Urls() {
    }
}

