/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.launcher;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.junit.JUnitMessages;
import org.eclipse.jdt.internal.junit.launcher.ITestFinder;
import org.eclipse.jdt.internal.junit.util.CoreTestSearchEngine;

public class JUnit4TestFinder
implements ITestFinder {
    public void findTestsInContainer(IJavaElement element, Set result, IProgressMonitor pm) throws CoreException {
        if (element == null || result == null) {
            throw new IllegalArgumentException();
        }
        if (element instanceof IType && this.internalIsTest((IType)element, pm)) {
            result.add(element);
            return;
        }
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        try {
            pm.beginTask(JUnitMessages.JUnit4TestFinder_searching_description, 4);
            IRegion region = CoreTestSearchEngine.getRegion(element);
            ITypeHierarchy hierarchy = JavaCore.newTypeHierarchy((IRegion)region, null, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            IType[] allClasses = hierarchy.getAllClasses();
            HashSet candidates = new HashSet(allClasses.length);
            AnnotationSearchRequestor requestor = new AnnotationSearchRequestor(hierarchy, candidates);
            IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])allClasses, (int)1);
            int matchRule = 8;
            SearchPattern runWithPattern = SearchPattern.createPattern((String)Annotation.RUN_WITH.getName(), (int)8, (int)65536, (int)matchRule);
            SearchPattern testPattern = SearchPattern.createPattern((String)Annotation.TEST.getName(), (int)8, (int)65536, (int)matchRule);
            SearchPattern annotationsPattern = SearchPattern.createOrPattern((SearchPattern)runWithPattern, (SearchPattern)testPattern);
            SearchParticipant[] searchParticipants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
            new SearchEngine().search(annotationsPattern, searchParticipants, scope, (SearchRequestor)requestor, (IProgressMonitor)new SubProgressMonitor(pm, 2));
            Iterator iterator = candidates.iterator();
            while (iterator.hasNext()) {
                IType curr = (IType)iterator.next();
                if (!CoreTestSearchEngine.isAccessibleClass(curr) || Flags.isAbstract((int)curr.getFlags()) || !region.contains((IJavaElement)curr)) continue;
                result.add(curr);
            }
            IType testInterface = element.getJavaProject().findType("junit.framework.Test");
            if (testInterface != null) {
                CoreTestSearchEngine.findTestImplementorClasses(hierarchy, testInterface, region, result);
            }
            CoreTestSearchEngine.findSuiteMethods(element, result, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        }
        finally {
            pm.done();
        }
    }

    public boolean isTest(IType type) throws JavaModelException {
        return this.internalIsTest(type, null);
    }

    private boolean internalIsTest(IType type, IProgressMonitor monitor) throws JavaModelException {
        if (CoreTestSearchEngine.isAccessibleClass(type)) {
            ITypeBinding binding;
            if (CoreTestSearchEngine.hasSuiteMethod(type)) {
                return true;
            }
            ASTParser parser = ASTParser.newParser((int)4);
            if (type.getCompilationUnit() != null) {
                parser.setSource(type.getCompilationUnit());
            } else {
                if (!JUnit4TestFinder.isAvailable(type.getSourceRange())) {
                    parser.setProject(type.getJavaProject());
                    IBinding[] bindings = parser.createBindings(new IJavaElement[]{type}, monitor);
                    if (bindings.length == 1 && bindings[0] instanceof ITypeBinding) {
                        ITypeBinding binding2 = (ITypeBinding)bindings[0];
                        return this.isTest(binding2);
                    }
                    return false;
                }
                parser.setSource(type.getClassFile());
            }
            parser.setFocalPosition(0);
            parser.setResolveBindings(true);
            CompilationUnit root = (CompilationUnit)parser.createAST(monitor);
            ASTNode node = root.findDeclaringNode(type.getKey());
            if (node instanceof TypeDeclaration && (binding = ((TypeDeclaration)node).resolveBinding()) != null) {
                return this.isTest(binding);
            }
        }
        return false;
    }

    private static boolean isAvailable(ISourceRange range) {
        return range != null && range.getOffset() != -1;
    }

    private boolean isTest(ITypeBinding binding) {
        if (Modifier.isAbstract((int)binding.getModifiers())) {
            return false;
        }
        if (Annotation.RUN_WITH.annotatesTypeOrSuperTypes(binding) || Annotation.TEST.annotatesAtLeastOneMethod(binding)) {
            return true;
        }
        return CoreTestSearchEngine.isTestImplementor(binding);
    }

    private static class Annotation {
        private static final Annotation RUN_WITH = new Annotation("org.junit.runner.RunWith");
        private static final Annotation TEST = new Annotation("org.junit.Test");
        private final String fName;

        private Annotation(String name) {
            this.fName = name;
        }

        public String getName() {
            return this.fName;
        }

        private boolean annotates(IAnnotationBinding[] annotations) {
            int i = 0;
            while (i < annotations.length) {
                ITypeBinding annotationType = annotations[i].getAnnotationType();
                if (annotationType != null && annotationType.getQualifiedName().equals(this.fName)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public boolean annotatesTypeOrSuperTypes(ITypeBinding type) {
            while (type != null) {
                if (this.annotates(type.getAnnotations())) {
                    return true;
                }
                type = type.getSuperclass();
            }
            return false;
        }

        public boolean annotatesAtLeastOneMethod(ITypeBinding type) {
            while (type != null) {
                IMethodBinding[] declaredMethods = type.getDeclaredMethods();
                int i = 0;
                while (i < declaredMethods.length) {
                    IMethodBinding curr = declaredMethods[i];
                    if (this.annotates(curr.getAnnotations())) {
                        return true;
                    }
                    ++i;
                }
                type = type.getSuperclass();
            }
            return false;
        }
    }

    private static class AnnotationSearchRequestor
    extends SearchRequestor {
        private final Collection fResult;
        private final ITypeHierarchy fHierarchy;

        public AnnotationSearchRequestor(ITypeHierarchy hierarchy, Collection result) {
            this.fHierarchy = hierarchy;
            this.fResult = result;
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            Object element;
            if (match.getAccuracy() == 0 && !match.isInsideDocComment() && ((element = match.getElement()) instanceof IType || element instanceof IMethod)) {
                IMember member = (IMember)element;
                IType type = member.getElementType() == 7 ? (IType)member : member.getDeclaringType();
                this.addTypeAndSubtypes(type);
            }
        }

        private void addTypeAndSubtypes(IType type) {
            if (this.fResult.add(type)) {
                IType[] subclasses = this.fHierarchy.getSubclasses(type);
                int i = 0;
                while (i < subclasses.length) {
                    this.addTypeAndSubtypes(subclasses[i]);
                    ++i;
                }
            }
        }
    }
}

