/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.coordinates;

import com.google.common.base.Joiner;
import java.util.Objects;
import org.eclipse.recommenders.coordinates.Coordinates;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Versions;

public final class ProjectCoordinate {
    public static final ProjectCoordinate UNKNOWN = new ProjectCoordinate("UNKNOWN", "UNKNOWN", "0.0.0");
    private final String groupId;
    private final String artifactId;
    private final String version;

    public ProjectCoordinate(String groupId, String artifactId, String version) {
        Checks.ensureIsTrue((boolean)Coordinates.isValidId(groupId));
        Checks.ensureIsTrue((boolean)Coordinates.isValidId(artifactId));
        Checks.ensureIsTrue((boolean)Versions.isValidVersion((String)version));
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.version);
    }

    public boolean equals(Object other) {
        if (!(other instanceof ProjectCoordinate)) {
            return false;
        }
        ProjectCoordinate that = (ProjectCoordinate)other;
        return Objects.equals(this.artifactId, that.artifactId) && Objects.equals(this.groupId, that.groupId) && Objects.equals(this.version, that.version);
    }

    public String toString() {
        return Joiner.on((char)':').join((Object)this.getGroupId(), (Object)this.getArtifactId(), new Object[]{this.getVersion()});
    }

    public static ProjectCoordinate valueOf(String coord) {
        String[] segments = coord.split(":");
        Checks.ensureIsInRange((double)segments.length, (double)3.0, (double)3.0, (String)"Coordiante '%s' has invalid number of segments: %d", (Object[])new Object[]{coord, segments.length});
        return new ProjectCoordinate(segments[0], segments[1], segments[2]);
    }
}

