/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.variable;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.variable.AbstractSimpleVariableSupport;
import org.eclipse.wb.internal.core.utils.StringUtilities;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NamesManager {
    public static final String NAME_PARAMETER = "variable.name";
    public static final String ACRONYM_PARAMETER = "variable.acronym";
    private static final String TYPE_DESCRIPTION_ID = "description";

    private NamesManager() {
    }

    public static void renameForText(AbstractSimpleVariableSupport variableSupport, GenericProperty property, String text) throws Exception {
        JavaInfo javaInfo = variableSupport.getJavaInfo();
        IPreferenceStore preferences = javaInfo.getDescription().getToolkit().getPreferences();
        int renameMode = preferences.getInt("textVariable.mode");
        if (renameMode == 2) {
            return;
        }
        if (renameMode == 1 && !NamesManager.isDefaultName(javaInfo, variableSupport.getName())) {
            return;
        }
        String newName = NamesManager.getNameForText(javaInfo, text);
        if (newName == null) {
            return;
        }
        newName = variableSupport.decorateTextName(newName);
        newName = javaInfo.getEditor().getUniqueVariableName(-1, newName, null);
        if (!variableSupport.getName().equals(newName)) {
            variableSupport.setName(newName);
        }
    }

    private static boolean isDefaultName(JavaInfo javaInfo, String name) {
        String baseName = StringUtils.substringBefore((String)name, (String)"_").toLowerCase();
        return NamesManager.getName(javaInfo).equalsIgnoreCase(baseName);
    }

    private static String getNameForText(JavaInfo javaInfo, String text) {
        String[] strings;
        ComponentDescription description = javaInfo.getDescription();
        IPreferenceStore preferences = description.getToolkit().getPreferences();
        String qualifiedClassName = ReflectionUtils.getCanonicalName(description.getComponentClass());
        String shortClassName = CodeUtils.getShortClass(qualifiedClassName);
        String classNameForVariable = StringUtilities.stripLeadingUppercaseChars((String)shortClassName, (int)1);
        String textPart = text.toLowerCase();
        textPart = WordUtils.capitalize((String)textPart);
        textPart = StringUtilities.stripHtml((String)textPart);
        int wordsLimit = preferences.getInt("textVariable.wordsLimit");
        if (wordsLimit > 0 && (strings = StringUtils.split((String)textPart)).length > wordsLimit) {
            textPart = "";
            int i = 0;
            while (i < wordsLimit) {
                textPart = String.valueOf(textPart) + strings[i];
                ++i;
            }
        }
        if ((textPart = StringUtilities.removeNonLatinCharacters((String)textPart)).length() == 0) {
            return null;
        }
        Map valueMap = Maps.newTreeMap();
        valueMap.put("class_name", classNameForVariable);
        valueMap.put("text", textPart);
        valueMap.put("default_name", NamesManager.getName(javaInfo));
        valueMap.put("class_acronym", NamesManager.getAcronym(javaInfo));
        String template = preferences.getString("textVariable.template");
        String name = StrSubstitutor.replace((Object)template, (Map)valueMap);
        name = StringUtils.uncapitalize((String)name);
        return name;
    }

    public static String validate(String template) {
        Map valueMap = Maps.newTreeMap();
        valueMap.put("class_name", "");
        valueMap.put("text", "");
        valueMap.put("default_name", "");
        valueMap.put("class_acronym", "");
        String evaluated = StrSubstitutor.replace((Object)template, (Map)valueMap);
        if (evaluated.indexOf("$") != -1) {
            return evaluated;
        }
        return null;
    }

    public static String getName(JavaInfo javaInfo) {
        ComponentDescription description = javaInfo.getDescription();
        ComponentNameDescription nameDescription = NamesManager.getNameDescription(description);
        if (nameDescription != null) {
            return nameDescription.getName();
        }
        String name = JavaInfoUtils.getParameter(javaInfo, NAME_PARAMETER);
        if (!StringUtils.isEmpty((String)name)) {
            return name;
        }
        String qualifiedClassName = ReflectionUtils.getCanonicalName(description.getComponentClass());
        return NamesManager.getDefaultName(qualifiedClassName);
    }

    public static String getDefaultName(String qualifiedClassName) {
        String name = CodeUtils.getShortClass(qualifiedClassName);
        boolean onlyUpper = true;
        int i = 0;
        while (i < name.length()) {
            onlyUpper &= Character.isUpperCase(name.charAt(i));
            ++i;
        }
        if (onlyUpper) {
            return name.toLowerCase();
        }
        if (Character.isLowerCase(name.charAt(0))) {
            return String.valueOf(name) + '_';
        }
        int index = 0;
        int maxIndex = name.length() - 1;
        while (index < maxIndex && Character.isUpperCase(name.charAt(index + 1))) {
            ++index;
        }
        name = name.substring(index);
        return StringUtils.uncapitalize((String)name);
    }

    public static String getAcronym(JavaInfo javaInfo) {
        ComponentDescription description = javaInfo.getDescription();
        ComponentNameDescription nameDescription = NamesManager.getNameDescription(description);
        if (nameDescription != null) {
            return nameDescription.getAcronym();
        }
        String acronym = JavaInfoUtils.getParameter(javaInfo, ACRONYM_PARAMETER);
        if (!StringUtils.isEmpty((String)acronym)) {
            return acronym;
        }
        String qualifiedClassName = ReflectionUtils.getCanonicalName(description.getComponentClass());
        return NamesManager.getDefaultAcronym(qualifiedClassName);
    }

    private static String getDefaultAcronym(String qualifiedClassName) {
        String shortClassName = CodeUtils.getShortClass(qualifiedClassName);
        String acronym = StringUtilities.stripLeadingUppercaseChars((String)shortClassName, (int)1).toLowerCase();
        acronym = StringUtils.replaceChars((String)acronym, (String)"aeiouy", null);
        if ((acronym = StringUtilities.removeDuplicateCharacters((String)acronym)).length() == 0) {
            return shortClassName;
        }
        return acronym;
    }

    public static boolean shouldUseFieldInsteadOfLocal(ComponentDescription description) {
        ComponentNameDescription nameDescription = NamesManager.getNameDescription(description);
        if (nameDescription != null) {
            return nameDescription.isAsField();
        }
        return false;
    }

    public static ComponentNameDescription getDefaultNameDescription(String qualifiedClassName) {
        String name = NamesManager.getDefaultName(qualifiedClassName);
        String acronym = NamesManager.getDefaultAcronym(qualifiedClassName);
        return new ComponentNameDescription(qualifiedClassName, name, acronym);
    }

    private static ComponentNameDescription getNameDescription(ComponentDescription description) {
        if (description == null || description.getComponentClass() == null) {
            return null;
        }
        String qualifiedClassName = ReflectionUtils.getCanonicalName(description.getComponentClass());
        return NamesManager.getNameDescription(description.getToolkit(), qualifiedClassName);
    }

    public static ComponentNameDescription getNameDescription(ToolkitDescription toolkit, String componentClassName) {
        List<ComponentNameDescription> nameDescriptions = NamesManager.getNameDescriptions(toolkit, false);
        for (ComponentNameDescription nameDescription : nameDescriptions) {
            if (!nameDescription.getClassName().equals(componentClassName)) continue;
            return nameDescription;
        }
        return null;
    }

    public static List<ComponentNameDescription> getNameDescriptions(ToolkitDescription toolkit, boolean def) {
        final List descriptions = Lists.newArrayList();
        IPreferenceStore preferences = toolkit.getPreferences();
        final String settingsString = def ? preferences.getDefaultString("typeSpecificVariable.store") : preferences.getString("typeSpecificVariable.store");
        if (settingsString.length() == 0) {
            return descriptions;
        }
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                XMLMemento rootMemento = XMLMemento.createReadRoot((Reader)new StringReader(settingsString));
                IMemento[] mementos = rootMemento.getChildren(NamesManager.TYPE_DESCRIPTION_ID);
                int i = 0;
                while (i < mementos.length) {
                    IMemento memento = mementos[i];
                    String className = memento.getString("class");
                    String name = memento.getString("name");
                    String acronym = memento.getString("acronym");
                    boolean asField = "true".equals(memento.getString("asField"));
                    descriptions.add(new ComponentNameDescription(className, name, acronym, asField));
                    ++i;
                }
            }
        });
        return descriptions;
    }

    public static void setDefaultNameDescriptions(ToolkitDescription toolkit, List<ComponentNameDescription> descriptions) {
        String settingsString = NamesManager.getDescriptionsAsString(descriptions);
        IPreferenceStore preferences = toolkit.getPreferences();
        preferences.setDefault("typeSpecificVariable.store", settingsString);
    }

    public static void setNameDescriptions(ToolkitDescription toolkit, List<ComponentNameDescription> descriptions) {
        String settingsString = NamesManager.getDescriptionsAsString(descriptions);
        IPreferenceStore preferences = toolkit.getPreferences();
        preferences.setValue("typeSpecificVariable.store", settingsString);
    }

    private static String getDescriptionsAsString(List<ComponentNameDescription> descriptions) {
        final XMLMemento rootMemento = XMLMemento.createWriteRoot((String)"descriptions");
        for (ComponentNameDescription nameDescription : descriptions) {
            IMemento memento = rootMemento.createChild(TYPE_DESCRIPTION_ID);
            memento.putString("class", nameDescription.getClassName());
            memento.putString("name", nameDescription.getName());
            memento.putString("acronym", nameDescription.getAcronym());
            memento.putString("asField", nameDescription.isAsField() ? "true" : "false");
        }
        return (String)ExecutionUtils.runObject((RunnableObjectEx)new RunnableObjectEx<String>(){

            public String runObject() throws Exception {
                StringWriter writer = new StringWriter();
                rootMemento.save((Writer)writer);
                return writer.toString();
            }
        });
    }

    public static final class ComponentNameDescription {
        private final String m_className;
        private String m_name;
        private String m_acronym;
        private boolean m_asField;

        public ComponentNameDescription(String className, String defaultName, String acronym) {
            this(className, defaultName, acronym, false);
        }

        public ComponentNameDescription(String className, String defaultName, String acronym, boolean asField) {
            this.m_className = className;
            this.m_name = defaultName;
            this.m_acronym = acronym;
            this.m_asField = asField;
        }

        public String getClassName() {
            return this.m_className;
        }

        public String getName() {
            return this.m_name;
        }

        public void setName(String name) {
            this.m_name = name;
        }

        public String getAcronym() {
            return this.m_acronym;
        }

        public void setAcronym(String acronym) {
            this.m_acronym = acronym;
        }

        public boolean isAsField() {
            return this.m_asField;
        }

        public void setAsField(boolean asField) {
            this.m_asField = asField;
        }
    }
}

