/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.nls.bundle.eclipse.old;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.converter.StringConverter;
import org.eclipse.wb.internal.core.model.util.WorkspaceUtils;
import org.eclipse.wb.internal.core.nls.bundle.AbstractBundleSource;
import org.eclipse.wb.internal.core.nls.bundle.eclipse.old.SourceParameters;
import org.eclipse.wb.internal.core.nls.edit.IEditableSource;
import org.eclipse.wb.internal.core.nls.model.AbstractSource;
import org.eclipse.wb.internal.core.nls.model.IKeyGeneratorStrategy;
import org.eclipse.wb.internal.core.nls.model.LocaleInfo;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EclipseSource
extends AbstractBundleSource {
    private final String m_accessorClassName;
    private final boolean m_withDefaultValue;

    @Override
    protected String getBundleComment() {
        return "Eclipse messages class";
    }

    public static List<AbstractSource> getPossibleSources(JavaInfo root, IPackageFragment pkg) throws Exception {
        List sources = Lists.newArrayList();
        IJavaElement[] packageElements = pkg.getChildren();
        int i = 0;
        while (i < packageElements.length) {
            IField field_bundleName;
            IType type;
            ICompilationUnit unit = (ICompilationUnit)packageElements[i];
            if (unit.getElementName().endsWith("Messages.java") && (type = unit.findPrimaryType()) != null && (field_bundleName = type.getField("BUNDLE_NAME")).exists()) {
                IMethod method_getString_1 = CodeUtils.findMethodSingleType(type, "getString(java.lang.String)");
                IMethod method_getString_2 = CodeUtils.findMethodSingleType(type, "getString(java.lang.String,java.lang.String)");
                if (method_getString_1 != null || method_getString_2 != null) {
                    try {
                        String accessorClassName = String.valueOf(pkg.getElementName()) + "." + type.getElementName();
                        EclipseSource source = new EclipseSource(root, accessorClassName, null);
                        sources.add(source);
                    }
                    catch (Throwable e) {
                        DesignerPlugin.log((Throwable)e);
                    }
                }
            }
            ++i;
        }
        return sources;
    }

    public static AbstractSource get(JavaInfo component, GenericProperty property, Expression expression, List<AbstractSource> sources) throws Exception {
        ExpressionInfo expressionInfo = EclipseSource.getExpressionInfo(component, expression);
        if (expressionInfo != null) {
            String accessorClassName = expressionInfo.m_accessorClassName;
            EclipseSource source = EclipseSource.getNewOrExistingSource(component, accessorClassName, sources);
            source.onKeyAdd(component, expressionInfo.m_key);
            return source;
        }
        return null;
    }

    private static EclipseSource getNewOrExistingSource(JavaInfo component, String accessorClassName, List<AbstractSource> sources) throws Exception {
        for (AbstractSource abstractSource : sources) {
            if (!(abstractSource instanceof EclipseSource)) continue;
            EclipseSource source = (EclipseSource)abstractSource;
            if (!source.m_accessorClassName.equals(accessorClassName)) continue;
            return source;
        }
        return new EclipseSource(component.getRootJava(), accessorClassName, null);
    }

    private static ExpressionInfo getExpressionInfo(JavaInfo component, Expression expression) throws Exception {
        if (expression instanceof MethodInvocation) {
            boolean is_getString;
            MethodInvocation getString_invocation = (MethodInvocation)expression;
            int argumentCount = getString_invocation.arguments().size();
            boolean bl = is_getString = getString_invocation.getName().getIdentifier().equals("getString") && (argumentCount == 1 || argumentCount == 2) && getString_invocation.arguments().get(0) instanceof StringLiteral;
            if (!is_getString) {
                return null;
            }
            Expression invocationExpression = getString_invocation.getExpression();
            if (invocationExpression == null) {
                return null;
            }
            String accessorClassName = AstNodeUtils.getFullyQualifiedName(invocationExpression, false);
            String bundleName = EclipseSource.accessor_getBundleName(component, accessorClassName);
            if (bundleName == null) {
                return null;
            }
            StringLiteral keyLiteral = (StringLiteral)getString_invocation.arguments().get(0);
            String key = keyLiteral.getLiteralValue();
            Expression def_argument = argumentCount == 2 ? (Expression)getString_invocation.arguments().get(1) : null;
            StringLiteral defaultLiteral = def_argument instanceof StringLiteral ? (StringLiteral)def_argument : null;
            String defaultValue = defaultLiteral != null ? defaultLiteral.getLiteralValue() : null;
            ExpressionInfo expressionInfo = new ExpressionInfo(expression, accessorClassName, keyLiteral, key, defaultLiteral, defaultValue);
            expression.setProperty("NLS_EXPRESSION_INFO", (Object)expressionInfo);
            return expressionInfo;
        }
        return null;
    }

    private static String accessor_getBundleName(JavaInfo component, String accessorClassName) throws Exception {
        Class<?> accessorClass = EclipseSource.loadClass(component, accessorClassName);
        Field bundleNameField = ReflectionUtils.getFieldByName(accessorClass, (String)"BUNDLE_NAME");
        if (bundleNameField != null) {
            String bundleName = (String)bundleNameField.get(null);
            return bundleName.replace('/', '.');
        }
        return null;
    }

    private static boolean accessor_withDefaultValue(JavaInfo component, String accessorClassName) throws Exception {
        Class<?> accessorClass = EclipseSource.loadClass(component, accessorClassName);
        return ReflectionUtils.getMethodBySignature(accessorClass, (String)"getString(java.lang.String,java.lang.String)") != null;
    }

    private static Class<?> loadClass(JavaInfo component, String className) throws ClassNotFoundException {
        EditorState editorState = EditorState.get(component.getEditor());
        return editorState.getEditorLoader().loadClass(className);
    }

    private ExpressionInfo getExpressionInfo(Expression expression) {
        return (ExpressionInfo)this.getBasicExpressionInfo(expression);
    }

    public EclipseSource(JavaInfo root, String accessorClassName, String bundleName) throws Exception {
        super(root, bundleName != null ? bundleName : EclipseSource.accessor_getBundleName(root, accessorClassName));
        if (accessorClassName != null) {
            this.m_accessorClassName = accessorClassName;
            this.m_withDefaultValue = EclipseSource.accessor_withDefaultValue(root, accessorClassName);
        } else {
            this.m_accessorClassName = null;
            this.m_withDefaultValue = false;
        }
    }

    @Override
    public String getTypeTitle() throws Exception {
        return "Eclipse messages class " + this.m_accessorClassName;
    }

    @Override
    public String getValue(Expression expression) throws Exception {
        ExpressionInfo expressionInfo = this.getExpressionInfo(expression);
        String key = expressionInfo.m_key;
        String defaultValue = expressionInfo.m_defaultValue;
        String value = this.getValue(key);
        return value != null ? value : defaultValue;
    }

    @Override
    public void setValue(Expression expression, String value) throws Exception {
        ExpressionInfo expressionInfo = this.getExpressionInfo(expression);
        String key = expressionInfo.m_key;
        LocaleInfo localeInfo = this.getLocaleInfo();
        this.setValueInBundle(key, value);
        if (localeInfo.isDefault() && expressionInfo.m_defaultExpression != null) {
            String code = StringConverter.INSTANCE.toJavaSource(this.m_root, value);
            StringLiteral newDefaultLiteral = (StringLiteral)this.m_root.getEditor().replaceExpression((Expression)expressionInfo.m_defaultExpression, code);
            expressionInfo.m_defaultExpression = newDefaultLiteral;
            expressionInfo.m_defaultValue = value;
        }
    }

    @Override
    protected IKeyGeneratorStrategy getKeyGeneratorStrategy() {
        return KEY_GENERATOR;
    }

    @Override
    protected Expression apply_renameKey_replaceKeyExpression(AstEditor editor, Expression keyExpression, String newKey) throws Exception {
        String newSource = StringConverter.INSTANCE.toJavaSource(this.m_root, newKey);
        return editor.replaceExpression(keyExpression, newSource);
    }

    @Override
    protected AbstractBundleSource.BasicExpressionInfo apply_externalize_replaceExpression(GenericProperty property, String key) throws Exception {
        Expression expression = property.getExpression();
        String code = String.valueOf(this.m_accessorClassName) + ".getString(" + StringConverter.INSTANCE.toJavaSource(this.m_root, key);
        if (this.m_withDefaultValue) {
            String value = (String)property.getValue();
            code = String.valueOf(code) + ", " + StringConverter.INSTANCE.toJavaSource(this.m_root, value);
        }
        code = String.valueOf(code) + ")";
        ExpressionInfo expressionInfo = (ExpressionInfo)this.replaceExpression_getInfo(expression, code);
        this.addNonNLSComment(expressionInfo.m_keyExpression);
        if (this.m_withDefaultValue) {
            this.addNonNLSComment((Expression)expressionInfo.m_defaultExpression);
        }
        return expressionInfo;
    }

    @Override
    protected void apply_removeNonNLSComments(AbstractBundleSource.BasicExpressionInfo basicExpressionInfo) throws Exception {
        super.apply_removeNonNLSComments(basicExpressionInfo);
        ExpressionInfo expressionInfo = (ExpressionInfo)basicExpressionInfo;
        this.removeNonNLSComment((StringLiteral)expressionInfo.m_keyExpression);
        this.removeNonNLSComment(expressionInfo.m_defaultExpression);
    }

    public static EclipseSource apply_create(IEditableSource editable, JavaInfo root, Object o) throws Exception {
        SourceParameters parameters = (SourceParameters)o;
        if (!parameters.m_accessorExists) {
            String templateName = parameters.m_withDefaultValue ? "newAccessor_default.jvt" : "newAccessor.jvt";
            String template = IOUtils.toString((InputStream)EclipseSource.class.getResourceAsStream(templateName));
            template = StringUtils.replace((String)template, (String)"%PACKAGE_NAME%", (String)parameters.m_accessorPackageName);
            template = StringUtils.replace((String)template, (String)"%CLASS_NAME%", (String)parameters.m_accessorClassName);
            template = StringUtils.replace((String)template, (String)"%BUNDLE_NAME%", (String)parameters.m_propertyBundleName);
            IFolder accessorFolder = (IFolder)parameters.m_accessorPackage.getUnderlyingResource();
            IFile accessorFile = accessorFolder.getFile(String.valueOf(parameters.m_accessorClassName) + ".java");
            accessorFile.create((InputStream)new ByteArrayInputStream(template.getBytes()), true, (IProgressMonitor)new NullProgressMonitor());
            EclipseSource.createPropertyBundleFile(parameters.m_propertyPackage, parameters.m_propertyFileName, null);
            WorkspaceUtils.waitForClass(root.getEditor(), parameters.m_accessorFullClassName);
        }
        return new EclipseSource(root, parameters.m_accessorFullClassName, null);
    }

    private static class ExpressionInfo
    extends AbstractBundleSource.BasicExpressionInfo {
        private final String m_accessorClassName;
        private StringLiteral m_defaultExpression;
        private String m_defaultValue;

        public ExpressionInfo(Expression expression, String accessorClassName, StringLiteral keyExpression, String key, StringLiteral defaultExpression, String defaultValue) {
            super(expression, (Expression)keyExpression, key);
            this.m_accessorClassName = accessorClassName;
            this.m_defaultExpression = defaultExpression;
            this.m_defaultValue = defaultValue;
        }
    }
}

