/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.ui;

import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.ImageURIRegistry;
import org.eclipse.emf.common.ui.viewer.ColumnViewerInformationControlToolTipSupport;
import org.eclipse.emf.common.ui.viewer.IStyledLabelDecorator;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.SegmentSequence;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.provider.StyledString;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.DecoratingColumLabelProvider;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.p2.internal.core.P2Index;
import org.eclipse.oomph.p2.internal.ui.P2UIPlugin;
import org.eclipse.oomph.p2.internal.ui.RepositoryExplorer;
import org.eclipse.oomph.p2.provider.P2EditPlugin;
import org.eclipse.oomph.ui.FilteredTreeWithoutWorkbench;
import org.eclipse.oomph.ui.OomphDialog;
import org.eclipse.oomph.ui.OomphUIPlugin;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.CollectionUtil;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.PatternFilter;

public class SearchEclipseRepositoryDialog
extends OomphDialog {
    public static final String TITLE = "Eclipse Repository Search";
    public static final String MESSAGE = "Search Eclipse repositories by entering the fully qualified name of a Java package or installable unit";
    private String selectedRepository;
    private TreeViewer capabilitiesViewer;
    private TreeViewer detailsViewer;
    private Job detailsLoadJob;

    public SearchEclipseRepositoryDialog(Shell parentShell) {
        super(parentShell, TITLE, 700, 500, (OomphUIPlugin)P2UIPlugin.INSTANCE, false);
        this.setShellStyle(68656);
    }

    protected String getShellText() {
        return TITLE;
    }

    protected String getDefaultMessage() {
        return "Search Eclipse repositories by entering the fully qualified name of a Java package or installable unit.";
    }

    protected String getImagePath() {
        return "wizban/AgentManager.png";
    }

    protected int getContainerMargin() {
        return 10;
    }

    public String getSelectedRepository() {
        return this.selectedRepository;
    }

    public void setSelectedRepository(String selectedElement) {
        Button button = this.getButton(0);
        button.setEnabled(selectedElement != null);
        this.selectedRepository = selectedElement;
    }

    protected void createUI(Composite composite) {
        this.getShell().setImage(P2UIPlugin.INSTANCE.getSWTImage("tool16/search"));
        SashForm sashForm = new SashForm(composite, 66048);
        sashForm.setLayout((Layout)new GridLayout());
        sashForm.setLayoutData((Object)new GridData(1808));
        Composite treeComposite = new Composite((Composite)sashForm, 0);
        treeComposite.setLayout((Layout)UIUtil.createGridLayout((int)1));
        Composite filterComposite = new Composite(treeComposite, 0);
        filterComposite.setLayout((Layout)UIUtil.createGridLayout((int)2));
        filterComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite filterPlaceholder = new Composite(filterComposite, 0);
        filterPlaceholder.setLayout((Layout)UIUtil.createGridLayout((int)1));
        filterPlaceholder.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ToolBar filterToolBar = new ToolBar(filterComposite, 0x820000);
        ToolItem collapseAllButton = new ToolItem(filterToolBar, 0);
        collapseAllButton.setToolTipText("Collapse All");
        collapseAllButton.setImage(P2UIPlugin.INSTANCE.getSWTImage("collapse-all"));
        collapseAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchEclipseRepositoryDialog.this.capabilitiesViewer.collapseAll();
            }
        });
        final ItemFilter filter = new ItemFilter();
        filter.setIncludeLeadingWildcard(true);
        FilteredTreeWithoutWorkbench filteredTree = new FilteredTreeWithoutWorkbench(treeComposite, 2048, (PatternFilter)filter, (FilteredTreeWithoutWorkbench.ExpansionFilter)filter);
        filteredTree.setExpansionCount(100);
        Control filterControl = filteredTree.getChildren()[0];
        filterControl.setParent(filterPlaceholder);
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory();
        this.capabilitiesViewer = filteredTree.getViewer();
        this.capabilitiesViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ToolTipLabelProvider((AdapterFactory)adapterFactory, (Viewer)this.capabilitiesViewer)));
        this.capabilitiesViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory));
        this.capabilitiesViewer.setUseHashlookup(true);
        new ColumnViewerInformationControlToolTipSupport((ColumnViewer)this.capabilitiesViewer, null);
        Tree capabilitiesTree = this.capabilitiesViewer.getTree();
        capabilitiesTree.setLayoutData((Object)new GridData(1808));
        this.capabilitiesViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)SearchEclipseRepositoryDialog.this.capabilitiesViewer.getSelection();
                Item item = (Item)((Object)selection.getFirstElement());
                boolean expanded = SearchEclipseRepositoryDialog.this.capabilitiesViewer.getExpandedState((Object)item);
                SearchEclipseRepositoryDialog.this.capabilitiesViewer.setExpandedState((Object)item, !expanded);
                if (!item.isConcrete()) {
                    block0: while (item != null) {
                        for (Item child : item.getItems()) {
                            if (!filter.isElementVisible((Viewer)SearchEclipseRepositoryDialog.this.capabilitiesViewer, (Object)child)) continue;
                            if (child.isConcrete()) {
                                SearchEclipseRepositoryDialog.this.capabilitiesViewer.setSelection((ISelection)new StructuredSelection((Object)child), true);
                                item = null;
                                continue block0;
                            }
                            SearchEclipseRepositoryDialog.this.capabilitiesViewer.setExpandedState((Object)child, true);
                            item = child;
                            continue block0;
                        }
                    }
                }
            }
        });
        this.capabilitiesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Item item = (Item)((Object)selection.getFirstElement());
                if (item != null && item.isCapability()) {
                    String namespace = item.getNamespace();
                    String name = item.getName();
                    SearchEclipseRepositoryDialog.this.loadDetails(namespace, name);
                } else {
                    SearchEclipseRepositoryDialog.this.detailsViewer.setInput(null);
                }
                SearchEclipseRepositoryDialog.this.setSelectedRepository(null);
            }
        });
        Composite detailsComposite = new Composite((Composite)sashForm, 0);
        detailsComposite.setLayout((Layout)new FillLayout());
        detailsComposite.setForeground(capabilitiesTree.getForeground());
        detailsComposite.setBackground(capabilitiesTree.getBackground());
        this.detailsViewer = new TreeViewer(detailsComposite);
        this.detailsViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ToolTipLabelProvider((AdapterFactory)adapterFactory, (Viewer)this.detailsViewer)));
        this.detailsViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory));
        this.detailsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Item item = (Item)((Object)selection.getFirstElement());
                SearchEclipseRepositoryDialog.this.setSelectedRepository(item != null && item.isRepository() ? item.getText() : null);
            }
        });
        this.detailsViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (SearchEclipseRepositoryDialog.this.selectedRepository != null) {
                    SearchEclipseRepositoryDialog.this.okPressed();
                }
            }
        });
        sashForm.setWeights(new int[]{14, 5});
        UIUtil.asyncExec((Control)composite, (Runnable)new Runnable(){

            public void run() {
                SearchEclipseRepositoryDialog.this.setSelectedRepository(null);
            }
        });
        this.loadModel();
    }

    protected void loadModel() {
        Item root = Item.createItem();
        root.getChildren().add((Object)Item.createNamespaceItem("Loading..."));
        this.capabilitiesViewer.setInput((Object)root);
        Job job = new Job("Capability Loader"){

            protected IStatus run(IProgressMonitor monitor) {
                final Item root = Item.createItem();
                EList children = root.getChildren();
                LinkedHashMap capabilities = new LinkedHashMap(P2Index.INSTANCE.getCapabilities());
                if (capabilities.isEmpty()) {
                    children.add((Object)Item.createNamespaceItem("Index unavailable"));
                } else {
                    Set flavors = (Set)capabilities.get("org.eclipse.equinox.p2.flavor");
                    Set<String> capabilityKeys = capabilities.keySet();
                    RepositoryExplorer.minimizeNamespaces(flavors, capabilityKeys);
                    capabilityKeys.remove("org.eclipse.equinox.p2.flavor");
                    capabilityKeys.remove("A.PDE.Target.Platform");
                    for (Map.Entry entry : capabilities.entrySet()) {
                        String namespace = (String)entry.getKey();
                        Item namespaceItem = Item.createNamespaceItem(namespace);
                        children.add((Object)namespaceItem);
                        LinkedHashMap<SegmentSequence, Item> hierarchicalChildren = new LinkedHashMap<SegmentSequence, Item>();
                        SegmentSequence baseName = SegmentSequence.create((String)".");
                        hierarchicalChildren.put(baseName, namespaceItem);
                        for (String value : (Set)entry.getValue()) {
                            SegmentSequence qualifiedName = SegmentSequence.create((String)".", (String)value);
                            SegmentSequence partialName = baseName;
                            Item parent = namespaceItem;
                            String[] stringArray = qualifiedName.segments();
                            int n = stringArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String segment = stringArray[n2];
                                Item itemProvider = (Item)((Object)hierarchicalChildren.get(partialName = partialName.append(segment)));
                                if (itemProvider == null) {
                                    itemProvider = Item.create(namespace, partialName);
                                    hierarchicalChildren.put(partialName, itemProvider);
                                    parent.getChildren().add((Object)itemProvider);
                                }
                                parent = itemProvider;
                                ++n2;
                            }
                            parent.setConcrete();
                        }
                    }
                    root.sort();
                }
                UIUtil.asyncExec((Control)SearchEclipseRepositoryDialog.this.capabilitiesViewer.getControl(), (Runnable)new Runnable(){

                    public void run() {
                        SearchEclipseRepositoryDialog.this.capabilitiesViewer.setInput((Object)root);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    protected void loadDetails(final String namespace, final String name) {
        if (this.detailsLoadJob != null) {
            this.detailsLoadJob.cancel();
        }
        Item root = Item.createItem();
        root.getChildren().add((Object)Item.createNamespaceItem("Loading..."));
        this.detailsViewer.setInput((Object)root);
        this.detailsLoadJob = new Job("Detail Loader"){

            protected IStatus run(IProgressMonitor monitor) {
                Map capabilitiesFromSimpleRepositories = P2Index.INSTANCE.lookupCapabilities(namespace, name);
                Map capabilitiesFromComposedRepositories = P2Index.INSTANCE.generateCapabilitiesFromComposedRepositories(capabilitiesFromSimpleRepositories);
                CollectionUtil.addAll((Map)capabilitiesFromComposedRepositories, (Map)capabilitiesFromSimpleRepositories);
                TreeMap<Version, Item> versionItems = new TreeMap<Version, Item>();
                for (Map.Entry entry : capabilitiesFromComposedRepositories.entrySet()) {
                    P2Index.Repository key = (P2Index.Repository)entry.getKey();
                    for (Version version : (Set)entry.getValue()) {
                        Item versionItem = (Item)((Object)versionItems.get(version));
                        if (versionItem == null) {
                            versionItem = Item.createVersion(version);
                            versionItems.put(version, versionItem);
                        }
                        versionItem.getChildren().add((Object)Item.createRepository(key));
                    }
                }
                final Item input = Item.createItem();
                Item capabilityItem = Item.create(namespace, name);
                input.getChildren().add((Object)capabilityItem);
                for (Item versionItem : versionItems.values()) {
                    versionItem.sort();
                }
                capabilityItem.getChildren().addAll(versionItems.values());
                ECollections.reverse((EList)capabilityItem.getChildren());
                if (!monitor.isCanceled()) {
                    UIUtil.asyncExec((Control)SearchEclipseRepositoryDialog.this.detailsViewer.getControl(), (Runnable)new Runnable(){

                        public void run() {
                            SearchEclipseRepositoryDialog.this.detailsViewer.setInput((Object)input);
                            SearchEclipseRepositoryDialog.this.detailsViewer.expandToLevel(2);
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        this.detailsLoadJob.setSystem(true);
        this.detailsLoadJob.schedule();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CapabilityComposedImage
    extends ComposedImage {
        private static final Image CONCRETE_CAPABILITY_IMAGE = P2UIPlugin.INSTANCE.getSWTImage("ovr16/concrete_capability");

        private CapabilityComposedImage(Object image) {
            super(Arrays.asList(image, CONCRETE_CAPABILITY_IMAGE));
        }

        public List<ComposedImage.Point> getDrawPoints(ComposedImage.Size size) {
            List result = super.getDrawPoints(size);
            if (result.size() > 1) {
                ((ComposedImage.Point)result.get((int)1)).x += 9;
                ((ComposedImage.Point)result.get((int)1)).y += 9;
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Item
    extends ItemProvider {
        private static final Comparator<String> STRING_COMPARATOR = CommonPlugin.INSTANCE.getComparator();
        private static final Comparator<Item> COMPARATOR = new Comparator<Item>(){

            @Override
            public int compare(Item item1, Item item2) {
                return STRING_COMPARATOR.compare(item1.getText(), item2.getText());
            }
        };
        private static final Image VERSION_IMAGE = P2UIPlugin.INSTANCE.getSWTImage("obj16/version");
        private static final Image NAMESPACE_IMAGE = P2UIPlugin.INSTANCE.getSWTImage("obj16/folder");
        private static final Image CAPABILITY_IMAGE = P2UIPlugin.INSTANCE.getSWTImage("obj16/capability");
        private static final Image REPOSITORY_IMAGE = P2UIPlugin.INSTANCE.getSWTImage("obj16/repository");
        private static final Image JAVA_PACKAGE_IMAGE = ExtendedImageRegistry.INSTANCE.getImage(P2EditPlugin.INSTANCE.getImage("full/obj16/Requirement_Package"));
        private static final Image BUNDLE_IMAGE = ExtendedImageRegistry.INSTANCE.getImage(P2EditPlugin.INSTANCE.getImage("full/obj16/Requirement_Plugin"));
        private static final Image FEATURE_IMAGE = ExtendedImageRegistry.INSTANCE.getImage(P2EditPlugin.INSTANCE.getImage("full/obj16/Requirement_Feature"));
        private String namespace;
        private String name;
        private String decoration;
        private boolean concrete;
        private boolean repository;

        private Item() {
        }

        private Item(String namespace) {
            super(namespace, (Object)NAMESPACE_IMAGE);
            this.namespace = namespace;
        }

        private Item(String namespace, SegmentSequence partialName) {
            super(URI.decode((String)partialName.lastSegment()), (Object)Item.getImage(namespace, partialName.toString()));
            this.namespace = namespace;
            this.name = partialName.toString();
        }

        private Item(String namespace, String name) {
            super(String.valueOf(namespace) + "/" + URI.decode((String)name), (Object)Item.getImage(namespace, name));
            this.namespace = namespace;
            this.name = name;
        }

        private Item(Version version) {
            super(version.toString(), (Object)VERSION_IMAGE);
        }

        private Item(P2Index.Repository repository) {
            super(repository.getLocation().toString(), (Object)REPOSITORY_IMAGE);
            int capabilityCount = repository.getCapabilityCount();
            this.decoration = " " + capabilityCount + (capabilityCount == 1 ? " capability" : " capabilities");
            this.repository = true;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getName() {
            return this.name;
        }

        public boolean isCapability() {
            return this.namespace != null && this.name != null;
        }

        public boolean isRepository() {
            return this.repository;
        }

        public void setConcrete() {
            this.setImage(ExtendedImageRegistry.INSTANCE.getImage((Object)new CapabilityComposedImage(this.getImage())));
            this.concrete = true;
        }

        public boolean isConcrete() {
            return this.concrete;
        }

        public static Item createRepository(P2Index.Repository repository) {
            Item item = new Item(repository);
            EList children = item.getChildren();
            P2Index.Repository[] repositoryArray = repository.getChildren();
            int n = repositoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                P2Index.Repository child = repositoryArray[n2];
                children.add((Object)Item.createRepository(child));
                ++n2;
            }
            return item;
        }

        public static Item createVersion(Version version) {
            return new Item(version);
        }

        public static Item create(String namespace, SegmentSequence partialName) {
            return new Item(namespace, partialName);
        }

        public static Item create(String namespace, String name) {
            return new Item(namespace, name);
        }

        public static Item createItem() {
            return new Item();
        }

        public static Item createNamespaceItem(String namespace) {
            return new Item(namespace);
        }

        public Object getStyledText(Object object) {
            if (this.decoration != null) {
                StyledString styledLabel = new StyledString();
                styledLabel.append(this.getText());
                styledLabel.append(" ");
                styledLabel.append(this.decoration, StyledString.Style.DECORATIONS_STYLER);
                return styledLabel;
            }
            return super.getStyledText(object);
        }

        public EList<Item> getItems() {
            EList children = this.getChildren();
            return children;
        }

        public void sort() {
            EList<Item> children = this.getItems();
            ECollections.sort(children, COMPARATOR);
            for (Item child : children) {
                child.sort();
            }
        }

        private static Image getImage(String namespace, String name) {
            if ("java.package".equals(namespace)) {
                return JAVA_PACKAGE_IMAGE;
            }
            if ("org.eclipse.equinox.p2.iu".equals(namespace)) {
                if (name.endsWith(".feature.group")) {
                    return FEATURE_IMAGE;
                }
                return BUNDLE_IMAGE;
            }
            if ("org.eclipse.update.feature".equals(namespace)) {
                return FEATURE_IMAGE;
            }
            if ("osgi.fragment".equals(namespace) || "osgi.bundle".equals(namespace)) {
                return BUNDLE_IMAGE;
            }
            return CAPABILITY_IMAGE;
        }
    }

    private static final class ItemFilter
    extends PatternFilter
    implements FilteredTreeWithoutWorkbench.ExpansionFilter {
        private ItemFilter() {
        }

        protected boolean isLeafMatch(Viewer viewer, Object element) {
            Item item = (Item)((Object)element);
            String text = item.getName();
            if (text == null) {
                text = item.getText();
            }
            return this.wordMatches(text);
        }

        public boolean shouldExpand(Object element) {
            Item item = (Item)((Object)element);
            return !this.isLeafMatch(null, element) || !item.isCapability();
        }
    }

    public static class ToolTipLabelProvider
    extends DecoratingColumLabelProvider.StyledLabelProvider {
        public ToolTipLabelProvider(AdapterFactory adapterFactory, Viewer viewer) {
            super((ILabelProvider)new AdapterFactoryLabelProvider.StyledLabelProvider(adapterFactory, viewer), (ILabelDecorator)new IStyledLabelDecorator(){

                public void removeListener(ILabelProviderListener listener) {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return true;
                }

                public void dispose() {
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public String decorateText(String text, Object element) {
                    return text;
                }

                public Image decorateImage(Image image, Object element) {
                    return image;
                }

                public org.eclipse.jface.viewers.StyledString decorateStyledText(org.eclipse.jface.viewers.StyledString styledString, Object element) {
                    return styledString;
                }
            });
        }

        public String getToolTipText(Object element) {
            Item item = (Item)((Object)element);
            if (item.isCapability()) {
                StringBuilder result = new StringBuilder();
                result.append(DiagnosticDecorator.enquote((String)("<img src='" + ImageURIRegistry.INSTANCE.getImageURI(ExtendedImageRegistry.INSTANCE.getImage(item.getImage())) + "'/> ")));
                result.append("&nbsp;");
                result.append(item.getNamespace());
                result.append('/');
                result.append(URI.decode((String)item.getName()));
                return result.toString();
            }
            return null;
        }
    }
}

