/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.cdatetime;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.cdatetime.Body;
import org.eclipse.nebula.widgets.cdatetime.Footer;
import org.eclipse.nebula.widgets.cdatetime.Header;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDateTimeBuilder {
    private Header[] headers = new Header[0];
    private Body[] bodies = new Body[0];
    private Footer[] footers = new Footer[0];
    private List<Header> activeHeaders = new ArrayList<Header>();
    private List<Body> activeBodies = new ArrayList<Body>();
    private List<Footer> activeFooters = new ArrayList<Footer>();
    private int headerAlignment;
    private boolean headerEqualColumns;
    private int footerAlignment;
    private boolean footerEqualColumns;

    public static CDateTimeBuilder getCompact() {
        CDateTimeBuilder builder = new CDateTimeBuilder();
        builder.setHeader(Header.MonthPrev(), Header.DateNow(), Header.MonthNext(), Header.Month().align(131072, 4, true), Header.Year(), Header.Time());
        builder.setBody(Body.Days().spacedAt(1).compact(), Body.Months(), Body.Years(), Body.Time());
        return builder;
    }

    public static CDateTimeBuilder getStandard() {
        CDateTimeBuilder builder = new CDateTimeBuilder();
        builder.setHeader(Header.MonthPrev(), Header.MonthNext(), Header.Month().align(16384, 4, true), Header.Year().align(131072, 4, false), Header.YearPrev(), Header.YearNext());
        builder.setBody(Body.Days().spacedAt(1), Body.Months(), Body.Years(), Body.Time().newColumn());
        builder.setFooter(Footer.VerboseToday());
        return builder;
    }

    public List<Body> getBodies() {
        return this.activeBodies;
    }

    public int getFooterAlignment() {
        return this.footerAlignment;
    }

    public boolean getFooterEqualColumns() {
        return this.footerEqualColumns;
    }

    public List<Footer> getFooters() {
        return this.activeFooters;
    }

    public int getHeaderAlignment() {
        return this.headerAlignment;
    }

    public boolean getHeaderEqualColumns() {
        return this.headerEqualColumns;
    }

    public List<Header> getHeaders() {
        return this.activeHeaders;
    }

    public boolean hasBody() {
        return !this.activeBodies.isEmpty();
    }

    public boolean hasBody(int type) {
        for (Body body : this.activeBodies) {
            if (body.type != type) continue;
            return true;
        }
        return false;
    }

    public boolean hasFooter() {
        return !this.activeFooters.isEmpty();
    }

    public boolean hasFooter(int type) {
        for (Footer footer : this.activeFooters) {
            if (footer.type != type) continue;
            return true;
        }
        return false;
    }

    public boolean hasHeader() {
        return !this.activeHeaders.isEmpty();
    }

    public boolean hasHeader(int type) {
        for (Header header : this.activeHeaders) {
            if (header.type != type) continue;
            return true;
        }
        return false;
    }

    public void setBody(Body ... attrs) {
        this.bodies = attrs;
    }

    public void setFields(int[] calendarFields) {
        int f;
        int n;
        int n2;
        int[] nArray;
        int cf;
        int n3;
        int n4;
        int[] nArray2;
        Object a;
        this.activeHeaders.clear();
        this.activeHeaders = new ArrayList<Header>();
        this.activeBodies.clear();
        this.activeBodies = new ArrayList<Body>();
        this.activeFooters.clear();
        this.activeFooters = new ArrayList<Footer>();
        boolean found = false;
        Object[] objectArray = this.bodies;
        int n5 = this.bodies.length;
        int n6 = 0;
        while (n6 < n5) {
            a = objectArray[n6];
            found = false;
            nArray2 = calendarFields;
            n4 = calendarFields.length;
            n3 = 0;
            while (n3 < n4) {
                cf = nArray2[n3];
                nArray = ((Body)a).fields;
                n2 = ((Body)a).fields.length;
                n = 0;
                while (n < n2) {
                    f = nArray[n];
                    if (f == cf) {
                        found = true;
                        break;
                    }
                    ++n;
                }
                if (found) break;
                ++n3;
            }
            if (found) {
                this.activeBodies.add((Body)a);
            }
            ++n6;
        }
        if (this.activeBodies.size() > 1 || this.activeBodies.get((int)0).type == 2) {
            objectArray = this.headers;
            n5 = this.headers.length;
            n6 = 0;
            while (n6 < n5) {
                a = objectArray[n6];
                if (this.activeBodies.size() > 1 || ((Header)a).type == 4 || ((Header)a).type == 3) {
                    found = false;
                    nArray2 = calendarFields;
                    n4 = calendarFields.length;
                    n3 = 0;
                    while (n3 < n4) {
                        cf = nArray2[n3];
                        nArray = ((Header)a).fields;
                        n2 = ((Header)a).fields.length;
                        n = 0;
                        while (n < n2) {
                            f = nArray[n];
                            if (f == cf) {
                                found = true;
                                break;
                            }
                            ++n;
                        }
                        if (found) break;
                        ++n3;
                    }
                    if (found) {
                        this.activeHeaders.add((Header)a);
                    }
                }
                ++n6;
            }
        }
        if (this.activeBodies.size() > 1) {
            objectArray = this.footers;
            n5 = this.footers.length;
            n6 = 0;
            while (n6 < n5) {
                a = objectArray[n6];
                found = false;
                nArray2 = calendarFields;
                n4 = calendarFields.length;
                n3 = 0;
                while (n3 < n4) {
                    cf = nArray2[n3];
                    nArray = ((Footer)a).fields;
                    n2 = ((Footer)a).fields.length;
                    n = 0;
                    while (n < n2) {
                        f = nArray[n];
                        if (f == cf) {
                            found = true;
                            break;
                        }
                        ++n;
                    }
                    if (found) break;
                    ++n3;
                }
                if (found) {
                    this.activeFooters.add((Footer)a);
                }
                ++n6;
            }
        }
    }

    public void setFooter(Footer ... attrs) {
        this.setFooter(4, true, attrs);
    }

    public void setFooter(int alignment, boolean equalColumns, Footer ... attrs) {
        this.footerAlignment = alignment;
        this.footerEqualColumns = equalColumns;
        this.footers = attrs;
    }

    public void setHeader(Header ... attrs) {
        this.setHeader(4, false, attrs);
    }

    public void setHeader(int alignment, boolean equalColumns, Header ... attrs) {
        this.headerAlignment = alignment;
        this.headerEqualColumns = equalColumns;
        this.headers = attrs;
    }
}

