/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp.completion;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Ordering;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.jdt.internal.corext.template.java.JavaContext;
import org.eclipse.jdt.internal.ui.javaeditor.IndentUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.recommenders.internal.snipmatch.rcp.SnippetProposals;
import org.eclipse.recommenders.internal.snipmatch.rcp.l10n.LogMessages;
import org.eclipse.recommenders.internal.snipmatch.rcp.l10n.Messages;
import org.eclipse.recommenders.snipmatch.ISnippet;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.Recommendation;
import org.eclipse.swt.graphics.Image;

public final class SnippetProposal
extends TemplateProposal
implements ICompletionProposalExtension6 {
    private final ISnippet snippet;
    private final int repositoryRelevance;
    private TemplateContext context;
    private Boolean valid = null;

    public static SnippetProposal newSnippetProposal(Recommendation<ISnippet> recommendation, int repositoryRelevance, Template template, TemplateContext context, IRegion region, Image image) throws BadLocationException, TemplateException {
        int relevance = (int)(recommendation.getRelevance() * 100.0);
        return new SnippetProposal((ISnippet)recommendation.getProposal(), relevance, repositoryRelevance, template, context, region, image);
    }

    private SnippetProposal(ISnippet snippet, int relevance, int repositoryRelevance, Template template, TemplateContext context, IRegion region, Image image) {
        super(template, context, region, image, relevance);
        this.repositoryRelevance = repositoryRelevance;
        this.context = context;
        this.snippet = snippet;
    }

    public boolean isValidFor(IDocument document, int offset) {
        return this.isValid();
    }

    private boolean isValid() {
        if (this.valid != null) {
            return this.valid;
        }
        this.valid = false;
        try {
            this.context.evaluate(this.getTemplate());
            this.valid = true;
        }
        catch (Exception e) {
            this.context = new JavaContext(this.context.getContextType(), (IDocument)new Document(), new Position(0), null);
            try {
                this.context.evaluate(this.getTemplate());
            }
            catch (Exception exception) {
                Logs.log((Logs.ILogMessage)LogMessages.ERROR_SNIPPET_COULD_NOT_BE_EVALUATED, (Throwable)e, (Object[])new Object[]{this.snippet.getName(), this.snippet.getUuid()});
                return false;
            }
        }
        return this.valid;
    }

    public String getAdditionalProposalInfo() {
        StringBuilder header = new StringBuilder();
        if (!this.isValid()) {
            header.append(MessageFormat.format(Messages.WARNING_CANNOT_APPLY_SNIPPET, "// XXX"));
            header.append(SystemUtils.LINE_SEPARATOR);
            header.append(MessageFormat.format(Messages.WARNING_REPOSITION_CURSOR, "// TODO"));
            header.append(SystemUtils.LINE_SEPARATOR);
            header.append(SystemUtils.LINE_SEPARATOR);
        }
        if (!StringUtils.isEmpty((CharSequence)this.snippet.getDescription())) {
            header.append("// ");
            header.append(this.snippet.getDescription());
            header.append(SystemUtils.LINE_SEPARATOR);
        }
        try {
            return header + this.fixIndentation(super.getAdditionalProposalInfo());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private String fixIndentation(String additionalProposalInfo) throws BadLocationException {
        Document document = new Document(additionalProposalInfo);
        IndentUtil.indentLines((IDocument)document, (ILineRange)new LineRange(0, document.getNumberOfLines()), null, null);
        return document.get();
    }

    public StyledString getStyledDisplayString() {
        StyledString styledString = new StyledString();
        styledString.append(SnippetProposals.createDisplayString(this.snippet));
        if (!this.snippet.getTags().isEmpty()) {
            styledString.append(" - ", StyledString.QUALIFIER_STYLER);
            styledString.append(Joiner.on((String)", ").join((Iterable)Ordering.natural().sortedCopy((Iterable)this.snippet.getTags())), StyledString.COUNTER_STYLER);
        }
        return styledString;
    }

    public String getDisplayString() {
        return this.getStyledDisplayString().getString();
    }

    public ISnippet getSnippet() {
        return this.snippet;
    }

    public int getRepositoryRelevance() {
        return this.repositoryRelevance;
    }

    @VisibleForTesting
    public TemplateContext getTemplateContext() {
        return this.context;
    }
}

