/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.models.rcp;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.eventbus.EventBus;
import com.google.common.io.Files;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.name.Names;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.recommenders.internal.models.rcp.EclipseModelIndex;
import org.eclipse.recommenders.internal.models.rcp.EclipseModelRepository;
import org.eclipse.recommenders.internal.models.rcp.ModelsRcpPreferences;
import org.eclipse.recommenders.internal.models.rcp.ProjectCoordinateProvider;
import org.eclipse.recommenders.internal.models.rcp.l10n.LogMessages;
import org.eclipse.recommenders.models.IInputStreamTransformer;
import org.eclipse.recommenders.models.IModelArchiveCoordinateAdvisor;
import org.eclipse.recommenders.models.IModelIndex;
import org.eclipse.recommenders.models.IModelRepository;
import org.eclipse.recommenders.models.advisors.ModelIndexBundleSymbolicNameAdvisor;
import org.eclipse.recommenders.models.advisors.SharedManualMappingsAdvisor;
import org.eclipse.recommenders.models.rcp.IProjectCoordinateProvider;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.ui.IWorkbench;

public class ModelsRcpModule
extends AbstractModule {
    private static final String EXT_ID_MODEL_CLASSIFIER = "org.eclipse.recommenders.models.rcp.models";
    private static final String MODEL_CLASSIFIER_ATTRIBUTE = "classifier";
    private static final String EXT_ID_TRANSFORMERS_CLASSIFIER = "org.eclipse.recommenders.models.rcp.transformers";
    private static final String TRANSFORMER_CLASS_ATTRIBUTE = "class";
    private static final String TRANSFORMER_FILE_EXTENSION_ATTRIBUTE = "fileExtension";
    public static final String MODEL_CLASSIFIER = "MODEL_CLASSIFIER";
    public static final String REPOSITORY_BASEDIR = "REPOSITORY_BASEDIR";
    public static final String INDEX_BASEDIR = "INDEX_BASEDIR";

    protected void configure() {
        this.bind(IProjectCoordinateProvider.class).to(ProjectCoordinateProvider.class).in(Scopes.SINGLETON);
        this.bind(EclipseModelIndex.class).in(Scopes.SINGLETON);
        this.bind(IModelArchiveCoordinateAdvisor.class).to(EclipseModelIndex.class);
        this.bind(IModelIndex.class).to(EclipseModelIndex.class);
        this.createAndBindPerWorkspaceNamedFile("index", INDEX_BASEDIR);
        this.bind(EclipseModelRepository.class).in(Scopes.SINGLETON);
        this.bind(IModelRepository.class).to(EclipseModelRepository.class);
        this.createAndBindPerUserNamedFile("repository", REPOSITORY_BASEDIR);
    }

    private void createAndBindPerUserNamedFile(String fileName, String name) {
        File userHome = SystemUtils.getUserHome();
        File dotEclipse = new File(userHome, ".eclipse");
        File stateLocation = new File(dotEclipse, "org.eclipse.recommenders.models.rcp");
        this.createAndBindNamedFile(fileName, name, stateLocation);
    }

    private void createAndBindPerWorkspaceNamedFile(String fileName, String name) {
        File workspaceRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
        File dotRecommenders = new File(workspaceRoot, ".recommenders");
        this.createAndBindNamedFile(fileName, name, dotRecommenders);
    }

    private void createAndBindNamedFile(String fileName, String name, File stateLocation) {
        File file = new File(stateLocation, fileName);
        try {
            Files.createParentDirs((File)file);
        }
        catch (IOException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_BIND_FILE_NAME, (Object[])new Object[]{fileName, e});
        }
        this.bind(File.class).annotatedWith((Annotation)Names.named((String)name)).toInstance((Object)file);
    }

    @Provides
    public ModelIndexBundleSymbolicNameAdvisor provideModelIndexBundleSymbolicNameAdvisor(IModelIndex index) {
        return new ModelIndexBundleSymbolicNameAdvisor(index);
    }

    @Provides
    public SharedManualMappingsAdvisor provideWorkspaceMappingsAdvisor(IModelRepository repository) {
        return new SharedManualMappingsAdvisor(repository);
    }

    @Provides
    @Singleton
    public ModelsRcpPreferences provide(IWorkbench wb, EventBus bus) {
        IEclipseContext context = (IEclipseContext)wb.getService(IEclipseContext.class);
        context.set(EventBus.class, (Object)bus);
        return (ModelsRcpPreferences)ContextInjectionFactory.make(ModelsRcpPreferences.class, (IEclipseContext)context);
    }

    @Provides
    @Named(value="MODEL_CLASSIFIER")
    public ImmutableSet<String> provideModelClassifiers() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXT_ID_MODEL_CLASSIFIER);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String classifier = element.getAttribute(MODEL_CLASSIFIER_ATTRIBUTE);
            builder.add((Object)classifier);
            ++n2;
        }
        return builder.build();
    }

    @Provides
    @Singleton
    public Map<String, IInputStreamTransformer> provideTransformers() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXT_ID_TRANSFORMERS_CLASSIFIER);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                IInputStreamTransformer transformer = (IInputStreamTransformer)element.createExecutableExtension(TRANSFORMER_CLASS_ATTRIBUTE);
                String fileExtension = element.getAttribute(TRANSFORMER_FILE_EXTENSION_ATTRIBUTE);
                builder.put((Object)fileExtension, (Object)transformer);
            }
            catch (CoreException e) {
                Logs.log((Logs.ILogMessage)LogMessages.ERROR_CREATE_EXECUTABLE_EXTENSION_FAILED, (Object[])new Object[]{element.getAttribute(TRANSFORMER_CLASS_ATTRIBUTE), e});
            }
            ++n2;
        }
        return builder.build();
    }
}

