/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import java.util.Arrays;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyUI;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.jdt.internal.ui.callhierarchy.HistoryAction;
import org.eclipse.jdt.internal.ui.callhierarchy.HistoryListAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.PlatformUI;

class HistoryDropDownAction
extends Action
implements IMenuCreator {
    public static final int RESULTS_IN_DROP_DOWN = 10;
    private CallHierarchyViewPart fView;
    private Menu fMenu;

    public HistoryDropDownAction(CallHierarchyViewPart view) {
        this.fView = view;
        this.fMenu = null;
        this.setToolTipText(CallHierarchyMessages.HistoryDropDownAction_tooltip);
        JavaPluginImages.setLocalImageDescriptors((IAction)this, "history_list.png");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.call_hierarchy_history_drop_down_action_context");
        this.setMenuCreator(this);
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        IMember[][] elements = this.fView.getHistoryEntries();
        this.addEntries(this.fMenu, elements);
        new MenuItem(this.fMenu, 2);
        this.addActionToMenu(this.fMenu, new HistoryListAction(this.fView));
        this.addActionToMenu(this.fMenu, new ClearHistoryAction(this.fView));
        return this.fMenu;
    }

    public void dispose() {
        this.fView = null;
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    private boolean addEntries(Menu menu, IMember[][] elements) {
        boolean checked = false;
        int min = Math.min(elements.length, 10);
        int i = 0;
        while (i < min) {
            HistoryAction action = new HistoryAction(this.fView, elements[i]);
            action.setChecked(Arrays.equals(elements[i], this.fView.getInputElements()));
            checked = checked || action.isChecked();
            this.addActionToMenu(menu, action);
            ++i;
        }
        return checked;
    }

    public void run() {
        new HistoryListAction(this.fView).run();
    }

    private static class ClearHistoryAction
    extends Action {
        public ClearHistoryAction(CallHierarchyViewPart view) {
            super(CallHierarchyMessages.HistoryDropDownAction_clearhistory_label);
        }

        public void run() {
            CallHierarchyUI.getDefault().clearHistory();
        }
    }
}

