/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.conversion;

import java.util.HashMap;
import java.util.Map;
import org.mvel2.ConversionException;
import org.mvel2.ConversionHandler;
import org.mvel2.conversion.Converter;

public class ByteCH
implements ConversionHandler {
    private static final Map<Class, Converter> CNV = new HashMap<Class, Converter>();
    private static Converter stringConverter = new Converter(){

        public Object convert(Object o) {
            return Byte.parseByte((String)o);
        }
    };

    static {
        CNV.put(String.class, stringConverter);
        CNV.put(Object.class, new Converter(){

            public Object convert(Object o) {
                return stringConverter.convert(String.valueOf(o));
            }
        });
        CNV.put(Byte.class, new Converter(){

            public Object convert(Object o) {
                return new Byte((Byte)o);
            }
        });
        CNV.put(Integer.class, new Converter(){

            public Object convert(Object o) {
                return (byte)((Integer)o).intValue();
            }
        });
    }

    public Object convertFrom(Object in) {
        if (!CNV.containsKey(in.getClass())) {
            throw new ConversionException("cannot convert type: " + in.getClass().getName() + " to: " + Integer.class.getName());
        }
        return CNV.get(in.getClass()).convert(in);
    }

    public boolean canConvertFrom(Class cls) {
        return CNV.containsKey(cls);
    }
}

